/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.abyssallib.world.item;

import com.github.darksoulq.abyssallib.AbyssalLib;
import com.github.darksoulq.abyssallib.common.util.CTag;
import com.github.darksoulq.abyssallib.common.util.Identifier;
import com.github.darksoulq.abyssallib.server.event.ActionResult;
import com.github.darksoulq.abyssallib.server.event.context.item.AnvilContext;
import com.github.darksoulq.abyssallib.server.event.context.item.UseContext;
import com.github.darksoulq.abyssallib.server.registry.Registries;
import com.github.darksoulq.abyssallib.world.block.CustomBlock;
import com.github.darksoulq.abyssallib.world.data.tag.impl.ItemTag;
import com.github.darksoulq.abyssallib.world.item.component.ComponentMap;
import com.github.darksoulq.abyssallib.world.item.component.DataComponent;
import com.github.darksoulq.abyssallib.world.item.component.builtin.CustomMarker;
import com.github.darksoulq.abyssallib.world.item.component.builtin.DisplayTooltip;
import com.github.darksoulq.abyssallib.world.item.component.builtin.ItemModel;
import com.github.darksoulq.abyssallib.world.item.component.builtin.ItemName;
import com.github.darksoulq.abyssallib.world.item.component.builtin.Lore;
import com.github.darksoulq.abyssallib.world.item.component.builtin.TooltipStyle;
import io.papermc.paper.datacomponent.DataComponentType;
import io.papermc.paper.datacomponent.item.ItemLore;
import io.papermc.paper.datacomponent.item.TooltipDisplay;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.component.CustomData;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

public class Item
implements Cloneable {
    private Identifier id;
    private ItemStack stack;
    private ComponentMap componentMap;
    public Tooltip tooltip = new Tooltip();

    private Item(ItemStack stack) {
        this.id = Identifier.of("unknown", "unknown");
        this.stack = stack;
        this.componentMap = new ComponentMap(this);
    }

    public Item(Identifier id, Material base) {
        this.id = id;
        this.stack = ItemStack.of((Material)base);
        this.componentMap = new ComponentMap(this);
        for (Identifier cId : this.componentMap.getVanillaIds()) {
            this.componentMap.removeData(cId);
        }
        this.setData(new ItemName((Component)Component.translatable((String)("item." + id.getNamespace() + "." + id.getPath()))));
        this.setData(new ItemModel((Key)id.asNamespacedKey()));
        this.setData(new CustomMarker(id));
    }

    public void createTooltip(Tooltip tooltip) {
    }

    public void updateTooltip() {
        this.setData(new Lore(ItemLore.lore(this.tooltip.lines)));
        this.setData(new DisplayTooltip((TooltipDisplay)TooltipDisplay.tooltipDisplay().hideTooltip(this.tooltip.hide).hiddenComponents(this.tooltip.hiddenComponents).build()));
        if (this.tooltip.style != null) {
            this.setData(new TooltipStyle((Key)this.tooltip.style.asNamespacedKey()));
        } else {
            this.unsetData(TooltipStyle.class);
        }
    }

    public void setData(DataComponent<?> component) {
        this.componentMap.setData(component);
    }

    public DataComponent<?> getData(Identifier id) {
        return this.componentMap.getData(id);
    }

    public DataComponent<?> getData(DataComponentType type) {
        return this.componentMap.getData(type);
    }

    public <T extends DataComponent<?>> DataComponent<?> getData(Class<T> clazz) {
        return (DataComponent)clazz.cast(this.componentMap.getData(clazz));
    }

    public boolean hasData(Identifier id) {
        return this.componentMap.hasData(id);
    }

    public boolean hasData(DataComponentType type) {
        return this.componentMap.hasData(type);
    }

    public void unsetData(Identifier id) {
        this.componentMap.removeData(id);
    }

    public void unsetData(Class<? extends DataComponent> clazz) {
        this.componentMap.removeData(clazz);
    }

    public <T extends DataComponent<?>> boolean hasData(Class<T> clazz) {
        return this.componentMap.hasData(clazz);
    }

    public boolean hasTag(Identifier id) {
        com.github.darksoulq.abyssallib.world.data.tag.Tag<?> tag = Registries.TAGS.get(id.toString());
        if (!(tag instanceof ItemTag)) {
            AbyssalLib.getInstance().getLogger().severe("Unknown tag: " + String.valueOf(id));
            return false;
        }
        ItemTag tag2 = (ItemTag)tag;
        return tag2.contains(this.stack);
    }

    public ActionResult postMine(LivingEntity source, Block target) {
        return ActionResult.PASS;
    }

    public ActionResult postHit(LivingEntity source, Entity target) {
        return ActionResult.PASS;
    }

    public ActionResult onUseOn(UseContext ctx) {
        return ActionResult.PASS;
    }

    public void onUse(LivingEntity source, EquipmentSlot hand) {
    }

    public ActionResult onAnvilPrepare(AnvilContext ctx) {
        return ActionResult.PASS;
    }

    public void onCraftedBy(Player player) {
    }

    public Identifier getId() {
        return this.id;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public ComponentMap getComponentMap() {
        return this.componentMap;
    }

    public CTag getCTag() {
        CompoundTag tag;
        net.minecraft.world.item.ItemStack nms = CraftItemStack.asNMSCopy((ItemStack)this.stack);
        CustomData dta = (CustomData)nms.get(DataComponents.CUSTOM_DATA);
        if (dta == null) {
            dta = CustomData.EMPTY;
        }
        if ((tag = dta.copyTag()).getCompound("CustomData").isPresent()) {
            CompoundTag custom = (CompoundTag)tag.getCompound("CustomData").get();
            return new CTag(custom);
        }
        tag.put("CustomData", (Tag)new CompoundTag());
        return new CTag((CompoundTag)tag.getCompound("CustomData").get());
    }

    public void setCTag(CTag container) {
        net.minecraft.world.item.ItemStack nms = CraftItemStack.asNMSCopy((ItemStack)this.stack);
        CustomData data = (CustomData)nms.get(DataComponents.CUSTOM_DATA);
        if (data == null) {
            data = CustomData.EMPTY;
        }
        CompoundTag tag = data.copyTag();
        tag.put("CustomData", (Tag)container.toVanilla());
        data = CustomData.of((CompoundTag)tag);
        nms.set(DataComponents.CUSTOM_DATA, (Object)data);
        ItemStack updated = CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)nms);
        this.stack.setItemMeta(updated.getItemMeta());
    }

    public static Item resolve(ItemStack stack) {
        if (stack == null || stack.getType().isAir()) {
            return null;
        }
        Item base = new Item(stack);
        if (!base.hasData(CustomMarker.class)) {
            return null;
        }
        Identifier id = (Identifier)base.getData(CustomMarker.class).value;
        if (id == null) {
            return null;
        }
        Item clone = Registries.ITEMS.get(id.toString()).clone();
        clone.stack = stack;
        clone.componentMap = new ComponentMap(clone);
        return clone;
    }

    public static CustomBlock asBlock(Item item) {
        if (!item.hasData(Identifier.of("abyssallib:block_item"))) {
            return null;
        }
        Identifier blockId = (Identifier)item.getData((Identifier)Identifier.of((String)"abyssallib:block_item")).value;
        return Registries.BLOCKS.get(blockId.toString()).clone();
    }

    public Item clone() {
        try {
            Item item = (Item)super.clone();
            item.id = this.id;
            item.stack = this.stack.clone();
            item.componentMap = new ComponentMap(item);
            item.tooltip = new Tooltip();
            item.tooltip.hide = this.tooltip.hide;
            item.tooltip.style = this.tooltip.style;
            item.tooltip.lines = new ArrayList<Component>(this.tooltip.lines);
            item.tooltip.hiddenComponents = new HashSet<DataComponentType>(this.tooltip.hiddenComponents);
            return item;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof Item)) {
            return false;
        }
        Item item = (Item)o;
        return Objects.equals(this.id, item.id);
    }

    public int hashCode() {
        return Objects.hashCode(this.id);
    }

    public static class Tooltip {
        private boolean hide;
        public List<Component> lines = new ArrayList<Component>();
        public Set<DataComponentType> hiddenComponents = new HashSet<DataComponentType>();
        private Identifier style = null;

        public void setVisible(boolean v) {
            this.hide = !v;
        }

        public void withHidden(DataComponentType type) {
            this.hiddenComponents.add(type);
        }

        public void addLine(Component component) {
            this.lines.add(component);
        }

        public void withStyle(Identifier style) {
            this.style = style;
        }

        public Identifier getStyle() {
            return this.style;
        }

        public boolean isVisible() {
            return this.hide;
        }

        public Component getLine(int index) {
            return this.lines.get(index);
        }
    }
}

