/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.abyssallib.world.item.component;

import com.github.darksoulq.abyssallib.common.serialization.Codec;
import com.github.darksoulq.abyssallib.common.util.Identifier;
import java.util.Objects;

public abstract class DataComponent<T> {
    private final Identifier id;
    public final Codec<DataComponent<T>> codec;
    public final T value;

    public DataComponent(Identifier id, T defaultValue, Codec<? extends DataComponent<T>> codec) {
        this.id = id;
        Codec<DataComponent<DataComponent<T>>> safeCodec = codec;
        this.codec = safeCodec;
        this.value = defaultValue;
    }

    public Identifier getId() {
        return this.id;
    }

    public T getValue() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DataComponent other = (DataComponent)obj;
        if (!this.id.equals(other.id)) {
            return false;
        }
        return Objects.equals(this.value, other.value);
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }
}

