/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.abyssallib.world.multiblock;

import com.github.darksoulq.abyssallib.world.multiblock.Multiblock;
import com.github.darksoulq.abyssallib.world.multiblock.MultiblockChoice;
import com.github.darksoulq.abyssallib.world.multiblock.MultiblockData;
import com.github.darksoulq.abyssallib.world.multiblock.RelativeBlockPos;
import com.github.darksoulq.abyssallib.world.multiblock.Tickable;
import org.bukkit.Location;
import org.bukkit.block.Block;

public class MultiblockInstance {
    private final Location origin;
    private final Multiblock type;
    private MultiblockData data;

    public MultiblockInstance(Location origin, Multiblock type) {
        this.origin = origin;
        this.type = type;
        this.data = type.createData();
    }

    public MultiblockChoice getChoiceAtBlock(Block block) {
        if (!block.getWorld().equals((Object)this.origin.getWorld())) {
            return null;
        }
        int dx = block.getX() - this.origin.getBlockX();
        int dy = block.getY() - this.origin.getBlockY();
        int dz = block.getZ() - this.origin.getBlockZ();
        return this.type.getPattern().get(new RelativeBlockPos(dx, dy, dz));
    }

    public Location getOrigin() {
        return this.origin;
    }

    public Multiblock getType() {
        return this.type;
    }

    public MultiblockData getData() {
        return this.data;
    }

    public void setData(MultiblockData data) {
        this.data = data;
    }

    public void tickIfApplicable() {
        Multiblock multiblock = this.type;
        if (multiblock instanceof Tickable) {
            Tickable t = (Tickable)((Object)multiblock);
            t.tick(this);
        }
    }
}

