/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.abyssallib.common.database.impl.sqlite;

import com.github.darksoulq.abyssallib.common.database.TableBuilder;
import java.sql.Connection;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SqliteTableBuilder
implements TableBuilder {
    private final Connection conn;
    private final String table;
    private boolean ifNotExists = false;
    private final List<String> columns = new ArrayList<String>();
    private final List<String> primaryKeys = new ArrayList<String>();
    private final List<String> foreignKeys = new ArrayList<String>();
    private final List<String> uniqueColumns = new ArrayList<String>();
    private final List<String> checkConstraints = new ArrayList<String>();
    private final Map<String, String> defaultValues = new HashMap<String, String>();

    public SqliteTableBuilder(Connection conn, String table) {
        this.conn = conn;
        this.table = table;
    }

    @Override
    public TableBuilder ifNotExists() {
        this.ifNotExists = true;
        return this;
    }

    @Override
    public TableBuilder column(String name, String type) {
        StringBuilder columnDef = new StringBuilder(name + " " + type);
        if (this.defaultValues.containsKey(name)) {
            columnDef.append(" DEFAULT ").append(this.defaultValues.get(name));
        }
        this.columns.add(columnDef.toString());
        return this;
    }

    @Override
    public TableBuilder primaryKey(String ... keys) {
        this.primaryKeys.addAll(List.of(keys));
        return this;
    }

    @Override
    public TableBuilder foreignKey(String column, String referencesTable, String referencesColumn) {
        this.foreignKeys.add("FOREIGN KEY (" + column + ") REFERENCES " + referencesTable + " (" + referencesColumn + ")");
        return this;
    }

    @Override
    public TableBuilder unique(String ... columns) {
        this.uniqueColumns.add("UNIQUE (" + String.join((CharSequence)", ", columns) + ")");
        return this;
    }

    @Override
    public TableBuilder check(String expression) {
        this.checkConstraints.add("CHECK (" + expression + ")");
        return this;
    }

    @Override
    public TableBuilder defaultValue(String column, String defaultValue) {
        this.defaultValues.put(column, defaultValue);
        return this;
    }

    @Override
    public void execute() {
        StringBuilder sql = new StringBuilder("CREATE TABLE ");
        if (this.ifNotExists) {
            sql.append("IF NOT EXISTS ");
        }
        sql.append(this.table).append(" (");
        sql.append(String.join((CharSequence)", ", this.columns));
        if (!this.primaryKeys.isEmpty()) {
            sql.append(", PRIMARY KEY(").append(String.join((CharSequence)", ", this.primaryKeys)).append(")");
        }
        if (!this.foreignKeys.isEmpty()) {
            sql.append(", ").append(String.join((CharSequence)", ", this.foreignKeys));
        }
        if (!this.uniqueColumns.isEmpty()) {
            sql.append(", ").append(String.join((CharSequence)", ", this.uniqueColumns));
        }
        if (!this.checkConstraints.isEmpty()) {
            sql.append(", ").append(String.join((CharSequence)", ", this.checkConstraints));
        }
        sql.append(")");
        try (Statement stmt = this.conn.createStatement();){
            stmt.execute(sql.toString());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create table: " + this.table, e);
        }
    }
}

