/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.abyssallib.server.bridge;

import com.github.darksoulq.abyssallib.AbyssalLib;
import com.github.darksoulq.abyssallib.common.util.Identifier;
import com.github.darksoulq.abyssallib.server.HookConstants;
import com.github.darksoulq.abyssallib.server.bridge.Provider;
import com.github.darksoulq.abyssallib.server.bridge.item.AbyssalLibProvider;
import com.github.darksoulq.abyssallib.server.bridge.item.MinecraftProvider;
import com.github.darksoulq.abyssallib.server.bridge.item.NexoProvider;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.inventory.ItemStack;

public class ItemBridge {
    private static final Map<String, Provider<ItemStack>> PROVIDERS = new HashMap<String, Provider<ItemStack>>();

    public static void setup() {
        ItemBridge.register(new MinecraftProvider());
        ItemBridge.register(new AbyssalLibProvider());
        if (HookConstants.isEnabled(HookConstants.Plugin.NEXO)) {
            ItemBridge.register(new NexoProvider());
        }
    }

    public static boolean hasProvider(String id) {
        if (!Identifier.isValid2Part(id) && !Identifier.isValid3Part(id)) {
            return false;
        }
        Identifier idd = Identifier.of(id);
        return PROVIDERS.containsKey(idd.getKey() == null ? idd.getNamespace() : idd.getKey());
    }

    public static boolean hasProvider(ItemStack item) {
        for (Provider<ItemStack> prov : PROVIDERS.values()) {
            if (!prov.belongs(item)) continue;
            return true;
        }
        return false;
    }

    public static ItemStack get(String id) {
        if (Identifier.isValid3Part(id) || Identifier.isValid2Part(id)) {
            return ItemBridge.get(Identifier.of(id));
        }
        return ItemStack.deserializeBytes((byte[])Base64.getDecoder().decode(id));
    }

    public static ItemStack get(Identifier id) {
        if (!PROVIDERS.containsKey(id.getKey()) && !PROVIDERS.containsKey(id.getNamespace())) {
            AbyssalLib.LOGGER.warning("No Provider Found for " + String.valueOf(id));
            return null;
        }
        Provider<ItemStack> prov = PROVIDERS.get(id.getKey() == null ? id.getNamespace() : id.getKey());
        if (id.getKey() != null) {
            return prov.get(Identifier.of(id.getNamespace(), id.getPath()));
        }
        return prov.get(id);
    }

    public static Identifier getId(ItemStack stack) {
        for (Map.Entry<String, Provider<ItemStack>> entry : PROVIDERS.entrySet()) {
            Provider<ItemStack> prov = entry.getValue();
            if (!prov.belongs(stack)) continue;
            Identifier base = prov.getId(stack);
            if (base == null) {
                return null;
            }
            if (prov instanceof MinecraftProvider) {
                return base;
            }
            return Identifier.of(entry.getKey(), base.getNamespace(), base.getPath());
        }
        return null;
    }

    public static String getIdAsString(ItemStack stack) {
        Identifier id = ItemBridge.getId(stack);
        if (id == null) {
            return ItemBridge.asString(stack);
        }
        return id.toString();
    }

    public static String asString(ItemStack item) {
        return Base64.getEncoder().encodeToString(item.serializeAsBytes());
    }

    public static Map<String, Integer> asAmountMap(ItemStack item) {
        Identifier id = ItemBridge.getId(item);
        if (id == null) {
            return null;
        }
        return Map.of(id.toString(), item.getAmount());
    }

    public static void register(Provider<ItemStack> provider) {
        PROVIDERS.put(provider.getPrefix(), provider);
    }
}

