/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.abyssallib.server.chat;

import com.github.darksoulq.abyssallib.AbyssalLib;
import com.github.darksoulq.abyssallib.server.event.SubscribeEvent;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.entity.Player;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ChatInputHandler {
    private static final Map<UUID, Consumer<String>> inputMap = new ConcurrentHashMap<UUID, Consumer<String>>();

    public static void await(Player player, Consumer<String> inputHandler) {
        ChatInputHandler.registerAwait(player, inputHandler, MiniMessage.miniMessage().deserialize((Object)"<gray>[<bold>Abyssal</bold></gray>] Please type your input in chat."), -1L);
    }

    public static void await(Player player, Consumer<String> inputHandler, Component prompt) {
        ChatInputHandler.registerAwait(player, inputHandler, prompt, -1L);
    }

    public static void await(Player player, Consumer<String> inputHandler, long timeoutTicks) {
        ChatInputHandler.registerAwait(player, inputHandler, MiniMessage.miniMessage().deserialize((Object)"<gray>[<bold>Abyssal</bold></gray>] Please type your input in chat."), timeoutTicks);
    }

    public static void await(Player player, Consumer<String> inputHandler, Component prompt, long timeoutTicks) {
        ChatInputHandler.registerAwait(player, inputHandler, prompt, timeoutTicks);
    }

    public static boolean cancel(Player player) {
        return inputMap.remove(player.getUniqueId()) != null;
    }

    private static void registerAwait(final Player player, Consumer<String> inputHandler, Component prompt, long timeoutTicks) {
        final UUID uuid = player.getUniqueId();
        inputMap.put(uuid, inputHandler);
        if (prompt != null) {
            player.sendMessage(prompt);
        }
        if (timeoutTicks > 0L) {
            new BukkitRunnable(){

                public void run() {
                    Consumer<String> removed = inputMap.remove(uuid);
                    if (removed != null) {
                        player.sendMessage("\u00a77[\u00a7cTimeout\u00a77] \u00a7fInput request expired.");
                    }
                }
            }.runTaskLater((Plugin)AbyssalLib.getInstance(), timeoutTicks);
        }
    }

    @SubscribeEvent
    public void onChat(AsyncPlayerChatEvent event) {
        UUID uuid = event.getPlayer().getUniqueId();
        final Consumer<String> handler = inputMap.remove(uuid);
        if (handler != null) {
            event.setCancelled(true);
            final String message = event.getMessage();
            new BukkitRunnable(this){

                public void run() {
                    handler.accept(message);
                }
            }.runTask((Plugin)AbyssalLib.getInstance());
        }
    }
}

