/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.abyssallib.server.event.internal;

import com.destroystokyo.paper.event.entity.EntityAddToWorldEvent;
import com.destroystokyo.paper.event.entity.EntityRemoveFromWorldEvent;
import com.github.darksoulq.abyssallib.server.event.ActionResult;
import com.github.darksoulq.abyssallib.server.event.EventBus;
import com.github.darksoulq.abyssallib.server.event.SubscribeEvent;
import com.github.darksoulq.abyssallib.server.event.custom.entity.EntityDeathEvent;
import com.github.darksoulq.abyssallib.server.event.custom.entity.EntityLoadEvent;
import com.github.darksoulq.abyssallib.world.entity.internal.EntityManager;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;

public class EntityEvents {
    @SubscribeEvent
    public void onEntityLoad(EntityAddToWorldEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity lEntity = (LivingEntity)entity;
        com.github.darksoulq.abyssallib.world.entity.Entity<? extends LivingEntity> entity2 = EntityManager.get(lEntity.getUniqueId());
        if (entity2 == null) {
            return;
        }
        entity2.applyGoals();
        entity2.applyAttributes();
        entity2.applyComponents();
        EventBus.post(new EntityLoadEvent(entity2));
        entity2.onLoad();
    }

    @SubscribeEvent
    public void onEntityDeath(org.bukkit.event.entity.EntityDeathEvent event) {
        com.github.darksoulq.abyssallib.world.entity.Entity<LivingEntity> entity = com.github.darksoulq.abyssallib.world.entity.Entity.resolve((Entity)event.getEntity());
        if (entity == null) {
            return;
        }
        EntityDeathEvent e = new EntityDeathEvent(entity, (Entity)event.getEntity().getKiller());
        EventBus.post(e);
        if (e.isCancelled()) {
            event.setCancelled(true);
            return;
        }
        if (entity.onDeath(event).equals((Object)ActionResult.CANCEL)) {
            event.setCancelled(true);
            return;
        }
        EntityManager.remove(entity.uuid);
    }

    @SubscribeEvent
    public void onEntityUnload(EntityRemoveFromWorldEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity lEntity = (LivingEntity)entity;
        com.github.darksoulq.abyssallib.world.entity.Entity<? extends LivingEntity> entity2 = EntityManager.get(lEntity.getUniqueId());
        if (entity2 == null) {
            return;
        }
        entity2.onUnload();
    }
}

