/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.abyssallib.server.registry;

import com.github.darksoulq.abyssallib.AbyssalLib;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Collections;
import java.util.Map;

public final class Registry<T> {
    private final BiMap<String, T> entries = HashBiMap.create();

    public void register(String id, T object) {
        if (this.entries.containsKey((Object)id)) {
            AbyssalLib.getInstance().getLogger().severe("ID '" + id + "' already registered! Skipping...");
            return;
        }
        this.entries.put((Object)id, object);
    }

    public T get(String id) {
        return (T)this.entries.get((Object)id);
    }

    public String getId(T value) {
        return (String)this.entries.inverse().get(value);
    }

    public boolean contains(String id) {
        return this.entries.containsKey((Object)id);
    }

    public Map<String, T> getAll() {
        return Collections.unmodifiableMap(this.entries);
    }
}

