/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.abyssallib.server.resource;

import com.github.darksoulq.abyssallib.server.resource.ResourcePack;
import com.github.darksoulq.abyssallib.server.resource.asset.Asset;
import com.github.darksoulq.abyssallib.server.resource.asset.BlockState;
import com.github.darksoulq.abyssallib.server.resource.asset.Equipment;
import com.github.darksoulq.abyssallib.server.resource.asset.Font;
import com.github.darksoulq.abyssallib.server.resource.asset.ItemDefinition;
import com.github.darksoulq.abyssallib.server.resource.asset.JsonAsset;
import com.github.darksoulq.abyssallib.server.resource.asset.Lang;
import com.github.darksoulq.abyssallib.server.resource.asset.McMeta;
import com.github.darksoulq.abyssallib.server.resource.asset.Model;
import com.github.darksoulq.abyssallib.server.resource.asset.PostEffect;
import com.github.darksoulq.abyssallib.server.resource.asset.Sounds;
import com.github.darksoulq.abyssallib.server.resource.asset.Texture;
import com.github.darksoulq.abyssallib.server.resource.asset.WaypointStyle;
import com.github.darksoulq.abyssallib.server.resource.asset.definition.Selector;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Namespace {
    private final Plugin plugin;
    private final String namespace;
    private final ResourcePack pack;
    private final List<Asset> assets = new ArrayList<Asset>();
    private Texture icon = null;

    public Namespace(@NotNull String namespace, @NotNull ResourcePack pack) {
        this.plugin = pack.getPlugin();
        this.namespace = namespace;
        this.pack = pack;
    }

    @NotNull
    public Texture texture(@NotNull String path) {
        return this.texture(path, null);
    }

    @NotNull
    public Texture texture(@NotNull String path, byte @Nullable [] data) {
        Texture t = data == null ? new Texture(this.plugin, this.namespace, path) : new Texture(this.namespace, path, data);
        this.assets.add(t);
        return t;
    }

    public McMeta mcmeta(String path, boolean autoLoad) {
        McMeta m = new McMeta(this.plugin, this.namespace, path, autoLoad);
        this.assets.add(m);
        return m;
    }

    public McMeta mcmeta(String path, byte[] data) {
        McMeta m = new McMeta(this.namespace, path, data);
        this.assets.add(m);
        return m;
    }

    public WaypointStyle waypointStyle(String name, boolean autoLoad) {
        WaypointStyle w = autoLoad ? new WaypointStyle(this.plugin, this.namespace, name) : new WaypointStyle(this.namespace, name);
        this.assets.add(w);
        return w;
    }

    public WaypointStyle waypointStyle(String name, byte[] data) {
        WaypointStyle w = new WaypointStyle(this.namespace, name, data);
        this.assets.add(w);
        return w;
    }

    public PostEffect postEffect(String name, boolean autoLoad) {
        PostEffect p = autoLoad ? new PostEffect(this.plugin, this.namespace, name) : new PostEffect(this.namespace, name);
        this.assets.add(p);
        return p;
    }

    public PostEffect postEffect(String name, byte[] data) {
        PostEffect p = new PostEffect(this.namespace, name, data);
        this.assets.add(p);
        return p;
    }

    @NotNull
    public Font font(@NotNull String name, boolean autoLoad) {
        Font f = autoLoad ? new Font(this.plugin, this.namespace, name) : new Font(this.namespace, name);
        this.assets.add(f);
        return f;
    }

    @NotNull
    public Font font(@NotNull String name, byte[] data) {
        Font f = new Font(this.namespace, name, data);
        this.assets.add(f);
        return f;
    }

    @NotNull
    public Model model(@NotNull String name, boolean autoLoad) {
        Model m = autoLoad ? new Model(this.plugin, this.namespace, name) : new Model(this.namespace, name);
        this.assets.add(m);
        return m;
    }

    @NotNull
    public Model model(@NotNull String name, byte[] data) {
        Model m = new Model(this.namespace, name, data);
        this.assets.add(m);
        return m;
    }

    @NotNull
    public Model model(@NotNull String name, int texWidth, int texHeight) {
        Model m = new Model(this.namespace, name, texWidth, texHeight);
        this.assets.add(m);
        return m;
    }

    public BlockState blockstate(String name, boolean autoLoad) {
        BlockState b = autoLoad ? new BlockState(this.plugin, this.namespace, name) : new BlockState(this.namespace, name);
        this.assets.add(b);
        return b;
    }

    public BlockState blockstate(String name, byte[] data) {
        BlockState b = new BlockState(this.namespace, name, data);
        this.assets.add(b);
        return b;
    }

    @NotNull
    public Lang lang(@NotNull String locale, boolean autoLoad) {
        Lang lang = autoLoad ? new Lang(this.plugin, this.namespace, locale) : new Lang(this.namespace, locale);
        this.assets.add(lang);
        return lang;
    }

    @NotNull
    public Lang lang(@NotNull String locale, byte[] data) {
        Lang lang = new Lang(this.namespace, locale, data);
        this.assets.add(lang);
        return lang;
    }

    @NotNull
    public Sounds sounds() {
        Sounds s = new Sounds(this.plugin, this.namespace);
        this.assets.add(s);
        return s;
    }

    @NotNull
    public ItemDefinition itemDefinition(@NotNull String name) {
        ItemDefinition def = new ItemDefinition(this.plugin, this.namespace, name);
        this.assets.add(def);
        return def;
    }

    @NotNull
    public ItemDefinition itemDefinition(@NotNull String name, byte[] data) {
        ItemDefinition def = new ItemDefinition(this.namespace, name, data);
        this.assets.add(def);
        return def;
    }

    public ItemDefinition itemDefinition(@NotNull String name, @NotNull Selector selector) {
        return this.itemDefinition(name, selector, true, false);
    }

    public ItemDefinition itemDefinition(@NotNull String name, @NotNull Selector selector, boolean handAnimationOnSwap) {
        return this.itemDefinition(name, selector, handAnimationOnSwap, false);
    }

    public ItemDefinition itemDefinition(@NotNull String name, @NotNull Selector selector, boolean handAnimationOnSwap, boolean oversizedInGui) {
        ItemDefinition def = new ItemDefinition(this.namespace, name, selector, handAnimationOnSwap, oversizedInGui);
        this.assets.add(def);
        return def;
    }

    public Equipment equipment(String path, boolean autoLoad) {
        Equipment e = autoLoad ? new Equipment(this.plugin, this.namespace, path) : new Equipment(this.namespace, path);
        this.assets.add(e);
        return e;
    }

    public Equipment equipment(String path, byte[] data) {
        Equipment e = new Equipment(this.namespace, path, data);
        this.assets.add(e);
        return e;
    }

    public JsonAsset json(String path, boolean autoLoad) {
        JsonAsset j = autoLoad ? new JsonAsset(this.plugin, this.namespace, path) : new JsonAsset(this.namespace, path);
        this.assets.add(j);
        return j;
    }

    public void icon(byte[] data) {
        this.icon = this.texture("item/icon", data);
    }

    public void icon() {
        this.icon = this.texture("item/icon");
    }

    public void emit(@NotNull Map<String, byte[]> files) {
        for (Asset asset : this.assets) {
            asset.emit(files);
        }
    }

    @NotNull
    public String id(@NotNull String path) {
        return this.namespace + ":" + path;
    }

    @NotNull
    public Plugin getPlugin() {
        return this.plugin;
    }

    @NotNull
    public String getNamespace() {
        return this.namespace;
    }

    @NotNull
    public ResourcePack getPack() {
        return this.pack;
    }

    public Texture getIcon() {
        return this.icon;
    }
}

