/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.abyssallib.server.resource.asset;

import com.github.darksoulq.abyssallib.common.util.TextUtil;
import com.github.darksoulq.abyssallib.server.resource.asset.Asset;
import com.github.darksoulq.abyssallib.server.resource.asset.Model;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class BlockState
implements Asset {
    @NotNull
    private final String namespace;
    @NotNull
    private final String id;
    private byte[] rawData;
    private final Map<String, List<Variant>> variants = new LinkedHashMap<String, List<Variant>>();
    private final List<Multipart> multiparts = new ArrayList<Multipart>();

    public BlockState(@NotNull String namespace, @NotNull String id) {
        this.namespace = namespace;
        this.id = id;
    }

    public BlockState(@NotNull String namespace, @NotNull String id, byte[] data) {
        this.namespace = namespace;
        this.id = id;
        this.rawData = data;
    }

    public BlockState(@NotNull Plugin plugin, @NotNull String namespace, @NotNull String id) {
        this.namespace = namespace;
        this.id = id;
        String resource = "resourcepack/" + namespace + "/blockstates/" + id + ".json";
        try (InputStream in = plugin.getResource(resource);){
            if (in == null) {
                throw new IllegalStateException("Blockstate file not found: " + resource);
            }
            this.rawData = in.readAllBytes();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load blockstate JSON", e);
        }
    }

    public BlockState variant(@NotNull String variantKey, Variant variant) {
        this.variants.computeIfAbsent(variantKey, k -> new ArrayList()).add(variant);
        return this;
    }

    public BlockState multipart(@NotNull Multipart multipart) {
        this.multiparts.add(multipart);
        return this;
    }

    @Override
    public void emit(@NotNull Map<String, byte[]> files) {
        if (this.rawData != null) {
            files.put(this.path(), this.rawData);
            return;
        }
        JsonObject root = new JsonObject();
        if (!this.variants.isEmpty()) {
            JsonObject varObj = new JsonObject();
            for (Map.Entry entry : this.variants.entrySet()) {
                JsonArray arr = new JsonArray();
                for (Variant v : (List)entry.getValue()) {
                    arr.add((JsonElement)v.toJson());
                }
                varObj.add((String)entry.getKey(), (JsonElement)arr);
            }
            root.add("variants", (JsonElement)varObj);
        }
        if (!this.multiparts.isEmpty()) {
            JsonArray mo = new JsonArray();
            for (Multipart multipart : this.multiparts) {
                mo.add((JsonElement)multipart.toJson());
            }
            root.add("multipart", (JsonElement)mo);
        }
        files.put(this.path(), TextUtil.GSON.toJson((JsonElement)root).getBytes(StandardCharsets.UTF_8));
    }

    private String path() {
        return "assets/" + this.namespace + "/blockstates/" + this.id + ".json";
    }

    public static class Variant {
        private final Model model;
        private Integer x;
        private Integer y;
        private Integer weight;
        private Boolean uvlock;

        public Variant(@NotNull Model model) {
            this.model = model;
        }

        public Variant x(int x) {
            this.x = x;
            return this;
        }

        public Variant y(int y) {
            this.y = y;
            return this;
        }

        public Variant weight(int w) {
            this.weight = w;
            return this;
        }

        public Variant uvlock(boolean b) {
            this.uvlock = b;
            return this;
        }

        public JsonObject toJson() {
            JsonObject o = new JsonObject();
            o.addProperty("model", this.model.file());
            if (this.x != null) {
                o.addProperty("x", (Number)this.x);
            }
            if (this.y != null) {
                o.addProperty("y", (Number)this.y);
            }
            if (this.weight != null) {
                o.addProperty("weight", (Number)this.weight);
            }
            if (this.uvlock != null) {
                o.addProperty("uvlock", this.uvlock);
            }
            return o;
        }
    }

    public static class Multipart {
        private final String whenCondition;
        private final Variant thenVariant;

        public Multipart(@NotNull String whenCondition, @NotNull Variant thenVariant) {
            this.whenCondition = whenCondition;
            this.thenVariant = thenVariant;
        }

        public JsonObject toJson() {
            JsonObject m = new JsonObject();
            if (!this.whenCondition.isEmpty()) {
                JsonObject cond = new JsonObject();
                cond.addProperty("when", this.whenCondition);
                m.add("when", (JsonElement)cond);
            }
            m.add("apply", (JsonElement)this.thenVariant.toJson());
            return m;
        }
    }
}

