/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.abyssallib.server.resource.asset;

import com.github.darksoulq.abyssallib.common.util.TextUtil;
import com.github.darksoulq.abyssallib.server.resource.asset.Asset;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class JsonAsset
implements Asset {
    @NotNull
    private final String namespace;
    @NotNull
    private final String path;
    private final Map<String, Object> flat = new LinkedHashMap<String, Object>();
    private JsonObject preloadedRoot = null;

    public JsonAsset(@NotNull String namespace, @NotNull String path) {
        this.namespace = namespace;
        this.path = path;
    }

    public JsonAsset(@NotNull Plugin plugin, @NotNull String namespace, @NotNull String path) {
        this.namespace = namespace;
        this.path = path;
        try (InputStream in = plugin.getResource("resourcepack/" + namespace + "/" + path + ".json");){
            if (in == null) {
                throw new IllegalArgumentException("Could not find embedded JSON asset: " + namespace + "/" + path);
            }
            this.preloadedRoot = JsonParser.parseReader((Reader)new InputStreamReader(in, StandardCharsets.UTF_8)).getAsJsonObject();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load embedded JSON asset: " + namespace + "/" + path, e);
        }
    }

    public JsonAsset put(@NotNull String key, @NotNull Object value) {
        this.flat.put(key, value);
        return this;
    }

    @Override
    public void emit(@NotNull Map<String, byte[]> files) {
        JsonObject root = this.preloadedRoot != null ? this.preloadedRoot.deepCopy() : new JsonObject();
        for (Map.Entry<String, Object> entry : this.flat.entrySet()) {
            this.setNested(root, entry.getKey(), TextUtil.GSON.toJsonTree(entry.getValue()));
        }
        String fullPath = "assets/" + this.namespace + "/" + this.path + ".json";
        files.put(fullPath, TextUtil.GSON.toJson((JsonElement)root).getBytes(StandardCharsets.UTF_8));
    }

    private void setNested(JsonObject root, String dottedKey, JsonElement value) {
        String[] keys = dottedKey.split("\\.");
        JsonObject current = root;
        for (int i = 0; i < keys.length - 1; ++i) {
            String key = keys[i];
            if (!current.has(key) || !current.get(key).isJsonObject()) {
                current.add(key, (JsonElement)new JsonObject());
            }
            current = current.getAsJsonObject(key);
        }
        current.add(keys[keys.length - 1], value);
    }
}

