/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.abyssallib.server.resource.asset;

import com.github.darksoulq.abyssallib.common.util.TextUtil;
import com.github.darksoulq.abyssallib.server.resource.asset.Asset;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class McMeta
implements Asset {
    private final String path;
    private final String namespace;
    private int defaultFrameTime;
    private Boolean interpolate;
    private int width = -99;
    private int height = -99;
    private final List<Object> frames = new ArrayList<Object>();
    private byte[] rawData = null;

    public McMeta(Plugin plugin, String namespace, @NotNull String path, boolean autoLoad) {
        this.path = path;
        this.namespace = namespace;
        if (!autoLoad) {
            return;
        }
        String resourcePath = "resourcepack/" + namespace + "/textures/" + path + ".png.mcmeta";
        try (InputStream in = plugin.getResource(resourcePath);){
            if (in == null) {
                throw new IllegalStateException("McMeta not found in plugin JAR at: " + resourcePath);
            }
            JsonObject root = (JsonObject)TextUtil.GSON.fromJson((Reader)new InputStreamReader(in), JsonObject.class);
            JsonObject anim = root.getAsJsonObject("animation");
            if (anim == null) {
                throw new IllegalStateException("Missing 'animation' object in: " + resourcePath);
            }
            if (anim.has("frametime")) {
                this.defaultFrameTime = anim.get("frametime").getAsInt();
            }
            if (anim.has("interpolate")) {
                this.interpolate = anim.get("interpolate").getAsBoolean();
            }
            if (anim.has("width")) {
                this.width = anim.get("width").getAsInt();
            }
            if (anim.has("height")) {
                this.height = anim.get("height").getAsInt();
            }
            if (anim.has("frames")) {
                JsonArray arr = anim.getAsJsonArray("frames");
                for (JsonElement el : arr) {
                    if (el.isJsonPrimitive()) {
                        this.frames.add(el.getAsInt());
                        continue;
                    }
                    Map frameObj = (Map)TextUtil.GSON.fromJson(el, Map.class);
                    this.frames.add(frameObj);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load mcmeta from: " + resourcePath, e);
        }
    }

    public McMeta(String namespace, String path, byte[] data) {
        this.namespace = namespace;
        this.path = path;
        this.rawData = data;
    }

    public McMeta frametime(int t) {
        this.defaultFrameTime = t;
        return this;
    }

    public McMeta interpolate(boolean b) {
        this.interpolate = b;
        return this;
    }

    public McMeta width(int w) {
        this.width = w;
        return this;
    }

    public McMeta height(int h) {
        this.height = h;
        return this;
    }

    public McMeta frames(int ... idxs) {
        for (int i : idxs) {
            this.frames.add(i);
        }
        return this;
    }

    @SafeVarargs
    public final McMeta framesWithTime(Map<String, Object> ... data) {
        Collections.addAll(this.frames, data);
        return this;
    }

    @Override
    public void emit(@NotNull Map<String, byte[]> files) {
        if (this.rawData != null) {
            files.put("assets/" + this.namespace + "/textures/" + this.path + ".png.mcmeta", this.rawData);
        }
        JsonObject root = new JsonObject();
        JsonObject anim = new JsonObject();
        anim.addProperty("frametime", (Number)this.defaultFrameTime);
        if (this.width != -99) {
            anim.addProperty("width", (Number)this.width);
        }
        if (this.height != -99) {
            anim.addProperty("height", (Number)this.height);
        }
        if (this.interpolate != null) {
            anim.addProperty("interpolate", this.interpolate);
        }
        JsonArray arr = new JsonArray();
        for (Object f : this.frames) {
            if (f instanceof Integer) {
                arr.add((Number)((Integer)f));
                continue;
            }
            if (!(f instanceof Map)) continue;
            arr.add(TextUtil.GSON.toJsonTree(f));
        }
        if (!this.frames.isEmpty()) {
            anim.add("frames", (JsonElement)arr);
        }
        root.add("animation", (JsonElement)anim);
        files.put("assets/" + this.namespace + "/textures/" + this.path + ".png.mcmeta", TextUtil.GSON.toJson((JsonElement)root).getBytes(StandardCharsets.UTF_8));
    }
}

