/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.abyssallib.server.resource.asset;

import com.github.darksoulq.abyssallib.common.util.TextUtil;
import com.github.darksoulq.abyssallib.server.resource.asset.Asset;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class PackMcMeta
implements Asset {
    private int packFormat;
    private Object description;
    private Integer minFormat;
    private Integer maxFormat;
    private final byte[] rawData;

    public PackMcMeta(@NotNull Plugin plugin) {
        try (InputStream in = plugin.getResource("resourcepack/pack.mcmeta");){
            if (in == null) {
                throw new IllegalStateException("Missing pack.mcmeta in resourcepack folder.");
            }
            this.rawData = in.readAllBytes();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load pack.mcmeta", e);
        }
    }

    public PackMcMeta(byte[] data) {
        this.rawData = data;
    }

    public PackMcMeta() {
        this.rawData = null;
    }

    public PackMcMeta packFormat(int fmt) {
        this.packFormat = fmt;
        return this;
    }

    public PackMcMeta description(@NotNull String desc) {
        this.description = desc;
        return this;
    }

    public PackMcMeta description(@NotNull Component component) {
        this.description = component;
        return this;
    }

    public PackMcMeta supportedFormats(int minIncl, int maxIncl) {
        this.minFormat = minIncl;
        this.maxFormat = maxIncl;
        return this;
    }

    @Override
    public void emit(@NotNull Map<String, byte[]> files) {
        if (this.rawData != null) {
            files.put("pack.mcmeta", this.rawData);
            return;
        }
        JsonObject root = new JsonObject();
        JsonObject pack = new JsonObject();
        pack.addProperty("pack_format", (Number)this.packFormat);
        Object object = this.description;
        if (object instanceof String) {
            String s = (String)object;
            pack.addProperty("description", s);
        } else {
            object = this.description;
            if (object instanceof Component) {
                Component c = (Component)object;
                JsonElement jsonElement = GsonComponentSerializer.gson().serializeToTree(c);
                pack.add("description", jsonElement);
            }
        }
        if (this.minFormat != null && this.maxFormat != null) {
            JsonObject supported = new JsonObject();
            supported.addProperty("min_inclusive", (Number)this.minFormat);
            supported.addProperty("max_inclusive", (Number)this.maxFormat);
            pack.add("supported_formats", (JsonElement)supported);
        }
        root.add("pack", (JsonElement)pack);
        files.put("pack.mcmeta", TextUtil.GSON.toJson((JsonElement)root).getBytes(StandardCharsets.UTF_8));
    }
}

