/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.abyssallib.world.util;

import com.github.darksoulq.abyssallib.AbyssalLib;
import org.bukkit.Chunk;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public final class BlockPersistentData {
    private static final String PREFIX = "abyssallib_block_";

    private BlockPersistentData() {
    }

    public static PersistentDataContainer get(Block block) {
        NamespacedKey key;
        Chunk chunk = block.getChunk();
        PersistentDataContainer chunkPDC = chunk.getPersistentDataContainer();
        PersistentDataContainer existing = (PersistentDataContainer)chunkPDC.get(key = BlockPersistentData.keyFor(block), PersistentDataType.TAG_CONTAINER);
        if (existing != null) {
            return existing;
        }
        PersistentDataContainer created = chunkPDC.getAdapterContext().newPersistentDataContainer();
        chunkPDC.set(key, PersistentDataType.TAG_CONTAINER, (Object)created);
        return created;
    }

    public static void remove(Block block) {
        block.getChunk().getPersistentDataContainer().remove(BlockPersistentData.keyFor(block));
    }

    private static NamespacedKey keyFor(Block block) {
        int lx = block.getX() & 0xF;
        int lz = block.getZ() & 0xF;
        return new NamespacedKey((Plugin)AbyssalLib.getInstance(), PREFIX + lx + "_" + block.getY() + "_" + lz);
    }
}

