package dev.creatormind.respawntimeout.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import dev.creatormind.respawntimeout.state.ServerState;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_2168;
import net.minecraft.class_2561;

import static net.minecraft.class_2170.*;


public class ClearCommand {

    private static final int ADMIN_PERMISSION_LEVEL = 4;


    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register(method_9247("respawntimeout")
            .then(method_9247("clear")
                .requires((source) -> source.method_9259(ADMIN_PERMISSION_LEVEL))
                .executes((context) -> clear(context.getSource()))
            ));
    }

    private static int clear(class_2168 source) {
        final ServerState serverState = ServerState.getServerState(source.method_9211());

        serverState.timeUnit = TimeUnit.SECONDS;
        serverState.respawnTimeout = 0L;
        serverState.minRandomTimeout = 0L;
        serverState.maxRandomTimeout = 0L;
        serverState.method_80();

        source.method_9226(() -> class_2561.method_43471("respawn-timeout.commands.clear.success"), false);

        return Command.SINGLE_SUCCESS;
    }

}
