package dev.creatormind.respawntimeout.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import dev.creatormind.respawntimeout.state.ServerState;
import net.minecraft.class_2168;
import net.minecraft.class_2561;

import static net.minecraft.class_2170.*;


public class GetCommand {

    private static final int ADMIN_PERMISSION_LEVEL = 4;


    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register(method_9247("respawntimeout")
            .then(method_9247("get")
                .requires((source) -> source.method_9259(ADMIN_PERMISSION_LEVEL))
                .executes((context) -> get(context.getSource()))
            ));
    }

    private static int get(class_2168 source) {
        final ServerState serverState = ServerState.getServerState(source.method_9211());

        if (serverState.respawnTimeout >= 0) {
            source.method_9226(() -> class_2561.method_43469(
                "respawn-timeout.commands.get.success.fixed",
                serverState.respawnTimeout,
                serverState.timeUnit.toString().toLowerCase().charAt(0) + ""
            ), false);
        }
        else {
            source.method_9226(() -> class_2561.method_43469(
                "respawn-timeout.commands.get.success.random",
                serverState.minRandomTimeout,
                serverState.maxRandomTimeout
            ), false);
        }

        return Command.SINGLE_SUCCESS;
    }

}
