package dev.creatormind.respawntimeout.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import dev.creatormind.respawntimeout.RespawnTimeoutMod;
import dev.creatormind.respawntimeout.enums.PlayerStatus;
import dev.creatormind.respawntimeout.state.PlayerState;
import dev.creatormind.respawntimeout.state.ServerState;
import dev.creatormind.respawntimeout.utils.TimeFormatter;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_2168;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

import static net.minecraft.class_2170.*;


public class RespawnCommand {

    private static final int MODERATOR_PERMISSION_LEVEL = 2;


    public static void register(CommandDispatcher<class_2168> dispatcher) {
        // Registration call for a normal user.
        dispatcher.register(method_9247("respawntimeout")
            .then(method_9247("respawn")
                .executes((context) -> respawn(context.getSource(), context.getSource().method_44023(), false))
            ));

        // Registration call for a forced use by a moderator.
        dispatcher.register(method_9247("respawntimeout")
            .then(method_9247("respawn")
                .then(method_9244("player", class_2186.method_9305())
                    .requires((source) -> source.method_9259(MODERATOR_PERMISSION_LEVEL))
                    .executes((context) -> respawn(context.getSource(), class_2186.method_9315(context, "player"), true))
                )));
    }

    private static int respawn(class_2168 source, class_3222 player, boolean force) {
        final ServerState serverState = ServerState.getServerState(source.method_9211());
        final PlayerState playerState = ServerState.getPlayerState(player);
        final PlayerStatus playerStatus = RespawnTimeoutMod.getPlayerStatus(player);

        switch (playerStatus) {
            case ALIVE: {
                String translationKey = (player == source.method_44023())
                    ? "respawn-timeout.info.self.na"
                    : "respawn-timeout.info.player.na";

                source.method_9226(() -> class_2561.method_43469(translationKey, player.method_5477().getString()), false);

                break;
            }
            case TIMED_OUT: {
                if (force) {
                    RespawnTimeoutMod.respawnPlayer(player);

                    source.method_9226(() -> class_2561.method_43469("respawn-timeout.info.player.respawned", player.method_5477().getString()), false);
                    player.method_7353(class_2561.method_43471("respawn-timeout.info.self.respawned"), false);
                }
                else {
                    final long remainingTime = serverState.timeUnit.toMillis(playerState.respawnTimeout) - (System.currentTimeMillis() - playerState.deathTimestamp);

                    source.method_9226(() -> class_2561.method_43469(
                        "respawn-timeout.info.self.status",
                        TimeFormatter.format(remainingTime, TimeUnit.MILLISECONDS)
                    ), false);
                }

                break;
            }
            case AWAITING_RESPAWN: {
                RespawnTimeoutMod.respawnPlayer(player);

                player.method_7353(class_2561.method_43471("respawn-timeout.info.self.respawned"), false);

                if (force)
                    source.method_9226(() -> class_2561.method_43469("respawn-timeout.info.player.respawned", player.method_5477().getString()), false);

                break;
            }
            default:
                throw new AssertionError("Unreachable");
        }

        return Command.SINGLE_SUCCESS;
    }

}
