package dev.creatormind.respawntimeout.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import dev.creatormind.respawntimeout.state.ServerState;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_2168;
import net.minecraft.class_2561;

import static com.mojang.brigadier.arguments.LongArgumentType.*;
import static net.minecraft.class_2170.*;


public class SetCommand {

    private static final int ADMIN_PERMISSION_LEVEL = 4;

    private static final long MAX_TIMEOUT_IN_SECONDS = 604800L;
    private static final long MAX_TIMEOUT_IN_MINUTES = 10080L;
    private static final long MAX_TIMEOUT_IN_HOURS = 168L;
    private static final long MAX_TIMEOUT_IN_DAYS = 7L;


    public static void register(CommandDispatcher<class_2168> dispatcher) {
        // Registration call for configuration in seconds.
        dispatcher.register(method_9247("respawntimeout")
            .then(method_9247("set")
                .requires((source) -> source.method_9259(ADMIN_PERMISSION_LEVEL))
                .then(method_9247("fixed")
                    .then(method_9244("timeout", longArg(0L, MAX_TIMEOUT_IN_SECONDS))
                        .then(method_9247("seconds")
                            .executes((context) -> set(context.getSource(), getLong(context, "timeout"), MAX_TIMEOUT_IN_SECONDS, TimeUnit.SECONDS))
                        )))));

        // Registration call for configuration in minutes.
        dispatcher.register(method_9247("respawntimeout")
            .then(method_9247("set")
                .requires((source) -> source.method_9259(ADMIN_PERMISSION_LEVEL))
                .then(method_9247("fixed")
                    .then(method_9244("timeout", longArg(0L, MAX_TIMEOUT_IN_MINUTES))
                        .then(method_9247("minutes")
                            .executes((context) -> set(context.getSource(), getLong(context, "timeout"), MAX_TIMEOUT_IN_MINUTES, TimeUnit.MINUTES))
                        )))));

        // Registration call for configuration in hours.
        dispatcher.register(method_9247("respawntimeout")
            .then(method_9247("set")
                .requires((source) -> source.method_9259(ADMIN_PERMISSION_LEVEL))
                .then(method_9247("fixed")
                    .then(method_9244("timeout", longArg(0L, MAX_TIMEOUT_IN_HOURS))
                        .then(method_9247("hours")
                            .executes((context) -> set(context.getSource(), getLong(context, "timeout"), MAX_TIMEOUT_IN_HOURS, TimeUnit.HOURS))
                        )))));

        // Registration call for configuration in days.
        dispatcher.register(method_9247("respawntimeout")
            .then(method_9247("set")
                .requires((source) -> source.method_9259(ADMIN_PERMISSION_LEVEL))
                .then(method_9247("fixed")
                    .then(method_9244("timeout", longArg(0L, MAX_TIMEOUT_IN_DAYS))
                        .then(method_9247("days")
                            .executes((context) -> set(context.getSource(), getLong(context, "timeout"), MAX_TIMEOUT_IN_DAYS, TimeUnit.DAYS))
                        )))));
    }

    private static int set(class_2168 source, long timeout, long maxTimeout, TimeUnit unit) throws CommandSyntaxException {
        // No comment.
        if (timeout < 0L)
            throw new SimpleCommandExceptionType(class_2561.method_43471("respawn-timeout.commands.set.error.negative")).create();

        // Throws an error in case the timeout in a time unit is out of range.
        switch (unit) {
            case SECONDS:
                if (timeout <= MAX_TIMEOUT_IN_SECONDS)
                    break;
            case MINUTES:
                if (timeout <= MAX_TIMEOUT_IN_MINUTES)
                    break;
            case HOURS:
                if (timeout <= MAX_TIMEOUT_IN_HOURS)
                    break;
            case DAYS:
                if (timeout <= MAX_TIMEOUT_IN_DAYS)
                    break;
            default:
                throw new SimpleCommandExceptionType(class_2561.method_43469(
                    "respawn-timeout.commands.set.error.invalid",
                    unit.toString().toUpperCase(),
                    0L,
                    maxTimeout
                )).create();
        }

        final ServerState serverState = ServerState.getServerState(source.method_9211());

        serverState.respawnTimeout = timeout;
        serverState.timeUnit = unit;
        serverState.minRandomTimeout = 0L;
        serverState.maxRandomTimeout = 0L;
        serverState.method_80();

        source.method_9226(() -> class_2561.method_43469(
            "respawn-timeout.commands.set.success",
            timeout,
            unit.toString().toLowerCase().charAt(0) + ""
        ), true);

        return Command.SINGLE_SUCCESS;
    }

}
