package dev.creatormind.respawntimeout.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import dev.creatormind.respawntimeout.state.ServerState;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_2168;
import net.minecraft.class_2561;

import static com.mojang.brigadier.arguments.LongArgumentType.*;
import static net.minecraft.class_2170.*;


public class SetRandomCommand {

    private static final int ADMIN_PERMISSION_LEVEL = 4;

    private static final long MAX_TIMEOUT_IN_SECONDS = 604800L;


    public static void register(CommandDispatcher<class_2168> dispatcher) {
        // Registration call for a random timeout configuration.
        dispatcher.register(method_9247("respawntimeout")
            .then(method_9247("set")
                .then(method_9247("random")
                    .requires((source) -> source.method_9259(ADMIN_PERMISSION_LEVEL))
                    .then(method_9244("min", longArg(0L, MAX_TIMEOUT_IN_SECONDS - 1))
                        .then(method_9244("max", longArg(0L, MAX_TIMEOUT_IN_SECONDS))
                            .executes((context) -> set(context.getSource(), context.getArgument("min", long.class), context.getArgument("max", long.class)))
                    ))
                )));
    }

    private static int set(class_2168 source, long minTimeout, long maxTimeout) throws CommandSyntaxException {
        if (minTimeout < 0L || minTimeout >= maxTimeout || minTimeout >= MAX_TIMEOUT_IN_SECONDS)
            throw new SimpleCommandExceptionType(class_2561.method_43471("respawn-timeout.commands.set_random.error.invalid_min")).create();

        if (maxTimeout > MAX_TIMEOUT_IN_SECONDS)
            throw new SimpleCommandExceptionType(class_2561.method_43471("respawn-timeout.commands.set_random.error.invalid_max")).create();

        final ServerState serverState = ServerState.getServerState(source.method_9211());

        serverState.respawnTimeout = -1L;
        serverState.timeUnit = TimeUnit.SECONDS;
        serverState.minRandomTimeout = minTimeout;
        serverState.maxRandomTimeout = maxTimeout;
        serverState.method_80();

        source.method_9226(() -> class_2561.method_43469(
            "respawn-timeout.commands.set_random.success",
            minTimeout,
            maxTimeout
        ), true);

        return Command.SINGLE_SUCCESS;
    }

}
