package dev.creatormind.respawntimeout.state;

import dev.creatormind.respawntimeout.RespawnTimeoutMod;
import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_26;
import net.minecraft.class_3222;
import net.minecraft.class_7225;
import net.minecraft.server.MinecraftServer;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.TimeUnit;


public class ServerState extends class_18 {

    public HashMap<UUID, PlayerState> players   = new HashMap<>();

    // Min and max timeouts will always be in seconds.
    public long maxRandomTimeout                = 0L;
    public long minRandomTimeout                = 0L;

    // This is the global/server specific timeout that will be applied to everyone equally.
    public long respawnTimeout                  = 0L;
    public TimeUnit timeUnit                    = TimeUnit.SECONDS;


    @Override
    public class_2487 method_75(class_2487 nbt, class_7225.class_7874 registryLookup) {
        final class_2487 playersNbt = new class_2487();

        players.forEach((uuid, playerState) -> {
            final class_2487 playerStateNbt = new class_2487();

            playerStateNbt.method_10544("deathTimestamp", playerState.deathTimestamp);
            playerStateNbt.method_10544("respawnTimeout", playerState.respawnTimeout);

            playersNbt.method_10566(uuid.toString(), playerStateNbt);
        });

        nbt.method_10566("players", playersNbt);
        nbt.method_10544("maxRandomTimeout", maxRandomTimeout);
        nbt.method_10544("minRandomTimeout", minRandomTimeout);
        nbt.method_10544("respawnTimeout", respawnTimeout);
        nbt.method_10582("timeUnit", timeUnit.toString());

        return nbt;
    }


    public static ServerState createFromNbt(class_2487 tag, class_7225.class_7874 registryLookup) {
        final ServerState serverState = new ServerState();
        final class_2487 playersNbt = tag.method_10562("players");

        playersNbt.method_10541().forEach((key) -> {
            final PlayerState playerState = new PlayerState();

            playerState.deathTimestamp = playersNbt.method_10562(key).method_10537("deathTimestamp");
            playerState.respawnTimeout = playersNbt.method_10562(key).method_10537("respawnTimeout");

            final UUID uuid = UUID.fromString(key);

            serverState.players.put(uuid, playerState);
        });

        try {
            serverState.timeUnit = TimeUnit.valueOf(tag.method_10558("timeUnit"));
        }
        catch (Exception e) {
            serverState.timeUnit = TimeUnit.SECONDS;
        }

        serverState.maxRandomTimeout = tag.method_10537("maxRandomTimeout");
        serverState.minRandomTimeout = tag.method_10537("minRandomTimeout");
        serverState.respawnTimeout = tag.method_10537("respawnTimeout");

        return serverState;
    }

    private static final class_8645<ServerState> type = new class_8645<>(
        ServerState::new,
        ServerState::createFromNbt,
        null
    );

    public static ServerState getServerState(MinecraftServer server) {
        final class_26 stateManager = server.method_30002().method_17983();

        final ServerState state = stateManager.method_17924(type, RespawnTimeoutMod.MOD_ID);

        state.method_80();

        return state;
    }

    public static PlayerState getPlayerState(class_3222 player) {
        final MinecraftServer server = player.method_5682();

        if (server == null)
            throw new NullPointerException("[Respawn Timeout] Server is null!");

        final ServerState serverState = ServerState.getServerState(server);

        return serverState.players.computeIfAbsent(player.method_5667(), (uuid) -> new PlayerState());
    }

}
