/*
 * Decompiled with CFR 0.152.
 */
package com.kaktuz.kvisuals;

import com.kaktuz.kvisuals.VisualSettings;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class KVisualsScreen
extends Screen {
    private boolean hatSettingsExpanded = false;
    private boolean subMenuOpen = false;
    private final List<Slider> sliders = new ArrayList<Slider>();

    protected KVisualsScreen() {
        super((ITextComponent)new StringTextComponent("KVisuals Menu"));
    }

    protected void func_231160_c_() {
        this.func_231039_at__().clear();
        this.sliders.clear();
        int centerX = this.field_230708_k_ / 2;
        int centerY = this.field_230709_l_ / 2;
        int sliderWidth = 150;
        int sliderHeight = 20;
        int spacing = 25;
        this.sliders.add(new Slider("\u0420\u0430\u0434\u0438\u0443\u0441", 0.1f, 1.5f, VisualSettings.chineseHatRadius, centerX - sliderWidth / 2, centerY - spacing * 2, sliderWidth, sliderHeight, value -> {
            VisualSettings.chineseHatRadius = value;
        }));
        this.sliders.add(new Slider("\u0412\u044b\u0441\u043e\u0442\u0430", 0.1f, 2.0f, VisualSettings.chineseHatHeight, centerX - sliderWidth / 2, centerY - spacing, sliderWidth, sliderHeight, value -> {
            VisualSettings.chineseHatHeight = value;
        }));
        this.sliders.add(new Slider("YOffset", -1.0f, 1.0f, VisualSettings.chineseHatYOffset, centerX - sliderWidth / 2, centerY, sliderWidth, sliderHeight, value -> {
            VisualSettings.chineseHatYOffset = value;
        }));
        this.sliders.add(new Slider("\u0426\u0432\u0435\u0442 R", 0.0f, 1.0f, VisualSettings.chineseHatColorR, centerX - sliderWidth / 2, centerY + spacing, sliderWidth, sliderHeight, value -> {
            VisualSettings.chineseHatColorR = value;
        }));
        this.sliders.add(new Slider("\u0426\u0432\u0435\u0442 G", 0.0f, 1.0f, VisualSettings.chineseHatColorG, centerX - sliderWidth / 2, centerY + spacing * 2, sliderWidth, sliderHeight, value -> {
            VisualSettings.chineseHatColorG = value;
        }));
        this.sliders.add(new Slider("\u0426\u0432\u0435\u0442 B", 0.0f, 1.0f, VisualSettings.chineseHatColorB, centerX - sliderWidth / 2, centerY + spacing * 3, sliderWidth, sliderHeight, value -> {
            VisualSettings.chineseHatColorB = value;
        }));
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        KVisualsScreen.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)"\u00a7l\u041c\u0435\u043d\u044e \u0432\u0438\u0437\u0443\u0430\u043b\u043e\u0432", (int)(this.field_230708_k_ / 2), (int)20, (int)0xFFFFFF);
        int toggleX = this.field_230708_k_ / 2 - 75;
        int toggleY = this.field_230709_l_ / 2 - 20;
        int toggleW = 120;
        int toggleH = 20;
        if (!this.hatSettingsExpanded) {
            boolean toggleHovered = mouseX >= toggleX && mouseX <= toggleX + toggleW && mouseY >= toggleY && mouseY <= toggleY + toggleH;
            int toggleColor = toggleHovered ? -11184726 : -13421722;
            KVisualsScreen.func_238467_a_((MatrixStack)matrixStack, (int)toggleX, (int)toggleY, (int)(toggleX + toggleW), (int)(toggleY + toggleH), (int)toggleColor);
            KVisualsScreen.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)("\u041a\u0438\u0442\u0430\u0439\u0441\u043a\u0430\u044f \u0448\u043b\u044f\u043f\u0430: " + (VisualSettings.chineseHatEnabled ? "\u0412\u041a\u041b" : "\u0412\u042b\u041a\u041b")), (int)(toggleX + 5), (int)(toggleY + 6), (int)0xFFFFFF);
            int fbX = toggleX;
            int fbY = toggleY + 30;
            boolean fbHovered = mouseX >= fbX && mouseX <= fbX + toggleW && mouseY >= fbY && mouseY <= fbY + toggleH;
            int fbColor = fbHovered ? -11163051 : -13408717;
            KVisualsScreen.func_238467_a_((MatrixStack)matrixStack, (int)fbX, (int)fbY, (int)(fbX + toggleW), (int)(fbY + toggleH), (int)fbColor);
            KVisualsScreen.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)("FullBright: " + (VisualSettings.fullbrightEnabled ? "\u0412\u041a\u041b" : "\u0412\u042b\u041a\u041b")), (int)(fbX + 5), (int)(fbY + 6), (int)0xFFFFFF);
        }
        int arrowX = toggleX + toggleW + 5;
        int arrowY = toggleY;
        int arrowW = 20;
        int arrowH = 20;
        int arrowColor = mouseX >= arrowX && mouseX <= arrowX + arrowW && mouseY >= arrowY && mouseY <= arrowY + arrowH ? -5592406 : -10066330;
        KVisualsScreen.func_238467_a_((MatrixStack)matrixStack, (int)arrowX, (int)arrowY, (int)(arrowX + arrowW), (int)(arrowY + arrowH), (int)arrowColor);
        KVisualsScreen.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)(this.hatSettingsExpanded ? "v" : ">"), (int)(arrowX + arrowW / 2), (int)(arrowY + 6), (int)0xFFFFFF);
        if (this.hatSettingsExpanded) {
            for (Slider slider : this.sliders) {
                slider.draw(matrixStack, this.field_230712_o_, this);
            }
        }
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        int toggleX = this.field_230708_k_ / 2 - 75;
        int toggleY = this.field_230709_l_ / 2 - 20;
        int toggleW = 120;
        int toggleH = 20;
        int arrowX = toggleX + toggleW + 5;
        int arrowY = toggleY;
        int arrowW = 20;
        int arrowH = 20;
        int fbX = toggleX;
        int fbY = toggleY + 30;
        if (this.hatSettingsExpanded) {
            for (Slider slider : this.sliders) {
                if (!slider.mouseClicked(mouseX, mouseY, button)) continue;
                return true;
            }
            return true;
        }
        if (mouseX >= (double)toggleX && mouseX <= (double)(toggleX + toggleW) && mouseY >= (double)toggleY && mouseY <= (double)(toggleY + toggleH)) {
            VisualSettings.chineseHatEnabled = !VisualSettings.chineseHatEnabled;
            return true;
        }
        if (mouseX >= (double)fbX && mouseX <= (double)(fbX + toggleW) && mouseY >= (double)fbY && mouseY <= (double)(fbY + toggleH)) {
            VisualSettings.fullbrightEnabled = !VisualSettings.fullbrightEnabled;
            return true;
        }
        if (mouseX >= (double)arrowX && mouseX <= (double)(arrowX + arrowW) && mouseY >= (double)arrowY && mouseY <= (double)(arrowY + arrowH)) {
            this.hatSettingsExpanded = !this.hatSettingsExpanded;
            return true;
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    private boolean isSubMenuWidget(Widget widget) {
        return widget.func_230458_i_().getString().equals("\u041d\u0430\u0437\u0430\u0434") || widget.func_230458_i_().getString().contains("R:") || widget.func_230458_i_().getString().contains("G:") || widget.func_230458_i_().getString().contains("B:") || widget.func_230458_i_().getString().contains("Y:");
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int button) {
        for (Slider slider : this.sliders) {
            slider.mouseReleased(mouseX, mouseY, button);
        }
        return super.func_231048_c_(mouseX, mouseY, button);
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        for (Slider slider : this.sliders) {
            if (!slider.mouseDragged(mouseX, mouseY, button)) continue;
            return true;
        }
        return super.func_231045_a_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean func_231177_au__() {
        return false;
    }

    private static class Slider {
        private final String label;
        private final float min;
        private final float max;
        private float currentValue;
        private final int x;
        private final int y;
        private final int width;
        private final int height;
        private final ValueSetter setter;
        private boolean dragging = false;

        public Slider(String label, float min, float max, float initial, int x, int y, int width, int height, ValueSetter setter) {
            this.label = label;
            this.min = min;
            this.max = max;
            this.currentValue = initial;
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.setter = setter;
        }

        void draw(MatrixStack matrixStack, FontRenderer font, Screen screen) {
            Screen.func_238467_a_((MatrixStack)matrixStack, (int)this.x, (int)this.y, (int)(this.x + this.width), (int)(this.y + this.height), (int)-13421773);
            float normalized = (this.currentValue - this.min) / (this.max - this.min);
            int filled = (int)(normalized * (float)this.width);
            Screen.func_238467_a_((MatrixStack)matrixStack, (int)this.x, (int)this.y, (int)(this.x + filled), (int)(this.y + this.height), (int)-7829249);
            font.func_238421_b_(matrixStack, this.label + ": " + String.format("%.2f", Float.valueOf(this.currentValue)), (float)(this.x + this.width + 8), (float)(this.y + 2), 0xFFFFFF);
        }

        boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (mouseX >= (double)this.x && mouseX <= (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY <= (double)(this.y + this.height)) {
                this.dragging = true;
                this.updateValue(mouseX);
                return true;
            }
            return false;
        }

        boolean mouseDragged(double mouseX, double mouseY, int button) {
            if (this.dragging) {
                this.updateValue(mouseX);
                return true;
            }
            return false;
        }

        void mouseReleased(double mouseX, double mouseY, int button) {
            this.dragging = false;
        }

        void updateValue(double mouseX) {
            float percent = (float)(mouseX - (double)this.x) / (float)this.width;
            percent = Math.max(0.0f, Math.min(1.0f, percent));
            this.currentValue = this.min + (this.max - this.min) * percent;
            this.setter.set(this.currentValue);
        }

        static interface ValueSetter {
            public void set(float var1);
        }
    }
}

