/*
 * Decompiled with CFR 0.152.
 */
package com.kaktuz.kvisuals;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class Slider
extends Button {
    private final float min;
    private final float max;
    private float value;
    private final Consumer<Float> setter;
    private final String label;
    private boolean dragging = false;

    public Slider(String label, float min, float max, float value, int x, int y, int width, int height, Consumer<Float> setter) {
        super(x, y, width, height, (ITextComponent)new StringTextComponent(""), btn -> {});
        this.min = min;
        this.max = max;
        this.value = value;
        this.setter = setter;
        this.label = label;
        this.updateMessage();
    }

    private void updateMessage() {
        this.func_238482_a_((ITextComponent)new StringTextComponent(this.label + ": " + String.format("%.2f", Float.valueOf(this.value))));
    }

    public void func_230431_b_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        Minecraft.func_71410_x().field_71466_p.func_243248_b(matrixStack, this.func_230458_i_(), (float)this.field_230690_l_, (float)(this.field_230691_m_ - 10), 0xFFFFFF);
        Slider.func_238467_a_((MatrixStack)matrixStack, (int)this.field_230690_l_, (int)this.field_230691_m_, (int)(this.field_230690_l_ + this.field_230688_j_), (int)(this.field_230691_m_ + this.field_230689_k_), (int)-11184811);
        int sliderX = (int)((float)this.field_230690_l_ + (this.value - this.min) / (this.max - this.min) * (float)this.field_230688_j_);
        Slider.func_238467_a_((MatrixStack)matrixStack, (int)(sliderX - 1), (int)this.field_230691_m_, (int)(sliderX + 1), (int)(this.field_230691_m_ + this.field_230689_k_), (int)-1);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (mouseX >= (double)this.field_230690_l_ && mouseX <= (double)(this.field_230690_l_ + this.field_230688_j_) && mouseY >= (double)this.field_230691_m_ && mouseY <= (double)(this.field_230691_m_ + this.field_230689_k_)) {
            this.dragging = true;
            this.updateValue(mouseX);
            return true;
        }
        return false;
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int button) {
        this.dragging = false;
        return super.func_231048_c_(mouseX, mouseY, button);
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.dragging) {
            this.updateValue(mouseX);
            return true;
        }
        return false;
    }

    private void updateValue(double mouseX) {
        float percent = (float)((mouseX - (double)this.field_230690_l_) / (double)this.field_230688_j_);
        percent = Math.min(1.0f, Math.max(0.0f, percent));
        this.value = this.min + percent * (this.max - this.min);
        this.setter.accept(Float.valueOf(this.value));
        this.updateMessage();
    }

    public float getValue() {
        return this.value;
    }
}

