/*
 * Decompiled with CFR 0.152.
 */
package com.minimons.block;

import com.minimons.block.MinimonBlocks;
import com.minimons.block.entity.MinimonBlockEntities;
import com.minimons.block.entity.MinimonDisplayBlockEntity;
import com.minimons.data.MinimonData;
import com.minimons.item.MinimonItems;
import com.mojang.serialization.MapCodec;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2464;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2753;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_9062;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class MinimonDisplayBlock
extends class_2237 {
    public static final MapCodec<MinimonDisplayBlock> CODEC = MinimonDisplayBlock.method_54094(MinimonDisplayBlock::new);
    public static final class_2758 COLOR = class_2758.method_11867((String)"color", (int)0, (int)16);
    public static final class_2753 FACING = class_2741.field_12481;
    private static final class_265 SHAPE_DISPLAY_CASE = class_2248.method_9541((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    private static final class_265 SHAPE_DISPLAY = class_2248.method_9541((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)15.0);
    private static final class_265 SHAPE_PEDESTAL = class_2248.method_9541((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    private final class_265 shape;
    private final boolean dyeable;
    private final class_1792 dropItem;

    public MinimonDisplayBlock(class_4970.class_2251 properties) {
        this(properties, SHAPE_DISPLAY_CASE, true, null);
    }

    public MinimonDisplayBlock(class_4970.class_2251 properties, class_265 shape, boolean dyeable, class_1792 dropItem) {
        super(properties);
        this.shape = shape;
        this.dyeable = dyeable;
        this.dropItem = dropItem;
        this.method_9590((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)COLOR, (Comparable)Integer.valueOf(0))).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043));
    }

    public static MinimonDisplayBlock displayCase(class_4970.class_2251 properties) {
        return new MinimonDisplayBlock(properties, SHAPE_DISPLAY_CASE, true, null);
    }

    public static MinimonDisplayBlock display(class_4970.class_2251 properties) {
        return new MinimonDisplayBlock(properties, SHAPE_DISPLAY, true, null);
    }

    public static MinimonDisplayBlock pedestal(class_4970.class_2251 properties) {
        return new MinimonDisplayBlock(properties, SHAPE_PEDESTAL, true, null);
    }

    public boolean isDyeable() {
        return this.dyeable;
    }

    public void setDropItem(class_1792 item) {
    }

    public class_1792 getDropItem() {
        return this.dropItem;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{COLOR, FACING});
    }

    public class_2680 method_9605(class_1750 context) {
        return (class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)context.method_8042().method_10153());
    }

    protected MapCodec<? extends class_2237> method_53969() {
        return CODEC;
    }

    public class_265 method_9530(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        return this.shape;
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new MinimonDisplayBlockEntity(pos, state);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 state, class_2591<T> type) {
        if (level.method_8608()) {
            return MinimonDisplayBlock.method_31618(type, MinimonBlockEntities.MINIMON_DISPLAY, (lvl, pos, blockState, blockEntity) -> blockEntity.clientTick());
        }
        return null;
    }

    protected class_9062 method_55765(class_1799 stack, class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (!level.method_8608()) {
            class_2586 be = level.method_8321(pos);
            if (be instanceof MinimonDisplayBlockEntity) {
                MinimonData data;
                class_1792 class_17922;
                MinimonDisplayBlockEntity displayBlock = (MinimonDisplayBlockEntity)be;
                if (this.dyeable && (class_17922 = stack.method_7909()) instanceof class_1769) {
                    class_1769 dyeItem = (class_1769)class_17922;
                    class_1767 newColor = dyeItem.method_7802();
                    displayBlock.setDisplayColor(newColor);
                    int colorValue = newColor.method_7789() + 1;
                    level.method_8652(pos, (class_2680)state.method_11657((class_2769)COLOR, (Comparable)Integer.valueOf(colorValue)), 3);
                    if (!player.method_31549().field_7477) {
                        stack.method_7934(1);
                    }
                    return class_9062.field_47728;
                }
                if (player.method_5715() && stack.method_7960() && (data = displayBlock.getMinimonData()) != null && data.isValid()) {
                    int colorValue;
                    if (!displayBlock.isOwner(player)) {
                        player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7cOnly the owner can pick up this display!"), true);
                        return class_9062.field_47729;
                    }
                    class_1792 itemToDrop = this.getDropItemForBlock(state);
                    class_1799 minimonStack = new class_1799((class_1935)itemToDrop);
                    data.saveToStack(minimonStack);
                    if (this.dyeable && (colorValue = ((Integer)state.method_11654((class_2769)COLOR)).intValue()) > 0) {
                        class_9279 existingData = (class_9279)minimonStack.method_57824(class_9334.field_49628);
                        class_2487 tag = existingData != null ? existingData.method_57461() : new class_2487();
                        tag.method_10569("DisplayColor", colorValue);
                        minimonStack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)tag));
                    }
                    if (!player.method_31548().method_7394(minimonStack)) {
                        player.method_7328(minimonStack, false);
                    }
                    level.method_8650(pos, false);
                    return class_9062.field_47728;
                }
                if (!player.method_5715() && displayBlock.getMinimonData() != null && displayBlock.getMinimonData().isValid()) {
                    if (!displayBlock.isOwner(player)) {
                        player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7cOnly the owner can access this display!"), true);
                        return class_9062.field_47729;
                    }
                    return class_9062.field_47728;
                }
            }
        } else {
            class_2586 be = level.method_8321(pos);
            if (be instanceof MinimonDisplayBlockEntity) {
                MinimonDisplayBlockEntity displayBlock = (MinimonDisplayBlockEntity)be;
                if (this.dyeable && stack.method_7909() instanceof class_1769) {
                    return class_9062.field_47728;
                }
                if (!player.method_5715() && displayBlock.getMinimonData() != null && displayBlock.getMinimonData().isValid()) {
                    return class_9062.field_47728;
                }
            }
        }
        return class_9062.field_47731;
    }

    private class_1792 getDropItemForBlock(class_2680 state) {
        class_2248 block = state.method_26204();
        if (block == MinimonBlocks.DISPLAY) {
            return MinimonItems.DISPLAY;
        }
        if (block == MinimonBlocks.DISPLAY_PEDESTAL) {
            return MinimonItems.DISPLAY_PEDESTAL;
        }
        return MinimonItems.MINIMON_DISPLAY_CASE;
    }

    protected class_1269 method_55766(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_3965 hit) {
        MinimonDisplayBlockEntity displayBlock;
        class_2586 be;
        if (!player.method_5715() && (be = level.method_8321(pos)) instanceof MinimonDisplayBlockEntity && (displayBlock = (MinimonDisplayBlockEntity)be).getMinimonData() != null && displayBlock.getMinimonData().isValid()) {
            if (!displayBlock.isOwner(player)) {
                if (!level.method_8608()) {
                    player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7cOnly the owner can access this display!"), true);
                }
                return class_1269.field_21466;
            }
            return class_1269.method_29236((boolean)level.method_8608());
        }
        return class_1269.field_5811;
    }

    public void method_9536(class_2680 state, class_1937 level, class_2338 pos, class_2680 newState, boolean movedByPiston) {
        MinimonDisplayBlockEntity displayBlock;
        MinimonData data;
        class_2586 be;
        if (!state.method_27852(newState.method_26204()) && (be = level.method_8321(pos)) instanceof MinimonDisplayBlockEntity && (data = (displayBlock = (MinimonDisplayBlockEntity)be).getMinimonData()) != null && data.isValid()) {
            int colorValue;
            class_1792 itemToDrop = this.getDropItemForBlock(state);
            class_1799 minimonStack = new class_1799((class_1935)itemToDrop);
            data.saveToStack(minimonStack);
            if (this.dyeable && (colorValue = ((Integer)state.method_11654((class_2769)COLOR)).intValue()) > 0) {
                class_9279 existingData = (class_9279)minimonStack.method_57824(class_9334.field_49628);
                class_2487 tag = existingData != null ? existingData.method_57461() : new class_2487();
                tag.method_10569("DisplayColor", colorValue);
                minimonStack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)tag));
            }
            MinimonDisplayBlock.method_9577((class_1937)level, (class_2338)pos, (class_1799)minimonStack);
        }
        super.method_9536(state, level, pos, newState, movedByPiston);
    }
}

