/*
 * Decompiled with CFR 0.152.
 */
package com.minimons.client.render;

import com.minimons.Minimons;
import com.minimons.block.MinimonBlocks;
import com.minimons.block.MinimonDisplayBlock;
import com.minimons.block.entity.MinimonDisplayBlockEntity;
import com.minimons.block.entity.PokemonAnimation;
import com.minimons.data.MinimonData;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_7833;
import net.minecraft.class_827;
import net.minecraft.class_898;

@Environment(value=EnvType.CLIENT)
public class MinimonDisplayBlockEntityRenderer
implements class_827<MinimonDisplayBlockEntity> {
    private static final Map<String, Object> entityCache = new HashMap<String, Object>();
    private static Class<?> pokemonEntityClass = null;
    private static Class<?> pokemonClass = null;
    private static Class<?> speciesClass = null;
    private static Object pokemonSpeciesRegistry = null;
    private static boolean reflectionInitialized = false;
    private static boolean reflectionFailed = false;
    private static Method setEnablePoseTypeRecalculationMethod = null;
    private static boolean poseMethodCached = false;
    private static final double MAX_RENDER_DISTANCE_SQ = 2304.0;
    private final Map<class_2338, Integer> lastGameTickMap = new HashMap<class_2338, Integer>();
    private static boolean shadowDisabled = false;
    private final class_898 entityRenderDispatcher;
    private static long lastLogTime = 0L;
    private static boolean hasLoggedAnimationMethods = false;
    private final Map<class_2338, String> lastAnimationMap = new HashMap<class_2338, String>();
    private final Map<class_2338, Boolean> entityBattleStateMap = new HashMap<class_2338, Boolean>();

    public MinimonDisplayBlockEntityRenderer(class_5614.class_5615 context) {
        this.entityRenderDispatcher = class_310.method_1551().method_1561();
        if (!reflectionInitialized && !reflectionFailed) {
            MinimonDisplayBlockEntityRenderer.initializeReflection();
        }
    }

    private static void initializeReflection() {
        reflectionInitialized = true;
        try {
            pokemonEntityClass = Class.forName("com.cobblemon.mod.common.entity.pokemon.PokemonEntity");
            pokemonClass = Class.forName("com.cobblemon.mod.common.pokemon.Pokemon");
            speciesClass = Class.forName("com.cobblemon.mod.common.pokemon.Species");
            Class<?> pokemonSpeciesClass = Class.forName("com.cobblemon.mod.common.api.pokemon.PokemonSpecies");
            Field instanceField = pokemonSpeciesClass.getField("INSTANCE");
            pokemonSpeciesRegistry = instanceField.get(null);
            Minimons.LOGGER.debug("Minimons renderer reflection initialized successfully");
        }
        catch (Exception e) {
            reflectionFailed = true;
            Minimons.LOGGER.error("Failed to initialize Cobblemon reflection: {}", (Object)e.getMessage());
        }
    }

    public void render(MinimonDisplayBlockEntity blockEntity, float partialTick, class_4587 poseStack, class_4597 bufferSource, int packedLight, int packedOverlay) {
        class_2338 pos;
        double distSq;
        MinimonData data = blockEntity.getMinimonData();
        if (data == null || !data.isValid()) {
            return;
        }
        if (reflectionFailed || pokemonEntityClass == null) {
            return;
        }
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 != null && (distSq = mc.field_1724.method_5649((double)(pos = blockEntity.method_11016()).method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5)) > 2304.0) {
            return;
        }
        try {
            this.renderPokemonEntity(blockEntity, data, partialTick, poseStack, bufferSource, packedLight);
        }
        catch (Throwable t) {
            Minimons.LOGGER.debug("Failed to render Minimon: {}", (Object)t.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void renderPokemonEntity(MinimonDisplayBlockEntity blockEntity, MinimonData data, float partialTick, class_4587 poseStack, class_4597 bufferSource, int packedLight) throws Exception {
        class_1297 pokemonEntity;
        class_2338 pos;
        class_1937 level;
        block20: {
            level = blockEntity.method_10997();
            if (level == null) {
                return;
            }
            pos = blockEntity.method_11016();
            String aspectsStr = data.getAspects() != null ? String.join((CharSequence)",", data.getAspects()) : "";
            String cacheKey = pos.method_23854() + "_" + data.getSpeciesId() + "_" + data.isShiny() + "_" + data.getFormName() + "_" + data.getGender() + "_" + aspectsStr;
            pokemonEntity = (class_1297)entityCache.get(cacheKey);
            String currentAnimName = blockEntity.getCurrentAnimation().getAnimationName();
            if (pokemonEntity == null) {
                pokemonEntity = this.createPokemonEntity(level, data, blockEntity.getCurrentAnimation());
                if (pokemonEntity != null) {
                    entityCache.put(cacheKey, pokemonEntity);
                    this.lastAnimationMap.put(pos, currentAnimName);
                    Minimons.LOGGER.debug("Created Pokemon entity for display at {}: {} (shiny={}, form={}, aspects=[{}])", new Object[]{pos.method_23854(), data.getSpeciesId(), data.isShiny(), data.getFormName(), aspectsStr});
                    break block20;
                } else {
                    long now = System.currentTimeMillis();
                    if (now - lastLogTime > 1000L) {
                        Minimons.LOGGER.warn("Failed to create Pokemon entity for: {}", (Object)cacheKey);
                        lastLogTime = now;
                    }
                    return;
                }
            }
            String lastAnim = this.lastAnimationMap.get(pos);
            if (lastAnim == null || !lastAnim.equals(currentAnimName)) {
                boolean needsClearBattle;
                PokemonAnimation currentAnimation = blockEntity.getCurrentAnimation();
                Boolean wasBattling = this.entityBattleStateMap.get(pos);
                boolean bl = needsClearBattle = wasBattling != null && wasBattling != false && !currentAnimation.isBattleAnimation();
                if (needsClearBattle) {
                    this.setBattleState(pokemonEntity, false);
                }
                this.updateEntityPose(pokemonEntity, currentAnimation);
                this.lastAnimationMap.put(pos, currentAnimName);
                this.entityBattleStateMap.put(pos, currentAnimation.isBattleAnimation());
            }
        }
        try {
            int currentGameTick = (int)(level.method_8510() % Integer.MAX_VALUE);
            Integer lastGameTick = this.lastGameTickMap.get(pos);
            if (lastGameTick == null || currentGameTick != lastGameTick) {
                double savedX = pokemonEntity.method_23317();
                double savedY = pokemonEntity.method_23318();
                double savedZ = pokemonEntity.method_23321();
                this.disablePoseRecalculation(pokemonEntity);
                pokemonEntity.method_5773();
                ++pokemonEntity.field_6012;
                pokemonEntity.method_5814(savedX, savedY, savedZ);
                this.lastGameTickMap.put(pos, currentGameTick);
            }
        }
        catch (Exception currentGameTick) {
            // empty catch block
        }
        poseStack.method_22903();
        float yOffset = 0.2f;
        class_2248 block = blockEntity.method_11010().method_26204();
        if (block == MinimonBlocks.DISPLAY_PEDESTAL) {
            yOffset = 1.0f;
        } else if (block == MinimonBlocks.DISPLAY) {
            yOffset = 0.125f;
        }
        poseStack.method_22904(0.5, (double)yOffset, 0.5);
        class_2350 facing = (class_2350)blockEntity.method_11010().method_11654((class_2769)MinimonDisplayBlock.FACING);
        float facingRotation = switch (facing) {
            case class_2350.field_11043 -> 0.0f;
            case class_2350.field_11035 -> 180.0f;
            case class_2350.field_11039 -> 90.0f;
            case class_2350.field_11034 -> -90.0f;
            default -> 0.0f;
        };
        float rotation = blockEntity.getRotation();
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(180.0f - rotation + facingRotation));
        float scale = data.getScale();
        poseStack.method_22905(scale, scale, scale);
        if (!shadowDisabled) {
            this.entityRenderDispatcher.method_3948(false);
            shadowDisabled = true;
        }
        this.entityRenderDispatcher.method_3954(pokemonEntity, 0.0, 0.0, 0.0, 0.0f, partialTick, poseStack, bufferSource, packedLight);
        poseStack.method_22909();
    }

    public static void resetShadowState() {
        if (shadowDisabled) {
            class_310.method_1551().method_1561().method_3948(true);
            shadowDisabled = false;
        }
    }

    private class_1297 createPokemonEntity(class_1937 level, MinimonData data, PokemonAnimation animation) {
        try {
            Object pokemon;
            block70: {
                class_2960 speciesLoc;
                String speciesId = data.getSpeciesId();
                if (speciesId.contains(":")) {
                    String[] parts = speciesId.split(":");
                    speciesLoc = class_2960.method_60655((String)parts[0], (String)parts[1]);
                } else {
                    speciesLoc = class_2960.method_60655((String)"cobblemon", (String)speciesId);
                }
                Method getByIdentifier = pokemonSpeciesRegistry.getClass().getMethod("getByIdentifier", class_2960.class);
                Object species = getByIdentifier.invoke(pokemonSpeciesRegistry, speciesLoc);
                if (species == null) {
                    Minimons.LOGGER.warn("Species not found: {}", (Object)speciesId);
                    return null;
                }
                Constructor<?> pokemonConstructor = pokemonClass.getConstructor(new Class[0]);
                pokemon = pokemonConstructor.newInstance(new Object[0]);
                Method setSpecies = pokemonClass.getMethod("setSpecies", speciesClass);
                setSpecies.invoke(pokemon, species);
                String formName = data.getFormName();
                if (formName != null && !formName.isEmpty()) {
                    try {
                        Method getForm = species.getClass().getMethod("getForm", String.class);
                        Object form = getForm.invoke(species, formName);
                        if (form == null) break block70;
                        Class<?> formClass = form.getClass();
                        for (Method method : pokemonClass.getMethods()) {
                            if (!method.getName().equals("setForm") || method.getParameterCount() != 1 || !method.getParameterTypes()[0].isAssignableFrom(formClass)) continue;
                            method.invoke(pokemon, form);
                            Minimons.LOGGER.debug("Applied form: {}", (Object)formName);
                            break;
                        }
                    }
                    catch (NoSuchMethodException e) {
                        try {
                            Method getForms = species.getClass().getMethod("getForms", new Class[0]);
                            Object forms = getForms.invoke(species, new Object[0]);
                            if (!(forms instanceof Iterable)) break block70;
                            for (Object form : (Iterable)forms) {
                                Method getFormName = form.getClass().getMethod("getName", new Class[0]);
                                String string = getFormName.invoke(form, new Object[0]).toString();
                                if (!string.equalsIgnoreCase(formName)) continue;
                                for (Method m : pokemonClass.getMethods()) {
                                    if (!m.getName().equals("setForm") || m.getParameterCount() != 1 || !m.getParameterTypes()[0].isAssignableFrom(form.getClass())) continue;
                                    m.invoke(pokemon, form);
                                    Minimons.LOGGER.debug("Applied form (via iteration): {}", (Object)formName);
                                }
                            }
                        }
                        catch (Exception e2) {
                            Minimons.LOGGER.debug("Could not set form {}: {}", (Object)formName, (Object)e2.getMessage());
                        }
                    }
                }
            }
            try {
                Method setShiny = pokemonClass.getMethod("setShiny", Boolean.TYPE);
                setShiny.invoke(pokemon, data.isShiny());
            }
            catch (Exception e) {
                Minimons.LOGGER.debug("Could not set shiny: {}", (Object)e.getMessage());
            }
            String gender = data.getGender();
            if (gender != null && !gender.isEmpty() && !gender.equals("genderless")) {
                try {
                    Class<?> genderClass = Class.forName("com.cobblemon.mod.common.api.pokemon.Gender");
                    Object genderValue = null;
                    ?[] objArray = genderClass.getEnumConstants();
                    int form = objArray.length;
                    for (int getFormName = 0; getFormName < form; ++getFormName) {
                        Object obj = objArray[getFormName];
                        if (!obj.toString().equalsIgnoreCase(gender)) continue;
                        genderValue = obj;
                        break;
                    }
                    if (genderValue != null) {
                        Method method = pokemonClass.getMethod("setGender", genderClass);
                        method.invoke(pokemon, genderValue);
                    }
                }
                catch (Exception e) {
                    Minimons.LOGGER.debug("Could not set gender: {}", (Object)e.getMessage());
                }
            }
            try {
                Set<String> aspects = data.getAspects();
                if (aspects != null && !aspects.isEmpty()) {
                    try {
                        Method setForcedAspects = pokemonClass.getMethod("setForcedAspects", Set.class);
                        setForcedAspects.invoke(pokemon, aspects);
                        Minimons.LOGGER.debug("Set forced aspects on Pokemon before entity: {}", aspects);
                    }
                    catch (NoSuchMethodException e) {
                        Method method = pokemonClass.getMethod("setAspects", Set.class);
                        method.invoke(pokemon, aspects);
                    }
                }
                try {
                    Method updateAspects = pokemonClass.getMethod("updateAspects", new Class[0]);
                    updateAspects.invoke(pokemon, new Object[0]);
                }
                catch (NoSuchMethodException updateAspects) {}
            }
            catch (Exception e) {
                Minimons.LOGGER.debug("Could not set aspects: {}", (Object)e.getMessage());
            }
            Object entity = null;
            Object pokemonEntityType = null;
            try {
                Class<?> clazz = Class.forName("com.cobblemon.mod.common.CobblemonEntities");
                Field pokemonTypeField = clazz.getField("POKEMON");
                pokemonEntityType = pokemonTypeField.get(null);
            }
            catch (Exception exception) {
                Minimons.LOGGER.warn("Failed to get POKEMON entity type: {}", (Object)exception.getMessage());
                return null;
            }
            if (pokemonEntityType != null) {
                try {
                    for (Constructor<?> constructor : pokemonEntityClass.getConstructors()) {
                        Class<?>[] params = constructor.getParameterTypes();
                        if (params.length != 3 || !params[0].isAssignableFrom(level.getClass()) || !params[1].isAssignableFrom(pokemon.getClass())) continue;
                        entity = (class_1297)constructor.newInstance(level, pokemon, pokemonEntityType);
                        break;
                    }
                }
                catch (Exception exception) {
                    Minimons.LOGGER.warn("Failed to create PokemonEntity: {}", (Object)exception.getMessage());
                }
            }
            if (entity != null) {
                try {
                    block74: {
                        block73: {
                            Set<String> aspects;
                            Method method = entity.getClass().getMethod("getPokemon", new Class[0]);
                            Object entityPokemon = method.invoke(entity, new Object[0]);
                            if (entityPokemon != null) {
                                block72: {
                                    Set<String> aspects2 = data.getAspects();
                                    if (aspects2 != null && !aspects2.isEmpty()) {
                                        try {
                                            Method method2 = entityPokemon.getClass().getMethod("setForcedAspects", Set.class);
                                            method2.invoke(entityPokemon, aspects2);
                                            Minimons.LOGGER.debug("Set forced aspects on Pokemon: {}", aspects2);
                                        }
                                        catch (NoSuchMethodException noSuchMethodException) {
                                            try {
                                                Method setAspects = entityPokemon.getClass().getMethod("setAspects", Set.class);
                                                setAspects.invoke(entityPokemon, aspects2);
                                            }
                                            catch (Exception setAspects) {
                                                // empty catch block
                                            }
                                        }
                                    }
                                    try {
                                        Method method3 = entityPokemon.getClass().getMethod("setShiny", Boolean.TYPE);
                                        method3.invoke(entityPokemon, data.isShiny());
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    String string = data.getFormName();
                                    if (!(string == null || string.isEmpty() || string.equalsIgnoreCase("normal") || string.equalsIgnoreCase("standard"))) {
                                        try {
                                            Method getForm;
                                            Object form;
                                            Method getSpeciesMethod = entityPokemon.getClass().getMethod("getSpecies", new Class[0]);
                                            Object entitySpecies = getSpeciesMethod.invoke(entityPokemon, new Object[0]);
                                            if (entitySpecies == null || (form = (getForm = entitySpecies.getClass().getMethod("getForm", String.class)).invoke(entitySpecies, string)) == null) break block72;
                                            for (Method m : entityPokemon.getClass().getMethods()) {
                                                if (!m.getName().equals("setForm") || m.getParameterCount() != 1) continue;
                                                m.invoke(entityPokemon, form);
                                                break;
                                            }
                                        }
                                        catch (Exception getSpeciesMethod) {
                                            // empty catch block
                                        }
                                    }
                                }
                                try {
                                    Method updateAspects = entityPokemon.getClass().getMethod("updateAspects", new Class[0]);
                                    updateAspects.invoke(entityPokemon, new Object[0]);
                                    Minimons.LOGGER.debug("Called updateAspects on Pokemon");
                                }
                                catch (NoSuchMethodException updateAspects) {
                                    // empty catch block
                                }
                                try {
                                    Method getAspects = entityPokemon.getClass().getMethod("getAspects", new Class[0]);
                                    Object finalAspects = getAspects.invoke(entityPokemon, new Object[0]);
                                    Minimons.LOGGER.debug("Final Pokemon aspects: {}", finalAspects);
                                }
                                catch (Exception getAspects) {
                                    // empty catch block
                                }
                            }
                            if ((aspects = data.getAspects()) != null && !aspects.isEmpty()) {
                                try {
                                    Class<?> clazz = Class.forName("com.cobblemon.mod.common.entity.pokemon.PokemonEntity$Companion");
                                    Field companionInstance = entity.getClass().getField("Companion");
                                    Object companion = companionInstance.get(null);
                                    Method getAspectsAccessor = clazz.getMethod("getASPECTS", new Class[0]);
                                    Object aspectsAccessor = getAspectsAccessor.invoke(companion, new Object[0]);
                                    if (aspectsAccessor == null) break block73;
                                    Object entityData = null;
                                    block50: for (Class<?> currentClass = entity.getClass(); currentClass != null && entityData == null; currentClass = currentClass.getSuperclass()) {
                                        Field[] fieldArray = currentClass.getDeclaredFields();
                                        int m = fieldArray.length;
                                        for (int i = 0; i < m; ++i) {
                                            Field f = fieldArray[i];
                                            String typeName = f.getType().getName();
                                            if (!typeName.contains("SynchedEntityData") && !typeName.contains("class_2945")) continue;
                                            f.setAccessible(true);
                                            entityData = f.get(entity);
                                            continue block50;
                                        }
                                    }
                                    if (entityData == null) break block73;
                                    for (Method m : entityData.getClass().getMethods()) {
                                        Class<?> param0Type;
                                        if (m.getParameterCount() != 2 || !(param0Type = m.getParameterTypes()[0]).isAssignableFrom(aspectsAccessor.getClass())) continue;
                                        m.invoke(entityData, aspectsAccessor, aspects);
                                        Minimons.LOGGER.debug("Set entity aspects via synced data: {}", aspects);
                                        break;
                                    }
                                }
                                catch (Exception exception) {
                                    Minimons.LOGGER.debug("Could not set entity aspects via synced data: {}", (Object)exception.getMessage());
                                }
                            }
                        }
                        try {
                            Class<?> clazz = Class.forName("com.cobblemon.mod.common.entity.PoseType");
                            Object poseType = null;
                            String poseTypeName = animation.getPoseTypeName();
                            for (Object enumConst : clazz.getEnumConstants()) {
                                if (!enumConst.toString().equalsIgnoreCase(poseTypeName)) continue;
                                poseType = enumConst;
                                break;
                            }
                            if (poseType == null) break block74;
                            try {
                                Method setEnablePoseTypeRecalculation = entity.getClass().getMethod("setEnablePoseTypeRecalculation", Boolean.TYPE);
                                setEnablePoseTypeRecalculation.invoke(entity, false);
                                Minimons.LOGGER.debug("Disabled pose type recalculation");
                            }
                            catch (Exception e) {
                                Minimons.LOGGER.debug("Could not disable pose recalculation: {}", (Object)e.getMessage());
                            }
                            try {
                                Class<?> companionClass = Class.forName("com.cobblemon.mod.common.entity.pokemon.PokemonEntity$Companion");
                                Field companionInstance = entity.getClass().getField("Companion");
                                Object companion = companionInstance.get(null);
                                Method getPoseTypeAccessor = companionClass.getMethod("getPOSE_TYPE", new Class[0]);
                                Object poseTypeAccessor = getPoseTypeAccessor.invoke(companion, new Object[0]);
                                if (poseTypeAccessor == null) break block74;
                                Object entityData = null;
                                block54: for (Class<?> currentClass = entity.getClass(); currentClass != null && entityData == null; currentClass = currentClass.getSuperclass()) {
                                    for (AccessibleObject accessibleObject : currentClass.getDeclaredFields()) {
                                        String typeName = ((Field)accessibleObject).getType().getName();
                                        if (!typeName.contains("SynchedEntityData") && !typeName.contains("class_2945")) continue;
                                        ((Field)accessibleObject).setAccessible(true);
                                        entityData = ((Field)accessibleObject).get(entity);
                                        continue block54;
                                    }
                                }
                                if (entityData == null) break block74;
                                for (AccessibleObject accessibleObject : entityData.getClass().getMethods()) {
                                    Class<?> param0Type;
                                    if (((Method)accessibleObject).getParameterCount() != 2 || !(param0Type = ((Method)accessibleObject).getParameterTypes()[0]).isAssignableFrom(poseTypeAccessor.getClass())) continue;
                                    ((Method)accessibleObject).invoke(entityData, poseTypeAccessor, poseType);
                                    Minimons.LOGGER.debug("Set pose type via synced data: {}", (Object)poseTypeName);
                                    break;
                                }
                            }
                            catch (Exception e) {
                                Minimons.LOGGER.debug("Could not set pose via EntityDataAccessor: {}", (Object)e.getMessage());
                            }
                        }
                        catch (Exception exception) {
                            Minimons.LOGGER.debug("Could not set animation pose: {}", (Object)exception.getMessage());
                        }
                    }
                    try {
                        Method method = entity.getClass().getMethod("refreshDimensions", new Class[0]);
                        method.invoke(entity, new Object[0]);
                    }
                    catch (Exception exception) {}
                }
                catch (Exception exception) {
                    Minimons.LOGGER.debug("Error updating entity aspects: {}", (Object)exception.getMessage());
                }
            }
            return entity;
        }
        catch (Exception e) {
            Minimons.LOGGER.error("Failed to create Pokemon entity: {}", (Object)e.getMessage());
            return null;
        }
    }

    private void updateEntityPose(class_1297 entity, PokemonAnimation animation) {
        try {
            switch (animation.getAnimationType()) {
                case POSE: {
                    this.updatePoseType(entity, animation.getPoseTypeName(), false);
                    break;
                }
                case BATTLE: {
                    this.setBattleState(entity, true);
                    this.updatePoseType(entity, animation.getPoseTypeName(), true);
                    break;
                }
                case NAMED: {
                    this.setBattleState(entity, true);
                    this.triggerNamedAnimation(entity, animation.getPoseTypeName());
                }
            }
        }
        catch (Exception e) {
            Minimons.LOGGER.debug("Error updating entity pose/animation: {}", (Object)e.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    private void setBattleState(class_1297 entity, boolean battling) {
        try {
            Object delegate;
            for (Method method : entity.getClass().getMethods()) {
                Class<?> paramType;
                String methodName = method.getName();
                if (!methodName.equals("setBattleId") && !methodName.equals("setBattling") || method.getParameterCount() != 1 || !(paramType = method.getParameterTypes()[0]).getName().contains("UUID") && !paramType.getName().contains("Optional")) continue;
                if (paramType.getName().contains("Optional")) {
                    Class<?> optionalClass = Class.forName("java.util.Optional");
                    Object optValue = battling ? optionalClass.getMethod("of", Object.class).invoke(null, UUID.randomUUID()) : optionalClass.getMethod("empty", new Class[0]).invoke(null, new Object[0]);
                    method.invoke((Object)entity, optValue);
                } else {
                    UUID uuid = battling ? UUID.randomUUID() : null;
                    method.invoke((Object)entity, uuid);
                }
                Minimons.LOGGER.debug("Set entity battle ID via method to: {}", (Object)battling);
                return;
            }
            for (AccessibleObject accessibleObject : entity.getClass().getDeclaredFields()) {
                String name = ((Field)accessibleObject).getName().toLowerCase();
                if (!name.equals("battleid") && (!name.contains("battle") || !name.contains("id"))) continue;
                ((Field)accessibleObject).setAccessible(true);
                String typeName = ((Field)accessibleObject).getType().getName();
                if (typeName.contains("Optional")) {
                    Class<?> optionalClass = Class.forName("java.util.Optional");
                    Object optValue = battling ? optionalClass.getMethod("of", Object.class).invoke(null, UUID.randomUUID()) : optionalClass.getMethod("empty", new Class[0]).invoke(null, new Object[0]);
                    ((Field)accessibleObject).set(entity, optValue);
                    Minimons.LOGGER.debug("Set entity battleId field to: {}", (Object)battling);
                    return;
                }
                if (!typeName.contains("UUID")) continue;
                UUID uuid = battling ? UUID.randomUUID() : null;
                ((Field)accessibleObject).set(entity, uuid);
                Minimons.LOGGER.debug("Set entity battleId field to: {}", (Object)battling);
                return;
            }
            for (Class<?> currentClass = entity.getClass().getSuperclass(); currentClass != null && currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
                void var6_14;
                Field[] fieldArray = currentClass.getDeclaredFields();
                int n = fieldArray.length;
                boolean bl = false;
                while (var6_14 < n) {
                    Field f = fieldArray[var6_14];
                    String name = f.getName().toLowerCase();
                    if (name.equals("battleid") || name.contains("battle") && name.contains("id")) {
                        f.setAccessible(true);
                        String typeName = f.getType().getName();
                        if (typeName.contains("Optional")) {
                            Class<?> optionalClass = Class.forName("java.util.Optional");
                            Object optValue = battling ? optionalClass.getMethod("of", Object.class).invoke(null, UUID.randomUUID()) : optionalClass.getMethod("empty", new Class[0]).invoke(null, new Object[0]);
                            f.set(entity, optValue);
                            Minimons.LOGGER.debug("Set entity battleId field (superclass) to: {}", (Object)battling);
                            return;
                        }
                        if (typeName.contains("UUID")) {
                            UUID uuid = battling ? UUID.randomUUID() : null;
                            f.set(entity, uuid);
                            Minimons.LOGGER.debug("Set entity battleId field (superclass) to: {}", (Object)battling);
                            return;
                        }
                    }
                    ++var6_14;
                }
            }
            Method getDelegateMethod = null;
            for (Method m : entity.getClass().getMethods()) {
                if (!m.getName().equals("getDelegate") || m.getParameterCount() != 0) continue;
                getDelegateMethod = m;
                break;
            }
            if (getDelegateMethod != null && (delegate = getDelegateMethod.invoke((Object)entity, new Object[0])) != null) {
                for (Method m : delegate.getClass().getMethods()) {
                    if (!m.getName().contains("setBattleId") && !m.getName().contains("setBattling") || m.getParameterCount() != 1) continue;
                    Class<?> paramType = m.getParameterTypes()[0];
                    if (paramType == Boolean.TYPE) {
                        m.invoke(delegate, battling);
                        Minimons.LOGGER.debug("Set delegate battle state to: {}", (Object)battling);
                        return;
                    }
                    if (!paramType.getName().contains("UUID")) continue;
                    UUID uuid = battling ? UUID.randomUUID() : null;
                    m.invoke(delegate, uuid);
                    Minimons.LOGGER.debug("Set delegate battle ID to: {}", (Object)uuid);
                    return;
                }
            }
            Minimons.LOGGER.debug("Could not set battle state - particles may not show for this Pokemon");
        }
        catch (Exception e) {
            Minimons.LOGGER.debug("Error setting battle state: {}", (Object)e.getMessage());
        }
    }

    private void triggerNamedAnimation(class_1297 entity, String animationName) {
        try {
            Method getDelegateMethod = null;
            for (Method m : entity.getClass().getMethods()) {
                if (!m.getName().equals("getDelegate") || m.getParameterCount() != 0) continue;
                getDelegateMethod = m;
                break;
            }
            if (getDelegateMethod == null) {
                Minimons.LOGGER.debug("No getDelegate method found on entity");
                return;
            }
            Object delegate = getDelegateMethod.invoke((Object)entity, new Object[0]);
            if (delegate == null) {
                Minimons.LOGGER.debug("Delegate is null");
                return;
            }
            if (!hasLoggedAnimationMethods) {
                hasLoggedAnimationMethods = true;
                Minimons.LOGGER.debug("[MinimonDisplay] Delegate class: {}", (Object)delegate.getClass().getName());
                for (Method m : delegate.getClass().getMethods()) {
                    String methodName = m.getName();
                    if (!methodName.contains("Animation") && !methodName.contains("animation") && !methodName.contains("State") && !methodName.contains("state") && !methodName.contains("Model") && !methodName.contains("model") && !methodName.contains("Current") && !methodName.contains("current")) continue;
                    StringBuilder params = new StringBuilder();
                    for (Class<?> p : m.getParameterTypes()) {
                        if (params.length() > 0) {
                            params.append(", ");
                        }
                        params.append(p.getSimpleName());
                    }
                    Minimons.LOGGER.debug("[MinimonDisplay] Method: {}({}) -> {}", new Object[]{m.getName(), params, m.getReturnType().getSimpleName()});
                }
            }
            Object currentModel = null;
            try {
                Method getCurrentModelMethod = delegate.getClass().getMethod("getCurrentModel", new Class[0]);
                currentModel = getCurrentModelMethod.invoke(delegate, new Object[0]);
                if (currentModel == null) {
                    Minimons.LOGGER.warn("[MinimonDisplay] currentModel is null on delegate - animation '{}' cannot be triggered", (Object)animationName);
                    return;
                }
            }
            catch (NoSuchMethodException e) {
                Minimons.LOGGER.debug("[MinimonDisplay] No getCurrentModel method found");
            }
            for (Method m : delegate.getClass().getMethods()) {
                if (!m.getName().equals("addFirstAnimation") || m.getParameterCount() != 1) continue;
                HashSet<String> animSet = new HashSet<String>();
                animSet.add(animationName);
                m.invoke(delegate, animSet);
                Minimons.LOGGER.debug("[MinimonDisplay] Triggered animation '{}' via addFirstAnimation (model={})", (Object)animationName, (Object)(currentModel != null ? currentModel.getClass().getSimpleName() : "null"));
                return;
            }
            Minimons.LOGGER.warn("[MinimonDisplay] Could not find addFirstAnimation method, animation '{}' not triggered", (Object)animationName);
        }
        catch (Exception e) {
            Minimons.LOGGER.warn("Error triggering named animation '{}': {}", (Object)animationName, (Object)e.getMessage());
            e.printStackTrace();
        }
    }

    private void updatePoseType(class_1297 entity, String poseTypeName, boolean isBattleContext) {
        block10: {
            try {
                Class<?> poseTypeClass = Class.forName("com.cobblemon.mod.common.entity.PoseType");
                Object poseType = null;
                for (Object enumConst : poseTypeClass.getEnumConstants()) {
                    if (!enumConst.toString().equalsIgnoreCase(poseTypeName)) continue;
                    poseType = enumConst;
                    break;
                }
                if (poseType == null) break block10;
                try {
                    Method setEnablePoseTypeRecalculation = entity.getClass().getMethod("setEnablePoseTypeRecalculation", Boolean.TYPE);
                    setEnablePoseTypeRecalculation.invoke((Object)entity, false);
                }
                catch (Exception setEnablePoseTypeRecalculation) {
                    // empty catch block
                }
                try {
                    Class<?> companionClass = Class.forName("com.cobblemon.mod.common.entity.pokemon.PokemonEntity$Companion");
                    Field companionInstance = entity.getClass().getField("Companion");
                    Object companion = companionInstance.get(null);
                    Method getPoseTypeAccessor = companionClass.getMethod("getPOSE_TYPE", new Class[0]);
                    Object poseTypeAccessor = getPoseTypeAccessor.invoke(companion, new Object[0]);
                    if (poseTypeAccessor == null) break block10;
                    Object entityData = null;
                    block7: for (Class<?> currentClass = entity.getClass(); currentClass != null && entityData == null; currentClass = currentClass.getSuperclass()) {
                        for (AccessibleObject accessibleObject : currentClass.getDeclaredFields()) {
                            String typeName = ((Field)accessibleObject).getType().getName();
                            if (!typeName.contains("SynchedEntityData") && !typeName.contains("class_2945")) continue;
                            ((Field)accessibleObject).setAccessible(true);
                            entityData = ((Field)accessibleObject).get(entity);
                            continue block7;
                        }
                    }
                    if (entityData == null) break block10;
                    for (AccessibleObject accessibleObject : entityData.getClass().getMethods()) {
                        Class<?> param0Type;
                        if (((Method)accessibleObject).getParameterCount() != 2 || !(param0Type = ((Method)accessibleObject).getParameterTypes()[0]).isAssignableFrom(poseTypeAccessor.getClass())) continue;
                        ((Method)accessibleObject).invoke(entityData, poseTypeAccessor, poseType);
                        Minimons.LOGGER.debug("Updated pose to: {} (battle context: {})", (Object)poseTypeName, (Object)isBattleContext);
                        break;
                    }
                }
                catch (Exception e) {
                    Minimons.LOGGER.debug("Could not update pose: {}", (Object)e.getMessage());
                }
            }
            catch (Exception e) {
                Minimons.LOGGER.debug("Error updating entity pose: {}", (Object)e.getMessage());
            }
        }
    }

    private void disablePoseRecalculation(class_1297 entity) {
        if (!poseMethodCached) {
            poseMethodCached = true;
            try {
                setEnablePoseTypeRecalculationMethod = entity.getClass().getMethod("setEnablePoseTypeRecalculation", Boolean.TYPE);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (setEnablePoseTypeRecalculationMethod != null) {
            try {
                setEnablePoseTypeRecalculationMethod.invoke((Object)entity, false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void clearCache() {
        entityCache.clear();
    }

    public boolean shouldRenderOffScreen(MinimonDisplayBlockEntity blockEntity) {
        return true;
    }

    public int method_33893() {
        return 48;
    }
}

