/*
 * Decompiled with CFR 0.152.
 */
package com.minimons.client.screen;

import com.minimons.Minimons;
import com.minimons.block.MinimonDisplayBlock;
import com.minimons.block.entity.MinimonDisplayBlockEntity;
import com.minimons.block.entity.PokemonAnimation;
import com.minimons.client.network.MinimonClientNetworking;
import com.minimons.data.MinimonData;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Set;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_638;
import net.minecraft.class_7833;
import net.minecraft.class_7919;
import net.minecraft.class_898;

@Environment(value=EnvType.CLIENT)
public class MinimonDisplayScreen
extends class_437 {
    private final MinimonDisplayBlockEntity blockEntity;
    private final class_2338 blockPos;
    private PokemonAnimation selectedAnimation;
    private float currentScale;
    private boolean autoRotate;
    private class_1297 previewEntity;
    private float previewRotation = 0.0f;
    private float facingRotation = 0.0f;
    private boolean previewDragging = false;
    private double lastMouseX;
    private long lastPreviewTickTime = 0L;
    private static final long PREVIEW_TICK_INTERVAL_MS = 50L;
    private long lastNamedAnimationTime = 0L;
    private static final long NAMED_ANIMATION_COOLDOWN_MS = 3000L;
    private static final float MIN_SCALE = 0.05f;
    private static final float MAX_SCALE = 1.0f;
    private static final float SCALE_STEP = 0.05f;
    private static final int GUI_WIDTH = 300;
    private static final int MAX_GUI_HEIGHT = 210;
    private static final int CONTROLS_WIDTH = 176;
    private static final int PREVIEW_WIDTH = 110;
    private int guiHeight;
    private int leftPos;
    private int topPos;
    private class_4185 scaleLabelButton;
    private class_4185 autoRotateButton;
    private static Class<?> pokemonEntityClass = null;
    private static Class<?> pokemonClass = null;
    private static Class<?> speciesClass = null;
    private static Object pokemonSpeciesRegistry = null;
    private static boolean reflectionInitialized = false;
    private boolean previewInBattleState = false;

    public MinimonDisplayScreen(MinimonDisplayBlockEntity blockEntity) {
        super((class_2561)class_2561.method_43471((String)"screen.minimons.display"));
        this.blockEntity = blockEntity;
        this.blockPos = blockEntity.method_11016();
        this.selectedAnimation = blockEntity.getCurrentAnimation();
        this.currentScale = blockEntity.getScale();
        this.autoRotate = blockEntity.isAutoRotating();
        this.previewRotation = blockEntity.getRotation();
        class_2350 facing = (class_2350)blockEntity.method_11010().method_11654((class_2769)MinimonDisplayBlock.FACING);
        this.facingRotation = switch (facing) {
            case class_2350.field_11043 -> 0.0f;
            case class_2350.field_11035 -> 180.0f;
            case class_2350.field_11039 -> 90.0f;
            case class_2350.field_11034 -> -90.0f;
            default -> 0.0f;
        };
        MinimonDisplayScreen.initializeReflection();
        this.createPreviewEntity();
    }

    private static void initializeReflection() {
        if (reflectionInitialized) {
            return;
        }
        reflectionInitialized = true;
        try {
            pokemonEntityClass = Class.forName("com.cobblemon.mod.common.entity.pokemon.PokemonEntity");
            pokemonClass = Class.forName("com.cobblemon.mod.common.pokemon.Pokemon");
            speciesClass = Class.forName("com.cobblemon.mod.common.pokemon.Species");
            Class<?> pokemonSpeciesClass = Class.forName("com.cobblemon.mod.common.api.pokemon.PokemonSpecies");
            Field instanceField = pokemonSpeciesClass.getField("INSTANCE");
            pokemonSpeciesRegistry = instanceField.get(null);
        }
        catch (Exception e) {
            Minimons.LOGGER.error("Failed to initialize reflection for preview: {}", (Object)e.getMessage());
        }
    }

    private void createPreviewEntity() {
        MinimonData data = this.blockEntity.getMinimonData();
        if (data == null || !data.isValid() || pokemonEntityClass == null) {
            Minimons.LOGGER.debug("Cannot create preview: data={}, valid={}, class={}", new Object[]{data, data != null ? Boolean.valueOf(data.isValid()) : "null", pokemonEntityClass});
            return;
        }
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            Minimons.LOGGER.debug("Cannot create preview: level is null");
            return;
        }
        try {
            block31: {
                Set<String> aspects;
                Object pokemon;
                block30: {
                    String formName;
                    class_2960 speciesLoc;
                    String speciesId = data.getSpeciesId();
                    if (speciesId.contains(":")) {
                        String[] parts = speciesId.split(":");
                        speciesLoc = class_2960.method_60655((String)parts[0], (String)parts[1]);
                    } else {
                        speciesLoc = class_2960.method_60655((String)"cobblemon", (String)speciesId);
                    }
                    Method getByIdentifier = pokemonSpeciesRegistry.getClass().getMethod("getByIdentifier", class_2960.class);
                    Object species = getByIdentifier.invoke(pokemonSpeciesRegistry, speciesLoc);
                    if (species == null) {
                        Minimons.LOGGER.debug("Cannot create preview: species not found for {}", (Object)speciesId);
                        return;
                    }
                    Constructor<?> pokemonConstructor = pokemonClass.getConstructor(new Class[0]);
                    pokemon = pokemonConstructor.newInstance(new Object[0]);
                    Method setSpecies = pokemonClass.getMethod("setSpecies", speciesClass);
                    setSpecies.invoke(pokemon, species);
                    if (data.isShiny()) {
                        try {
                            Method setShiny = pokemonClass.getMethod("setShiny", Boolean.TYPE);
                            setShiny.invoke(pokemon, true);
                        }
                        catch (Exception setShiny) {
                            // empty catch block
                        }
                    }
                    if ((formName = data.getFormName()) != null && !formName.isEmpty()) {
                        try {
                            Method getForm = species.getClass().getMethod("getForm", String.class);
                            Object form = getForm.invoke(species, formName);
                            if (form == null) break block30;
                            Method[] methodArray = pokemonClass.getMethods();
                            int n = methodArray.length;
                            for (int i = 0; i < n; ++i) {
                                Method m = methodArray[i];
                                if (!m.getName().equals("setForm") || m.getParameterCount() != 1 || !m.getParameterTypes()[0].isAssignableFrom(form.getClass())) continue;
                                m.invoke(pokemon, form);
                                break;
                            }
                        }
                        catch (Exception getForm) {
                            // empty catch block
                        }
                    }
                }
                if ((aspects = data.getAspects()) != null && !aspects.isEmpty()) {
                    try {
                        Method setForcedAspects = pokemonClass.getMethod("setForcedAspects", Set.class);
                        setForcedAspects.invoke(pokemon, aspects);
                    }
                    catch (NoSuchMethodException e) {
                        try {
                            Method setAspects = pokemonClass.getMethod("setAspects", Set.class);
                            setAspects.invoke(pokemon, aspects);
                        }
                        catch (Exception setAspects) {
                            // empty catch block
                        }
                    }
                }
                Object pokemonEntityType = null;
                try {
                    Class<?> cobblemonEntitiesClass = Class.forName("com.cobblemon.mod.common.CobblemonEntities");
                    Field pokemonTypeField = cobblemonEntitiesClass.getField("POKEMON");
                    pokemonEntityType = pokemonTypeField.get(null);
                }
                catch (Exception e) {
                    Minimons.LOGGER.debug("Failed to get POKEMON entity type: {}", (Object)e.getMessage());
                    return;
                }
                if (pokemonEntityType != null) {
                    for (Constructor<?> c : pokemonEntityClass.getConstructors()) {
                        Class<?>[] params = c.getParameterTypes();
                        if (params.length != 3 || !params[0].isAssignableFrom(level.getClass()) || !params[1].isAssignableFrom(pokemon.getClass())) continue;
                        this.previewEntity = (class_1297)c.newInstance(level, pokemon, pokemonEntityType);
                        Minimons.LOGGER.debug("Created preview entity successfully");
                        break;
                    }
                }
                if (this.previewEntity == null) {
                    Minimons.LOGGER.debug("Failed to create preview entity - no matching constructor");
                    return;
                }
                this.previewEntity.method_5814(0.0, 0.0, 0.0);
                if (aspects != null && !aspects.isEmpty()) {
                    try {
                        Class<?> companionClass = Class.forName("com.cobblemon.mod.common.entity.pokemon.PokemonEntity$Companion");
                        Field companionInstance = this.previewEntity.getClass().getField("Companion");
                        Object companion = companionInstance.get(null);
                        Method getAspectsAccessor = companionClass.getMethod("getASPECTS", new Class[0]);
                        Object aspectsAccessor = getAspectsAccessor.invoke(companion, new Object[0]);
                        if (aspectsAccessor == null) break block31;
                        Object entityData = null;
                        block16: for (Class<?> currentClass = this.previewEntity.getClass(); currentClass != null && entityData == null; currentClass = currentClass.getSuperclass()) {
                            for (AccessibleObject accessibleObject : currentClass.getDeclaredFields()) {
                                String typeName = ((Field)accessibleObject).getType().getName();
                                if (!typeName.contains("SynchedEntityData") && !typeName.contains("class_2945")) continue;
                                ((Field)accessibleObject).setAccessible(true);
                                entityData = ((Field)accessibleObject).get(this.previewEntity);
                                continue block16;
                            }
                        }
                        if (entityData == null) break block31;
                        for (AccessibleObject accessibleObject : entityData.getClass().getMethods()) {
                            Class<?> param0Type;
                            if (((Method)accessibleObject).getParameterCount() != 2 || !(param0Type = ((Method)accessibleObject).getParameterTypes()[0]).isAssignableFrom(aspectsAccessor.getClass())) continue;
                            ((Method)accessibleObject).invoke(entityData, aspectsAccessor, aspects);
                            break;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            this.updatePreviewPose();
        }
        catch (Exception e) {
            Minimons.LOGGER.error("Failed to create preview entity: {}", (Object)e.getMessage());
        }
    }

    private void updatePreviewPose() {
        if (this.previewEntity == null) {
            return;
        }
        try {
            switch (this.selectedAnimation.getAnimationType()) {
                case POSE: {
                    if (this.previewInBattleState) {
                        this.setPreviewBattleState(false);
                        this.previewInBattleState = false;
                    }
                    this.updatePreviewPoseType(this.selectedAnimation.getPoseTypeName());
                    break;
                }
                case BATTLE: {
                    this.setPreviewBattleState(true);
                    this.previewInBattleState = true;
                    this.updatePreviewPoseType(this.selectedAnimation.getPoseTypeName());
                    break;
                }
                case NAMED: {
                    this.triggerPreviewNamedAnimation(this.selectedAnimation.getPoseTypeName());
                }
            }
        }
        catch (Exception e) {
            Minimons.LOGGER.debug("Failed to update preview pose: {}", (Object)e.getMessage());
        }
    }

    private void setPreviewBattleState(boolean battling) {
        try {
            Object delegate;
            Method getDelegateMethod = null;
            for (Method m : this.previewEntity.getClass().getMethods()) {
                if (!m.getName().equals("getDelegate") || m.getParameterCount() != 0) continue;
                getDelegateMethod = m;
                break;
            }
            if (getDelegateMethod != null && (delegate = getDelegateMethod.invoke((Object)this.previewEntity, new Object[0])) != null) {
                for (Method method : delegate.getClass().getMethods()) {
                    if (!method.getName().contains("setBattleId") && !method.getName().contains("setBattling") || method.getParameterCount() != 1) continue;
                    Class<?> paramType = method.getParameterTypes()[0];
                    if (paramType == Boolean.TYPE) {
                        method.invoke(delegate, battling);
                        return;
                    }
                    if (!paramType.getName().contains("UUID")) continue;
                    UUID uuid = battling ? UUID.randomUUID() : null;
                    method.invoke(delegate, uuid);
                    return;
                }
                for (AccessibleObject accessibleObject : delegate.getClass().getDeclaredFields()) {
                    String name = ((Field)accessibleObject).getName().toLowerCase();
                    if (!name.contains("battle") || !name.contains("id") && !name.contains("uuid")) continue;
                    ((Field)accessibleObject).setAccessible(true);
                    if (!((Field)accessibleObject).getType().getName().contains("UUID")) continue;
                    UUID uuid = battling ? UUID.randomUUID() : null;
                    ((Field)accessibleObject).set(delegate, uuid);
                    return;
                }
            }
        }
        catch (Exception e) {
            Minimons.LOGGER.debug("Could not set preview battle state: {}", (Object)e.getMessage());
        }
    }

    private void triggerPreviewNamedAnimation(String animationName) {
        try {
            Object delegate;
            Method getDelegateMethod = null;
            for (Method m : this.previewEntity.getClass().getMethods()) {
                if (!m.getName().equals("getDelegate") || m.getParameterCount() != 0) continue;
                getDelegateMethod = m;
                break;
            }
            if (getDelegateMethod != null && (delegate = getDelegateMethod.invoke((Object)this.previewEntity, new Object[0])) != null) {
                for (Method m : delegate.getClass().getMethods()) {
                    String methodName = m.getName().toLowerCase();
                    if (!methodName.contains("play") && !methodName.contains("run") && !methodName.contains("add") || !methodName.contains("animation") || m.getParameterCount() != 1 || m.getParameterTypes()[0] != String.class) continue;
                    m.invoke(delegate, animationName);
                    Minimons.LOGGER.debug("Triggered preview named animation: {}", (Object)animationName);
                    return;
                }
                for (Method m : delegate.getClass().getMethods()) {
                    Object state;
                    if (!m.getName().contains("getState") && !m.getName().contains("getPosableState") || (state = m.invoke(delegate, new Object[0])) == null) continue;
                    for (Method stateMethod : state.getClass().getMethods()) {
                        String stateMethodName = stateMethod.getName().toLowerCase();
                        if (!stateMethodName.contains("animation") || !stateMethodName.contains("add") && !stateMethodName.contains("run") && !stateMethodName.contains("play") || stateMethod.getParameterCount() != 1 || stateMethod.getParameterTypes()[0] != String.class) continue;
                        stateMethod.invoke(state, animationName);
                        return;
                    }
                }
            }
        }
        catch (Exception e) {
            Minimons.LOGGER.debug("Could not trigger preview named animation: {}", (Object)e.getMessage());
        }
    }

    private void updatePreviewPoseType(String poseTypeName) {
        block8: {
            try {
                try {
                    Method setEnablePoseTypeRecalculation = this.previewEntity.getClass().getMethod("setEnablePoseTypeRecalculation", Boolean.TYPE);
                    setEnablePoseTypeRecalculation.invoke((Object)this.previewEntity, false);
                }
                catch (Exception setEnablePoseTypeRecalculation) {
                    // empty catch block
                }
                Class<?> poseTypeClass = Class.forName("com.cobblemon.mod.common.entity.PoseType");
                Object poseType = null;
                for (Object enumConst : poseTypeClass.getEnumConstants()) {
                    if (!enumConst.toString().equalsIgnoreCase(poseTypeName)) continue;
                    poseType = enumConst;
                    break;
                }
                if (poseType == null) break block8;
                Class<?> companionClass = Class.forName("com.cobblemon.mod.common.entity.pokemon.PokemonEntity$Companion");
                Field companionInstance = this.previewEntity.getClass().getField("Companion");
                Object companion = companionInstance.get(null);
                Method getPoseTypeAccessor = companionClass.getMethod("getPOSE_TYPE", new Class[0]);
                Object poseTypeAccessor = getPoseTypeAccessor.invoke(companion, new Object[0]);
                if (poseTypeAccessor == null) break block8;
                Object entityData = null;
                block5: for (Class<?> currentClass = this.previewEntity.getClass(); currentClass != null && entityData == null; currentClass = currentClass.getSuperclass()) {
                    for (AccessibleObject accessibleObject : currentClass.getDeclaredFields()) {
                        String typeName = ((Field)accessibleObject).getType().getName();
                        if (!typeName.contains("SynchedEntityData") && !typeName.contains("class_2945")) continue;
                        ((Field)accessibleObject).setAccessible(true);
                        entityData = ((Field)accessibleObject).get(this.previewEntity);
                        continue block5;
                    }
                }
                if (entityData == null) break block8;
                for (AccessibleObject accessibleObject : entityData.getClass().getMethods()) {
                    Class<?> param0Type;
                    if (((Method)accessibleObject).getParameterCount() != 2 || !(param0Type = ((Method)accessibleObject).getParameterTypes()[0]).isAssignableFrom(poseTypeAccessor.getClass())) continue;
                    ((Method)accessibleObject).invoke(entityData, poseTypeAccessor, poseType);
                    break;
                }
            }
            catch (Exception e) {
                Minimons.LOGGER.debug("Failed to update preview pose type: {}", (Object)e.getMessage());
            }
        }
    }

    protected void method_25426() {
        MinimonDisplayBlock displayBlock;
        super.method_25426();
        this.guiHeight = Math.min(210, this.field_22790 - 40);
        this.leftPos = (this.field_22789 - 300) / 2;
        this.topPos = (this.field_22790 - this.guiHeight) / 2;
        int controlsStartX = this.leftPos + 8;
        int startY = this.topPos + 26;
        int buttonWidth = 52;
        int buttonHeight = 12;
        int padding = 1;
        int columns = 3;
        PokemonAnimation[] animations = PokemonAnimation.values();
        for (int i = 0; i < animations.length; ++i) {
            PokemonAnimation anim = animations[i];
            int col = i % columns;
            int row = i / columns;
            int x = controlsStartX + col * (buttonWidth + padding);
            int y = startY + row * (buttonHeight + padding);
            class_4185 button = class_4185.method_46430((class_2561)class_2561.method_43470((String)anim.getDisplayName()), btn -> this.selectAnimation(anim)).method_46433(x, y).method_46437(buttonWidth, buttonHeight).method_46436(class_7919.method_47407((class_2561)class_2561.method_43470((String)anim.getDescription()))).method_46431();
            this.method_37063((class_364)button);
        }
        int doneButtonY = this.topPos + this.guiHeight - 24;
        class_4185 doneButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Done"), btn -> this.method_25419()).method_46433(controlsStartX, doneButtonY).method_46437(160, 18).method_46436(class_7919.method_47407((class_2561)class_2561.method_43470((String)"Close this menu"))).method_46431();
        this.method_37063((class_364)doneButton);
        int sizeControlsY = doneButtonY - 20;
        class_4185 minusButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"-"), btn -> this.adjustScale(-0.05f)).method_46433(controlsStartX, sizeControlsY).method_46437(30, 16).method_46436(class_7919.method_47407((class_2561)class_2561.method_43470((String)"Decrease display size"))).method_46431();
        this.method_37063((class_364)minusButton);
        this.scaleLabelButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)this.getScaleDisplayText()), btn -> {}).method_46433(controlsStartX + 32, sizeControlsY).method_46437(96, 16).method_46436(class_7919.method_47407((class_2561)class_2561.method_43470((String)"Current display size (5% - 100%)"))).method_46431();
        this.method_37063((class_364)this.scaleLabelButton);
        class_4185 plusButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"+"), btn -> this.adjustScale(0.05f)).method_46433(controlsStartX + 130, sizeControlsY).method_46437(30, 16).method_46436(class_7919.method_47407((class_2561)class_2561.method_43470((String)"Increase display size"))).method_46431();
        this.method_37063((class_364)plusButton);
        int autoRotateY = sizeControlsY - 18;
        this.autoRotateButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)("Auto-Rotate: " + (this.autoRotate ? "ON" : "OFF"))), btn -> {
            this.autoRotate = !this.autoRotate;
            MinimonClientNetworking.sendAutoRotatePacket(this.blockPos, this.autoRotate, this.blockEntity.getRotation());
            btn.method_25355((class_2561)class_2561.method_43470((String)("Auto-Rotate: " + (this.autoRotate ? "ON" : "OFF"))));
        }).method_46433(controlsStartX, autoRotateY).method_46437(160, 16).method_46436(class_7919.method_47407((class_2561)class_2561.method_43470((String)"Toggle automatic rotation of the display"))).method_46431();
        this.method_37063((class_364)this.autoRotateButton);
        class_2248 block = this.blockEntity.method_11010().method_26204();
        if (block instanceof MinimonDisplayBlock && (displayBlock = (MinimonDisplayBlock)block).isDyeable()) {
            int clearColorY = autoRotateY - 18;
            class_4185 clearColorButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Clear Color"), btn -> MinimonClientNetworking.sendClearColorPacket(this.blockPos)).method_46433(controlsStartX, clearColorY).method_46437(160, 16).method_46436(class_7919.method_47407((class_2561)class_2561.method_43470((String)"Remove dye color and restore default appearance"))).method_46431();
            this.method_37063((class_364)clearColorButton);
        }
    }

    private String getScaleDisplayText() {
        int percent = Math.round(this.currentScale * 100.0f);
        return "Size: " + percent + "%";
    }

    private void adjustScale(float delta) {
        this.currentScale = Math.max(0.05f, Math.min(1.0f, this.currentScale + delta));
        MinimonClientNetworking.sendScalePacket(this.blockPos, this.currentScale);
        if (this.scaleLabelButton != null) {
            this.scaleLabelButton.method_25355((class_2561)class_2561.method_43470((String)this.getScaleDisplayText()));
        }
    }

    private void selectAnimation(PokemonAnimation animation) {
        if (animation.isNamedAnimation()) {
            long now = System.currentTimeMillis();
            if (now - this.lastNamedAnimationTime < 3000L) {
                return;
            }
            this.lastNamedAnimationTime = now;
        }
        this.selectedAnimation = animation;
        MinimonClientNetworking.sendAnimationPacket(this.blockPos, animation);
        this.updatePreviewPose();
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        this.method_25420(graphics, mouseX, mouseY, partialTick);
        graphics.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)"Animation Settings"), this.leftPos + 8, this.topPos + 8, 0xFFFFFF);
        int previewX = this.leftPos + 176 + 10;
        graphics.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)"Preview"), previewX + 55, this.topPos + 8, 0xFFFFFF);
        graphics.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)this.selectedAnimation.getDisplayName()), previewX + 55, this.topPos + this.guiHeight - 25, 0xAAAAAA);
        graphics.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)"Drag to rotate"), previewX + 55, this.topPos + this.guiHeight - 12, 0x666666);
        this.renderPreviewEntity(graphics, previewX, this.topPos + 20, 110, this.guiHeight - 50, mouseX, mouseY, partialTick);
        super.method_25394(graphics, mouseX, mouseY, partialTick);
    }

    private void renderPreviewEntity(class_332 graphics, int x, int y, int width, int height, int mouseX, int mouseY, float partialTick) {
        if (this.previewEntity == null) {
            graphics.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)"No Preview"), x + width / 2, y + height / 2, 0x888888);
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastPreviewTickTime >= 50L) {
            this.lastPreviewTickTime = currentTime;
            try {
                double savedX = this.previewEntity.method_23317();
                double savedY = this.previewEntity.method_23318();
                double savedZ = this.previewEntity.method_23321();
                try {
                    Method setEnablePoseTypeRecalculation = this.previewEntity.getClass().getMethod("setEnablePoseTypeRecalculation", Boolean.TYPE);
                    setEnablePoseTypeRecalculation.invoke((Object)this.previewEntity, false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.previewEntity.method_5773();
                ++this.previewEntity.field_6012;
                this.previewEntity.method_5814(savedX, savedY, savedZ);
            }
            catch (Exception savedX) {
                // empty catch block
            }
        }
        int centerX = x + width / 2;
        int centerY = y + height / 2 + 30;
        float entityScale = 115.0f * this.currentScale;
        if (this.autoRotate && !this.previewDragging) {
            this.previewRotation -= 0.5f;
            if (this.previewRotation <= -360.0f) {
                this.previewRotation += 360.0f;
            }
        }
        class_4587 poseStack = graphics.method_51448();
        poseStack.method_22903();
        poseStack.method_46416((float)centerX, (float)centerY, 50.0f);
        poseStack.method_22905(entityScale, -entityScale, entityScale);
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(180.0f - this.previewRotation + this.facingRotation));
        class_898 dispatcher = class_310.method_1551().method_1561();
        dispatcher.method_3948(false);
        try {
            dispatcher.method_3954(this.previewEntity, 0.0, 0.0, 0.0, 0.0f, partialTick, poseStack, (class_4597)graphics.method_51450(), 0xF000F0);
            graphics.method_51450().method_22993();
        }
        catch (Exception exception) {
            // empty catch block
        }
        dispatcher.method_3948(true);
        poseStack.method_22909();
    }

    public void method_25420(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        graphics.method_25294(this.leftPos, this.topPos, this.leftPos + 176 + 4, this.topPos + this.guiHeight, -872415232);
        graphics.method_49601(this.leftPos, this.topPos, 180, this.guiHeight, -11184811);
        int previewX = this.leftPos + 176 + 6;
        graphics.method_25294(previewX, this.topPos, previewX + 110 + 8, this.topPos + this.guiHeight, -872415232);
        graphics.method_49601(previewX, this.topPos, 118, this.guiHeight, -11184811);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        int previewX = this.leftPos + 176 + 6;
        if (mouseX >= (double)previewX && mouseX <= (double)(previewX + 110 + 8) && mouseY >= (double)this.topPos && mouseY <= (double)(this.topPos + this.guiHeight)) {
            this.previewDragging = true;
            this.lastMouseX = mouseX;
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        this.previewDragging = false;
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.previewDragging) {
            double deltaX = mouseX - this.lastMouseX;
            this.previewRotation -= (float)deltaX;
            this.lastMouseX = mouseX;
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean method_25421() {
        return false;
    }
}

