/*
 * Decompiled with CFR 0.152.
 */
package com.minimons.data;

import com.minimons.Minimons;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_9279;
import net.minecraft.class_9334;

public class MinimonData {
    private static final String NBT_KEY = "MinimonData";
    private static final String SPECIES_KEY = "Species";
    private static final String SHINY_KEY = "Shiny";
    private static final String FORM_KEY = "Form";
    private static final String ASPECTS_KEY = "Aspects";
    private static final String GENDER_KEY = "Gender";
    private static final String SCALE_KEY = "Scale";
    private static final String ANIMATION_KEY = "Animation";
    private String speciesId;
    private boolean shiny;
    private String formName = "";
    private Set<String> aspects = new HashSet<String>();
    private String gender = "genderless";
    private float scale = 0.15f;
    private String animationName = "idle";

    public static MinimonData fromPokemonEntity(Object pokemonEntity) {
        MinimonData data;
        block20: {
            data = new MinimonData();
            try {
                Method getPokemon = pokemonEntity.getClass().getMethod("getPokemon", new Class[0]);
                Object pokemon = getPokemon.invoke(pokemonEntity, new Object[0]);
                if (pokemon == null) break block20;
                Method getSpecies = pokemon.getClass().getMethod("getSpecies", new Class[0]);
                Object species = getSpecies.invoke(pokemon, new Object[0]);
                if (species != null) {
                    try {
                        Field resIdField = species.getClass().getField("resourceIdentifier");
                        Object resourceId = resIdField.get(species);
                        if (resourceId != null) {
                            data.speciesId = resourceId.toString();
                        }
                    }
                    catch (NoSuchFieldException e) {
                        try {
                            Method getResId = species.getClass().getMethod("getResourceIdentifier", new Class[0]);
                            Object resourceId = getResId.invoke(species, new Object[0]);
                            if (resourceId != null) {
                                data.speciesId = resourceId.toString();
                            }
                        }
                        catch (Exception ignored) {
                            Method getName = species.getClass().getMethod("getName", new Class[0]);
                            data.speciesId = "cobblemon:" + getName.invoke(species, new Object[0]).toString().toLowerCase();
                        }
                    }
                }
                try {
                    Method getShiny = pokemon.getClass().getMethod("getShiny", new Class[0]);
                    data.shiny = (Boolean)getShiny.invoke(pokemon, new Object[0]);
                }
                catch (Exception getShiny) {
                    // empty catch block
                }
                try {
                    Method getForm = pokemon.getClass().getMethod("getForm", new Class[0]);
                    Object form = getForm.invoke(pokemon, new Object[0]);
                    if (form != null) {
                        Method getFormName = form.getClass().getMethod("getName", new Class[0]);
                        data.formName = getFormName.invoke(form, new Object[0]).toString();
                    }
                }
                catch (Exception getForm) {
                    // empty catch block
                }
                try {
                    Method getAspects = pokemon.getClass().getMethod("getAspects", new Class[0]);
                    Object aspects = getAspects.invoke(pokemon, new Object[0]);
                    if (aspects instanceof Set) {
                        data.aspects = new HashSet<String>((Set)aspects);
                    }
                }
                catch (Exception getAspects) {
                    // empty catch block
                }
                try {
                    Method getGender = pokemon.getClass().getMethod("getGender", new Class[0]);
                    Object gender = getGender.invoke(pokemon, new Object[0]);
                    if (gender != null) {
                        data.gender = gender.toString().toLowerCase();
                    }
                }
                catch (Exception exception) {}
            }
            catch (Exception e) {
                Minimons.LOGGER.error("Failed to extract Pokemon data: {}", (Object)e.getMessage());
            }
        }
        return data;
    }

    public static String getPokemonDisplayName(Object pokemonEntity) {
        block6: {
            try {
                Method getPokemon = pokemonEntity.getClass().getMethod("getPokemon", new Class[0]);
                Object pokemon = getPokemon.invoke(pokemonEntity, new Object[0]);
                if (pokemon == null) break block6;
                try {
                    Method getDisplayName = pokemon.getClass().getMethod("getDisplayName", Boolean.TYPE);
                    Object name = getDisplayName.invoke(pokemon, false);
                    if (name != null) {
                        Method getString = name.getClass().getMethod("getString", new Class[0]);
                        return getString.invoke(name, new Object[0]).toString();
                    }
                }
                catch (NoSuchMethodException e) {
                    Method getSpecies = pokemon.getClass().getMethod("getSpecies", new Class[0]);
                    Object species = getSpecies.invoke(pokemon, new Object[0]);
                    if (species != null) {
                        Method getName = species.getClass().getMethod("getName", new Class[0]);
                        return getName.invoke(species, new Object[0]).toString();
                    }
                }
            }
            catch (Exception e) {
                Minimons.LOGGER.debug("Failed to get Pokemon display name: {}", (Object)e.getMessage());
            }
        }
        return "Pokemon";
    }

    public void saveToStack(class_1799 stack) {
        class_2487 tag = new class_2487();
        this.saveToTag(tag);
        stack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)tag));
    }

    public static MinimonData fromStack(class_1799 stack) {
        class_9279 customData = (class_9279)stack.method_57824(class_9334.field_49628);
        if (customData == null) {
            return null;
        }
        class_2487 tag = customData.method_57461();
        if (!tag.method_10545(SPECIES_KEY)) {
            return null;
        }
        return MinimonData.fromTag(tag);
    }

    public void saveToTag(class_2487 tag) {
        tag.method_10582(SPECIES_KEY, this.speciesId != null ? this.speciesId : "");
        tag.method_10556(SHINY_KEY, this.shiny);
        tag.method_10582(FORM_KEY, this.formName != null ? this.formName : "");
        tag.method_10582(GENDER_KEY, this.gender != null ? this.gender : "genderless");
        tag.method_10548(SCALE_KEY, this.scale);
        tag.method_10582(ANIMATION_KEY, this.animationName != null ? this.animationName : "idle");
        if (this.aspects != null && !this.aspects.isEmpty()) {
            tag.method_10582(ASPECTS_KEY, String.join((CharSequence)",", this.aspects));
        }
    }

    public static MinimonData fromTag(class_2487 tag) {
        String aspectsStr;
        MinimonData data = new MinimonData();
        data.speciesId = tag.method_10558(SPECIES_KEY);
        data.shiny = tag.method_10577(SHINY_KEY);
        data.formName = tag.method_10558(FORM_KEY);
        data.gender = tag.method_10558(GENDER_KEY);
        data.scale = tag.method_10545(SCALE_KEY) ? tag.method_10583(SCALE_KEY) : 0.25f;
        String string = data.animationName = tag.method_10545(ANIMATION_KEY) ? tag.method_10558(ANIMATION_KEY) : "idle";
        if (tag.method_10545(ASPECTS_KEY) && !(aspectsStr = tag.method_10558(ASPECTS_KEY)).isEmpty()) {
            for (String aspect : aspectsStr.split(",")) {
                data.aspects.add(aspect.trim());
            }
        }
        return data;
    }

    public boolean isValid() {
        return this.speciesId != null && !this.speciesId.isEmpty();
    }

    public String getSpeciesId() {
        return this.speciesId;
    }

    public void setSpeciesId(String speciesId) {
        this.speciesId = speciesId;
    }

    public boolean isShiny() {
        return this.shiny;
    }

    public void setShiny(boolean shiny) {
        this.shiny = shiny;
    }

    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    public Set<String> getAspects() {
        return this.aspects;
    }

    public void setAspects(Set<String> aspects) {
        this.aspects = aspects;
    }

    public String getGender() {
        return this.gender;
    }

    public void setGender(String gender) {
        this.gender = gender;
    }

    public float getScale() {
        return this.scale;
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    public String getAnimationName() {
        return this.animationName;
    }

    public void setAnimationName(String animationName) {
        this.animationName = animationName;
    }

    public MinimonData copy() {
        MinimonData copy = new MinimonData();
        copy.speciesId = this.speciesId;
        copy.shiny = this.shiny;
        copy.formName = this.formName;
        copy.aspects = new HashSet<String>(this.aspects);
        copy.gender = this.gender;
        copy.scale = this.scale;
        copy.animationName = this.animationName;
        return copy;
    }
}

