/*
 * Decompiled with CFR 0.152.
 */
package com.minimons.item;

import com.minimons.Minimons;
import com.minimons.block.MinimonDisplayBlock;
import com.minimons.block.entity.MinimonDisplayBlockEntity;
import com.minimons.data.MinimonData;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_9279;
import net.minecraft.class_9334;

public class MinimonItem
extends class_1792 {
    private final class_2248 displayBlock;

    public MinimonItem(class_1792.class_1793 properties, class_2248 displayBlock) {
        super(properties);
        this.displayBlock = displayBlock;
    }

    public class_1269 method_7847(class_1799 stack, class_1657 player, class_1309 entity, class_1268 hand) {
        String entityClassName = entity.getClass().getName();
        if (entityClassName.contains("PokemonEntity")) {
            if (!player.method_37908().method_8608()) {
                MinimonData existingData = MinimonData.fromStack(stack);
                if (existingData != null && existingData.isValid()) {
                    player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7cThis Minimon already contains a Pokemon! Place it first."), true);
                    return class_1269.field_5814;
                }
                if (!this.isOwnedByPlayer(entity, player)) {
                    player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7cYou can only create Minimons of your own Pokemon!"), true);
                    return class_1269.field_5814;
                }
                MinimonData data = this.extractPokemonData(entity);
                Minimons.LOGGER.debug("Extracted data: {}", data != null ? "speciesId=" + data.getSpeciesId() : "null");
                if (data != null && data.isValid()) {
                    class_1799 newStack = stack.method_7972();
                    data.saveToStack(newStack);
                    player.method_6122(hand, newStack);
                    String pokemonName = this.formatSpeciesName(data.getSpeciesId());
                    String message = data.isShiny() ? "\u00a76Captured " + pokemonName + "'s Minimon!" : "\u00a7aCaptured " + pokemonName + "'s Minimon!";
                    player.method_7353((class_2561)class_2561.method_43470((String)message), true);
                    Minimons.LOGGER.debug("Player {} captured {} (shiny: {}, form: {})", new Object[]{player.method_5477().getString(), data.getSpeciesId(), data.isShiny(), data.getFormName()});
                    return class_1269.field_5812;
                }
                Minimons.LOGGER.warn("Failed to extract Pokemon data or data is invalid");
                player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7cFailed to capture Pokemon data!"), true);
            }
            return class_1269.method_29236((boolean)player.method_37908().method_8608());
        }
        return class_1269.field_5811;
    }

    public class_1269 method_7884(class_1838 context) {
        class_1937 level = context.method_8045();
        class_2338 clickedPos = context.method_8037();
        class_2338 placePos = clickedPos.method_10093(context.method_8038());
        if (!level.method_8608()) {
            class_1799 stack = context.method_8041();
            MinimonData data = MinimonData.fromStack(stack);
            if (data != null && data.isValid()) {
                class_2680 existingState = level.method_8320(placePos);
                if (existingState.method_26215() || existingState.method_45474()) {
                    class_2487 tag;
                    class_2680 stateToPlace = this.displayBlock.method_9564();
                    if (context.method_8036() != null && stateToPlace.method_28498((class_2769)MinimonDisplayBlock.FACING)) {
                        stateToPlace = (class_2680)stateToPlace.method_11657((class_2769)MinimonDisplayBlock.FACING, (Comparable)context.method_8036().method_5735().method_10153());
                    }
                    class_9279 customData = (class_9279)stack.method_57824(class_9334.field_49628);
                    int savedColorValue = 0;
                    if (customData != null && (tag = customData.method_57461()).method_10545("DisplayColor")) {
                        savedColorValue = tag.method_10550("DisplayColor");
                        if (stateToPlace.method_28498((class_2769)MinimonDisplayBlock.COLOR)) {
                            stateToPlace = (class_2680)stateToPlace.method_11657((class_2769)MinimonDisplayBlock.COLOR, (Comparable)Integer.valueOf(savedColorValue));
                        }
                    }
                    level.method_8652(placePos, stateToPlace, 3);
                    class_2586 class_25862 = level.method_8321(placePos);
                    if (class_25862 instanceof MinimonDisplayBlockEntity) {
                        MinimonDisplayBlockEntity blockEntity = (MinimonDisplayBlockEntity)class_25862;
                        blockEntity.setMinimonData(data);
                        if (context.method_8036() != null) {
                            blockEntity.setOwnerUUID(context.method_8036().method_5667());
                        }
                        if (savedColorValue > 0 && savedColorValue <= 16) {
                            class_1767 dyeColor = class_1767.method_7791((int)(savedColorValue - 1));
                            blockEntity.setDisplayColor(dyeColor);
                        }
                    }
                    if (context.method_8036() != null && !context.method_8036().method_31549().field_7477) {
                        stack.method_7934(1);
                    }
                    return class_1269.field_5812;
                }
            } else if (context.method_8036() != null) {
                context.method_8036().method_7353((class_2561)class_2561.method_43470((String)"\u00a77Right-click on a Pokemon to capture it first!"), true);
            }
        }
        return class_1269.method_29236((boolean)level.method_8608());
    }

    private boolean isOwnedByPlayer(class_1309 entity, class_1657 player) {
        try {
            Method getPokemon = entity.getClass().getMethod("getPokemon", new Class[0]);
            Object pokemon = getPokemon.invoke((Object)entity, new Object[0]);
            if (pokemon == null) {
                return false;
            }
            UUID ownerUUID = null;
            try {
                Method getOwnerUUID = pokemon.getClass().getMethod("getOwnerUUID", new Class[0]);
                Object uuid = getOwnerUUID.invoke(pokemon, new Object[0]);
                if (uuid instanceof UUID) {
                    ownerUUID = (UUID)uuid;
                }
            }
            catch (NoSuchMethodException e) {
                try {
                    Method getOwnerId = pokemon.getClass().getMethod("getOwnerId", new Class[0]);
                    Object uuid = getOwnerId.invoke(pokemon, new Object[0]);
                    if (uuid instanceof UUID) {
                        ownerUUID = (UUID)uuid;
                    }
                }
                catch (NoSuchMethodException e2) {
                    try {
                        Method getStoreCoordinates = pokemon.getClass().getMethod("getStoreCoordinates", new Class[0]);
                        Object storeCoords = getStoreCoordinates.invoke(pokemon, new Object[0]);
                        if (storeCoords != null) {
                            Minimons.LOGGER.debug("Pokemon has storeCoordinates: {}", storeCoords);
                        }
                    }
                    catch (NoSuchMethodException e3) {
                        Minimons.LOGGER.debug("Could not find owner method on Pokemon class");
                    }
                }
            }
            if (ownerUUID == null) {
                Minimons.LOGGER.debug("Pokemon has no owner (wild Pokemon)");
                return false;
            }
            boolean isOwner = ownerUUID.equals(player.method_5667());
            Minimons.LOGGER.debug("Pokemon owner check: ownerUUID={}, playerUUID={}, isOwner={}", new Object[]{ownerUUID, player.method_5667(), isOwner});
            return isOwner;
        }
        catch (Exception e) {
            Minimons.LOGGER.debug("Error checking Pokemon ownership: {}", (Object)e.getMessage());
            return false;
        }
    }

    private MinimonData extractPokemonData(class_1309 entity) {
        try {
            Method getShiny;
            Object shiny;
            Method getResourceIdentifier;
            Object resourceId;
            Method getPokemon = entity.getClass().getMethod("getPokemon", new Class[0]);
            Object pokemon = getPokemon.invoke((Object)entity, new Object[0]);
            if (pokemon == null) {
                return null;
            }
            MinimonData data = new MinimonData();
            Method getSpecies = pokemon.getClass().getMethod("getSpecies", new Class[0]);
            Object species = getSpecies.invoke(pokemon, new Object[0]);
            if (species != null && (resourceId = (getResourceIdentifier = species.getClass().getMethod("getResourceIdentifier", new Class[0])).invoke(species, new Object[0])) != null) {
                data.setSpeciesId(resourceId.toString());
            }
            if ((shiny = (getShiny = pokemon.getClass().getMethod("getShiny", new Class[0])).invoke(pokemon, new Object[0])) instanceof Boolean) {
                data.setShiny((Boolean)shiny);
            }
            try {
                Method getName;
                Object formName;
                Method getForm = pokemon.getClass().getMethod("getForm", new Class[0]);
                Object form = getForm.invoke(pokemon, new Object[0]);
                if (form != null && (formName = (getName = form.getClass().getMethod("getName", new Class[0])).invoke(form, new Object[0])) != null) {
                    data.setFormName(formName.toString());
                    Minimons.LOGGER.debug("Captured form: {}", formName);
                }
            }
            catch (Exception e) {
                Minimons.LOGGER.debug("Could not get form: {}", (Object)e.getMessage());
            }
            try {
                Method getAspects = pokemon.getClass().getMethod("getAspects", new Class[0]);
                Object aspects = getAspects.invoke(pokemon, new Object[0]);
                if (aspects instanceof Set) {
                    Set aspectSet = (Set)aspects;
                    data.setAspects(new HashSet<String>(aspectSet));
                    if (!aspectSet.isEmpty()) {
                        Minimons.LOGGER.debug("Captured aspects: {}", (Object)aspectSet);
                    }
                }
            }
            catch (Exception getAspects) {
                // empty catch block
            }
            try {
                Method getGender = pokemon.getClass().getMethod("getGender", new Class[0]);
                Object gender = getGender.invoke(pokemon, new Object[0]);
                if (gender != null) {
                    data.setGender(gender.toString().toLowerCase());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return data;
        }
        catch (Exception e) {
            Minimons.LOGGER.error("Failed to extract Pokemon data: {}", (Object)e.getMessage());
            return null;
        }
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 flag) {
        MinimonData data = MinimonData.fromStack(stack);
        if (data != null && data.isValid()) {
            tooltip.add((class_2561)class_2561.method_43470((String)("\u00a77Species: \u00a7f" + this.formatSpeciesName(data.getSpeciesId()))));
            if (data.isShiny()) {
                tooltip.add((class_2561)class_2561.method_43470((String)"\u00a76\u2726 Shiny!"));
            }
            if (data.getFormName() != null && !data.getFormName().isEmpty() && !data.getFormName().equals("normal")) {
                tooltip.add((class_2561)class_2561.method_43470((String)("\u00a77Form: \u00a7f" + this.formatFormName(data.getFormName()))));
            }
            tooltip.add((class_2561)class_2561.method_43470((String)""));
            tooltip.add((class_2561)class_2561.method_43470((String)"\u00a7aRight-click block to place"));
        } else {
            tooltip.add((class_2561)class_2561.method_43470((String)"\u00a77Right-click on a Pokemon"));
            tooltip.add((class_2561)class_2561.method_43470((String)"\u00a77to capture its appearance!"));
        }
        super.method_7851(stack, context, tooltip, flag);
    }

    public class_2561 method_7864(class_1799 stack) {
        MinimonData data = MinimonData.fromStack(stack);
        if (data != null && data.isValid()) {
            String name = this.formatSpeciesName(data.getSpeciesId());
            if (data.isShiny()) {
                return class_2561.method_43470((String)("\u00a76Shiny " + name + " Minimon"));
            }
            return class_2561.method_43470((String)(name + " Minimon"));
        }
        return super.method_7864(stack);
    }

    private String formatSpeciesName(String speciesId) {
        if (speciesId == null) {
            return "Unknown";
        }
        String name = speciesId.contains(":") ? speciesId.split(":")[1] : speciesId;
        return name.substring(0, 1).toUpperCase() + name.substring(1).toLowerCase();
    }

    private String formatFormName(String formName) {
        if (formName == null) {
            return "";
        }
        return formName.substring(0, 1).toUpperCase() + formName.substring(1).toLowerCase().replace("_", " ");
    }
}

