/*
 * Decompiled with CFR 0.152.
 */
package com.minimons.network;

import com.minimons.Minimons;
import com.minimons.block.MinimonDisplayBlock;
import com.minimons.block.entity.MinimonDisplayBlockEntity;
import com.minimons.block.entity.PokemonAnimation;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9139;

public class MinimonNetworking {
    public static final class_2960 SET_ANIMATION_ID = class_2960.method_60655((String)"minimons", (String)"set_animation");
    public static final class_2960 SET_AUTO_ROTATE_ID = class_2960.method_60655((String)"minimons", (String)"set_auto_rotate");
    public static final class_2960 SET_SCALE_ID = class_2960.method_60655((String)"minimons", (String)"set_scale");
    public static final class_2960 CLEAR_COLOR_ID = class_2960.method_60655((String)"minimons", (String)"clear_color");

    public static void registerPayloads() {
        PayloadTypeRegistry.playC2S().register(SetAnimationPayload.TYPE, SetAnimationPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(SetAutoRotatePayload.TYPE, SetAutoRotatePayload.CODEC);
        PayloadTypeRegistry.playC2S().register(SetScalePayload.TYPE, SetScalePayload.CODEC);
        PayloadTypeRegistry.playC2S().register(ClearColorPayload.TYPE, ClearColorPayload.CODEC);
    }

    public static void registerServerReceivers() {
        ServerPlayNetworking.registerGlobalReceiver(SetAnimationPayload.TYPE, (payload, context) -> {
            class_3222 player = context.player();
            class_2338 pos = payload.pos();
            String animationName = payload.animationName();
            context.server().execute(() -> {
                if (player.method_5649((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5) > 64.0) {
                    return;
                }
                class_2586 be = player.method_37908().method_8321(pos);
                if (be instanceof MinimonDisplayBlockEntity) {
                    MinimonDisplayBlockEntity displayBlock = (MinimonDisplayBlockEntity)be;
                    PokemonAnimation animation = PokemonAnimation.fromName(animationName);
                    displayBlock.setAnimation(animation);
                    Minimons.LOGGER.debug("Set animation to {} for display at {}", (Object)animationName, (Object)pos);
                }
            });
        });
        ServerPlayNetworking.registerGlobalReceiver(SetAutoRotatePayload.TYPE, (payload, context) -> {
            class_3222 player = context.player();
            class_2338 pos = payload.pos();
            boolean autoRotate = payload.autoRotate();
            float rotation = payload.rotation();
            context.server().execute(() -> {
                if (player.method_5649((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5) > 64.0) {
                    return;
                }
                class_2586 be = player.method_37908().method_8321(pos);
                if (be instanceof MinimonDisplayBlockEntity) {
                    MinimonDisplayBlockEntity displayBlock = (MinimonDisplayBlockEntity)be;
                    if (!autoRotate) {
                        displayBlock.setRotation(rotation);
                    }
                    displayBlock.setAutoRotate(autoRotate);
                    Minimons.LOGGER.debug("Set auto-rotate to {} (rotation: {}) for display at {}", new Object[]{autoRotate, Float.valueOf(rotation), pos});
                }
            });
        });
        ServerPlayNetworking.registerGlobalReceiver(SetScalePayload.TYPE, (payload, context) -> {
            class_3222 player = context.player();
            class_2338 pos = payload.pos();
            float scale = payload.scale();
            context.server().execute(() -> {
                if (player.method_5649((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5) > 64.0) {
                    return;
                }
                class_2586 be = player.method_37908().method_8321(pos);
                if (be instanceof MinimonDisplayBlockEntity) {
                    MinimonDisplayBlockEntity displayBlock = (MinimonDisplayBlockEntity)be;
                    float clampedScale = Math.max(0.05f, Math.min(1.0f, scale));
                    displayBlock.setScale(clampedScale);
                    Minimons.LOGGER.debug("Set scale to {} for display at {}", (Object)Float.valueOf(clampedScale), (Object)pos);
                }
            });
        });
        ServerPlayNetworking.registerGlobalReceiver(ClearColorPayload.TYPE, (payload, context) -> {
            class_3222 player = context.player();
            class_2338 pos = payload.pos();
            context.server().execute(() -> {
                if (player.method_5649((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5) > 64.0) {
                    return;
                }
                class_2586 be = player.method_37908().method_8321(pos);
                if (be instanceof MinimonDisplayBlockEntity) {
                    MinimonDisplayBlockEntity displayBlock = (MinimonDisplayBlockEntity)be;
                    displayBlock.setDisplayColor(null);
                    class_2680 state = player.method_37908().method_8320(pos);
                    if (state.method_28498((class_2769)MinimonDisplayBlock.COLOR)) {
                        player.method_37908().method_8652(pos, (class_2680)state.method_11657((class_2769)MinimonDisplayBlock.COLOR, (Comparable)Integer.valueOf(0)), 3);
                    }
                    Minimons.LOGGER.debug("Cleared color for display at {}", (Object)pos);
                }
            });
        });
    }

    public record SetAnimationPayload(class_2338 pos, String animationName) implements class_8710
    {
        public static final class_8710.class_9154<SetAnimationPayload> TYPE = new class_8710.class_9154(SET_ANIMATION_ID);
        public static final class_9139<class_2540, SetAnimationPayload> CODEC = class_9139.method_56437((buf, payload) -> {
            buf.method_10807(payload.pos);
            buf.method_10814(payload.animationName);
        }, buf -> new SetAnimationPayload(buf.method_10811(), buf.method_19772()));

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return TYPE;
        }
    }

    public record SetAutoRotatePayload(class_2338 pos, boolean autoRotate, float rotation) implements class_8710
    {
        public static final class_8710.class_9154<SetAutoRotatePayload> TYPE = new class_8710.class_9154(SET_AUTO_ROTATE_ID);
        public static final class_9139<class_2540, SetAutoRotatePayload> CODEC = class_9139.method_56437((buf, payload) -> {
            buf.method_10807(payload.pos);
            buf.method_52964(payload.autoRotate);
            buf.method_52941(payload.rotation);
        }, buf -> new SetAutoRotatePayload(buf.method_10811(), buf.readBoolean(), buf.readFloat()));

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return TYPE;
        }
    }

    public record SetScalePayload(class_2338 pos, float scale) implements class_8710
    {
        public static final class_8710.class_9154<SetScalePayload> TYPE = new class_8710.class_9154(SET_SCALE_ID);
        public static final class_9139<class_2540, SetScalePayload> CODEC = class_9139.method_56437((buf, payload) -> {
            buf.method_10807(payload.pos);
            buf.method_52941(payload.scale);
        }, buf -> new SetScalePayload(buf.method_10811(), buf.readFloat()));

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return TYPE;
        }
    }

    public record ClearColorPayload(class_2338 pos) implements class_8710
    {
        public static final class_8710.class_9154<ClearColorPayload> TYPE = new class_8710.class_9154(CLEAR_COLOR_ID);
        public static final class_9139<class_2540, ClearColorPayload> CODEC = class_9139.method_56437((buf, payload) -> buf.method_10807(payload.pos), buf -> new ClearColorPayload(buf.method_10811()));

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return TYPE;
        }
    }
}

