/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests;

import fr.skytasul.quests.DefaultQuestFeatures;
import fr.skytasul.quests.QuestsAPIImplementation;
import fr.skytasul.quests.QuestsAPIProvider;
import fr.skytasul.quests.QuestsConfigurationImplementation;
import fr.skytasul.quests.QuestsListener;
import fr.skytasul.quests.api.QuestsHandler;
import fr.skytasul.quests.api.QuestsPlugin;
import fr.skytasul.quests.api.editors.EditorManager;
import fr.skytasul.quests.api.events.internal.BeautyQuestsLoadedEvent;
import fr.skytasul.quests.api.gui.GuiManager;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.localization.Locale;
import fr.skytasul.quests.api.questers.data.QuesterDataManager;
import fr.skytasul.quests.api.utils.IntegrationManager;
import fr.skytasul.quests.api.utils.logger.LoggerExpanded;
import fr.skytasul.quests.commands.CommandsManagerImplementation;
import fr.skytasul.quests.editor.EditorManagerImplementation;
import fr.skytasul.quests.gui.GuiManagerImplementation;
import fr.skytasul.quests.npcs.BqNpcManagerImplementation;
import fr.skytasul.quests.players.PlayerManagerImplementation;
import fr.skytasul.quests.players.accounts.PlayerManagerAccountsHookImplementation;
import fr.skytasul.quests.questers.QuesterManagerImplementation;
import fr.skytasul.quests.questers.data.sql.SqlDataManager;
import fr.skytasul.quests.questers.data.yaml.YamlDataManager;
import fr.skytasul.quests.scoreboards.ScoreboardManager;
import fr.skytasul.quests.structure.QuestsManagerImplementation;
import fr.skytasul.quests.structure.pools.QuestPoolsManagerImplementation;
import fr.skytasul.quests.utils.Database;
import fr.skytasul.quests.utils.bstats.bukkit.Metrics;
import fr.skytasul.quests.utils.bstats.charts.DrilldownPie;
import fr.skytasul.quests.utils.bstats.charts.SimplePie;
import fr.skytasul.quests.utils.bstats.charts.SingleLineChart;
import fr.skytasul.quests.utils.compatibility.InternalIntegrations;
import fr.skytasul.quests.utils.compatibility.Paper;
import fr.skytasul.quests.utils.configupdater.ConfigUpdater;
import fr.skytasul.quests.utils.logger.BqLoggerHandler;
import fr.skytasul.quests.utils.nms.NMS;
import fr.skytasul.quests.utils.updatechecker.UpdateCheckSource;
import fr.skytasul.quests.utils.updatechecker.UpdateChecker;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.kyori.adventure.platform.bukkit.BukkitAudiences;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BeautyQuests
extends JavaPlugin
implements QuestsPlugin {
    private static BeautyQuests instance;
    private BukkitRunnable saveTask;
    @Nullable
    private Paper paperCompat;
    private QuestsAPIImplementation api;
    private String lastVersion;
    private boolean dontUpdateLastVersion = false;
    private QuestsConfigurationImplementation config;
    private String loadedLanguage;
    private Database db;
    private YamlConfiguration data;
    private File dataFile;
    private File saveFolder;
    private boolean doneBackup = false;
    private final boolean unitTesting;
    @NotNull
    private final BqNpcManagerImplementation npcManager = new BqNpcManagerImplementation();
    @Nullable
    private ScoreboardManager scoreboards;
    @Nullable
    private QuestsManagerImplementation quests;
    @Nullable
    private QuestPoolsManagerImplementation pools;
    @Nullable
    private QuesterManagerImplementation questerManager;
    @Nullable
    private PlayerManagerImplementation players;
    private boolean disable = false;
    private boolean loadingFailure = false;
    protected boolean loaded = false;
    @NotNull
    private IntegrationManager integrations = new IntegrationManager();
    @Nullable
    private CommandsManagerImplementation command;
    @Nullable
    private LoggerExpanded logger;
    @Nullable
    private BqLoggerHandler loggerHandler;
    @Nullable
    private GuiManagerImplementation guiManager;
    @Nullable
    private EditorManagerImplementation editorManager;
    @Nullable
    private BukkitAudiences audiences;
    private SimpleDateFormat format = new SimpleDateFormat("yyyy'-'MM'-'dd'-'hh'-'mm'-'ss");

    public BeautyQuests() {
        this(false);
    }

    public BeautyQuests(Boolean unitTesting) {
        this.unitTesting = unitTesting;
    }

    public void onLoad() {
        instance = this;
        this.checkPaper();
        this.initLibraries();
        this.initLogger();
        try {
            this.initApi();
        }
        catch (Exception ex) {
            this.logger.severe("An unexpected exception occurred while initializing the API.", ex);
            this.logger.severe("This is a fatal error. Now disabling.");
            this.disable = true;
            this.setEnabled(false);
        }
    }

    public void onEnable() {
        if (this.disable) {
            return;
        }
        try {
            this.logger.info("------------ BeautyQuests ------------");
            if (this.isRunningPaper()) {
                this.logger.debug("Paper detected.");
            } else {
                this.logger.warning("You are not running the Paper software.\nIt is highly recommended to use it for extended features and more stability.");
            }
            this.audiences = BukkitAudiences.create((Plugin)this);
            this.saveDefaultConfig();
            NMS.getNMS();
            this.saveFolder = new File(this.getDataFolder(), "quests");
            if (!this.saveFolder.exists()) {
                this.saveFolder.mkdirs();
            }
            this.loadDataFile();
            this.checkLastVersion();
            this.loadConfigParameters(true);
            this.registerCommands();
            try {
                this.loadDefaultIntegrations();
                this.integrations.testCompatibilities();
                Bukkit.getPluginManager().registerEvents((Listener)this.integrations, (Plugin)this);
                this.integrations.initializeCompatibilities();
            }
            catch (Exception ex) {
                this.logger.severe("An error occurred while initializing compatibilities. Consider restarting.", ex);
            }
            Bukkit.getScheduler().runTask((Plugin)this, () -> {
                long timeToWait = this.npcManager.getTimeToWaitForNPCs();
                if (timeToWait > 0L) {
                    Bukkit.getScheduler().runTaskLater((Plugin)this, this::finishLoad, timeToWait);
                } else {
                    this.finishLoad();
                }
            });
            if (!this.unitTesting) {
                String pluginVersion = this.getDescription().getVersion();
                this.launchMetrics(pluginVersion);
                try {
                    this.launchUpdateChecker(pluginVersion);
                }
                catch (Exception e) {
                    this.logger.severe("An error occurred while checking updates.", e);
                }
            }
        }
        catch (LoadingException ex) {
            if (ex.getCause() != null) {
                this.logger.severe("A fatal error occurred while loading plugin.", ex.getCause());
            }
            this.logger.severe(ex.loggerMessage);
            this.logger.severe("This is a fatal error. Now disabling.");
            this.disable = true;
            this.setEnabled(false);
        }
        catch (Exception ex) {
            this.logger.severe("An unexpected exception occurred while loading plugin.", ex);
            this.logger.severe("This is a fatal error. Now disabling.");
            this.disable = true;
            this.setEnabled(false);
        }
    }

    public void onDisable() {
        try {
            try {
                if (this.command != null) {
                    this.command.unload();
                }
            }
            catch (Throwable ex) {
                this.logger.severe("An error occurred while disabling command manager.", ex);
            }
            try {
                this.editorManager.leaveAll();
                this.guiManager.closeAll();
                this.stopSaveCycle();
            }
            catch (Throwable ex) {
                this.logger.severe("An error occurred while disabling editing systems.", ex);
            }
            try {
                if (!this.disable) {
                    this.saveAllConfig(true);
                }
            }
            catch (Exception e) {
                this.logger.severe("An error occurred while saving config.", e);
            }
            try {
                this.integrations.disableCompatibilities();
            }
            catch (Exception e) {
                this.logger.severe("An error occurred while disabling plugin integrations.", e);
            }
            try {
                QuestsAPIProvider.removeAPI();
            }
            catch (Exception ex) {
                this.logger.severe("Failed to disable the API", ex);
            }
            this.getServer().getScheduler().cancelTasks((Plugin)this);
        }
        finally {
            if (this.loggerHandler != null) {
                this.loggerHandler.close();
            }
        }
    }

    private void checkPaper() {
        try {
            if (Class.forName("com.destroystokyo.paper.ParticleBuilder") != null) {
                this.paperCompat = (Paper)Class.forName("fr.skytasul.quests.utils.compatibility.PaperImplementation").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (Exception ex) {
            this.paperCompat = null;
        }
    }

    private void initLibraries() {
    }

    private void initLogger() {
        this.loggerHandler = null;
        if (!this.isUnitTesting()) {
            try {
                Files.createDirectories(this.getDataFolder().toPath(), new FileAttribute[0]);
                this.loggerHandler = new BqLoggerHandler(this);
                this.getLogger().addHandler(this.loggerHandler);
                this.getLogger().setLevel(LoggerExpanded.DEBUG_LEVEL);
            }
            catch (Throwable ex) {
                this.getLogger().log(Level.SEVERE, "Failed to insert logging handler.", ex);
            }
        }
        this.logger = new LoggerExpanded(this.getLogger());
    }

    private void initApi() throws ReflectiveOperationException {
        this.api = new QuestsAPIImplementation(this);
        QuestsAPIProvider.initializeAPI(this.api);
    }

    private void registerCommands() {
        this.command = new CommandsManagerImplementation(this);
        this.command.initializeCommands();
    }

    private void launchSaveCycle() {
        if (this.config.saveCycle > 0 && this.saveTask == null) {
            int cycle = this.config.saveCycle * 60 * 20;
            this.saveTask = new BukkitRunnable(){

                public void run() {
                    try {
                        BeautyQuests.this.saveAllConfig(false);
                        if (BeautyQuests.this.config.saveCycleMessage) {
                            BeautyQuests.this.logger.info("Datas saved ~ periodic save");
                        }
                    }
                    catch (Exception e) {
                        BeautyQuests.this.logger.severe("Error when saving!", e);
                    }
                }
            };
            this.logger.info("Periodic saves task started (" + cycle + " ticks). Task ID: " + this.saveTask.runTaskTimerAsynchronously((Plugin)this, (long)cycle, (long)cycle).getTaskId());
        }
    }

    private void stopSaveCycle() {
        if (this.config.saveCycle > 0 && this.saveTask != null) {
            this.saveTask.cancel();
            this.saveTask = null;
            this.logger.info("Periodic saves task stopped.");
        }
    }

    private void launchMetrics(String pluginVersion) {
        Metrics metrics = new Metrics(this, 7460);
        metrics.addCustomChart(new DrilldownPie("customPluginVersion", () -> {
            HashMap map = new HashMap();
            String version = pluginVersion;
            HashMap<String, Integer> entry = new HashMap<String, Integer>();
            String[] split = version.split("\\+");
            if (split.length == 1) {
                entry.put("Release", 1);
            } else {
                entry.put(version, 1);
            }
            map.put(split[0], entry);
            return map;
        }));
        metrics.addCustomChart(new SimplePie("lang", () -> this.loadedLanguage));
        metrics.addCustomChart(new SimplePie("storage", () -> this.db == null ? "YAML (files)" : "SQL (database)"));
        metrics.addCustomChart(new SingleLineChart("quests", () -> this.quests.getQuestsAmount()));
        metrics.addCustomChart(new SimplePie("quests_amount_slice", () -> {
            int size = this.quests.getQuestsAmount();
            if (size > 200) {
                return "> 200";
            }
            if (size > 100) {
                return "100 - 200";
            }
            if (size > 50) {
                return "50 - 100";
            }
            if (size > 10) {
                return "10 - 50";
            }
            if (size > 5) {
                return "5 - 10";
            }
            return "0 - 5";
        }));
        metrics.addCustomChart(new DrilldownPie("hooks_v2", () -> this.integrations.getDependencies().stream().filter(dep -> dep.isEnabled()).map(dep -> dep.getFoundPlugin()).distinct().collect(Collectors.toMap(Plugin::getName, plugin -> {
            HashMap<String, Integer> entry = new HashMap<String, Integer>();
            entry.put(plugin.getDescription().getVersion(), 1);
            return entry;
        }))));
        metrics.addCustomChart(new SimplePie("scoreboards", () -> this.scoreboards == null ? "Disabled" : "Enabled"));
        this.logger.debug("Started bStats metrics");
    }

    /*
     * Enabled aggressive block sorting
     */
    private void launchUpdateChecker(String pluginVersion) {
        UpdateChecker checker;
        this.logger.debug("Starting Spigot updater");
        if (pluginVersion.contains("_")) {
            Matcher matcher = Pattern.compile("\\+build\\.(\\d+)").matcher(pluginVersion);
            if (!matcher.find()) {
                this.logger.warning("Unknown plugin version, cannot check for updates.");
                return;
            }
            String build = matcher.group(1);
            checker = new UpdateChecker(this, UpdateCheckSource.GITHUB_RELEASE_TAG, "SkytAsul/BeautyQuests").setUserAgent("").setDownloadLink("https://ci.codemc.io/job/SkytAsul/job/BeautyQuests").setUsedVersion("build/" + build).setNameFreeVersion("(dev builds)");
        } else {
            checker = new UpdateChecker(this, UpdateCheckSource.SPIGOT, "39255").setDownloadLink(39255);
        }
        checker.setDonationLink("https://ko-fi.com/skytasul").setSupportLink("https://discord.gg/H8fXrkD").setNotifyOpsOnJoin(false).setColoredConsoleOutput(true).checkNow();
    }

    private void loadConfigParameters(boolean init) throws LoadingException {
        try {
            QuesterDataManager questerDataManager;
            File configFile = new File(this.getDataFolder(), "config.yml");
            this.config = new QuestsConfigurationImplementation(this.getConfig());
            if (this.config.update()) {
                this.config.getConfig().save(configFile);
                this.logger.info("Updated config.");
            }
            if (init) {
                this.loadLang();
            }
            ConfigUpdater.update((Plugin)this, "config.yml", configFile, new String[0]);
            this.config.init();
            if (this.config.getDatabaseConfig().enabled()) {
                this.db = null;
                try {
                    this.db = new Database(this.config.getDatabaseConfig());
                    this.db.testConnection();
                    this.logger.info("Connection to database etablished.");
                }
                catch (Exception ex) {
                    this.db = null;
                    throw new LoadingException("Connection to database has failed.", ex);
                }
            }
            if (this.db == null) {
                YamlDataManager dataManager = new YamlDataManager(this.getDataFolder().toPath().resolve("questers"));
                Path oldDataPath = this.getDataFolder().toPath().resolve("players");
                if (Files.exists(oldDataPath, new LinkOption[0]) && dataManager.migrate(oldDataPath, (FileConfiguration)this.data)) {
                    this.data.save(this.dataFile);
                }
                questerDataManager = dataManager;
            } else {
                questerDataManager = new SqlDataManager(this.db);
            }
            this.questerManager = new QuesterManagerImplementation(this, questerDataManager);
            if (this.config.hookAccounts()) {
                QuestsPlugin.getPlugin().getLoggerExpanded().info("AccountsHook is now managing quester datas!");
                this.players = new PlayerManagerAccountsHookImplementation(this);
            } else {
                this.players = new PlayerManagerImplementation(this);
            }
            this.questerManager.registerQuesterProvider(this.players);
            if (init) {
                this.getAPI().setup();
                this.logger.debug("Initializing default stage types.");
                DefaultQuestFeatures.registerStages();
                this.logger.debug("Initializing default quest options.");
                DefaultQuestFeatures.registerQuestOptions();
                this.logger.debug("Initializing default item comparisons.");
                DefaultQuestFeatures.registerItemComparisons();
                this.logger.debug("Initializing default rewards.");
                DefaultQuestFeatures.registerRewards();
                this.logger.debug("Initializing default requirements.");
                DefaultQuestFeatures.registerRequirements();
                this.logger.debug("Initializing default stage options.");
                DefaultQuestFeatures.registerStageOptions();
                this.logger.debug("Initializing default miscellenaeous.");
                DefaultQuestFeatures.registerMisc();
                DefaultQuestFeatures.registerMessageProcessors();
                this.guiManager = new GuiManagerImplementation();
                this.getServer().getPluginManager().registerEvents((Listener)this.guiManager, (Plugin)this);
                this.editorManager = new EditorManagerImplementation();
                this.getServer().getPluginManager().registerEvents((Listener)this.editorManager, (Plugin)this);
            }
        }
        catch (LoadingException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new LoadingException("Error while loading configuration and initializing values", ex);
        }
    }

    private void loadDefaultIntegrations() {
        try {
            Class<?> loaderClass = Class.forName("fr.skytasul.quests.integrations.IntegrationsLoader");
            loaderClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException ex) {
            this.logger.warning("Could not find integrations loader class.");
        }
        catch (ReflectiveOperationException ex) {
            this.logger.severe("Cannot load default integrations.", ex);
        }
        InternalIntegrations.AccountsHook.isEnabled();
    }

    private void loadLang() throws LoadingException {
        try {
            this.loadedLanguage = this.config.getConfig().getString("lang", "en_US");
            Locale.loadLang(this, Lang.values(), this.loadedLanguage);
            Pattern oldPlaceholders = Pattern.compile("\\{\\d\\}");
            for (Lang l : Lang.values()) {
                if (!oldPlaceholders.matcher(l.getValue()).find()) continue;
                this.logger.warning("Found old placeholder format in /plugins/BeautyQuests/locales/" + this.loadedLanguage + ".yml.");
                this.logger.warning("This means you probably have not deleted the locales folder after upgrading from a pre-1.0 version. Expect some bugs with message formatting.");
            }
        }
        catch (Exception ex) {
            throw new LoadingException("Couldn't load language file.", ex);
        }
    }

    private void loadDataFile() throws LoadingException {
        this.dataFile = new File(this.getDataFolder(), "data.yml");
        if (!this.dataFile.exists()) {
            try {
                this.dataFile.createNewFile();
                this.getLogger().info("data.yml created.");
            }
            catch (IOException e) {
                throw new LoadingException("Couldn't create data file.", e);
            }
        }
        this.logger.debug("Loading data file, last time edited : " + new Date(this.dataFile.lastModified()).toString());
        this.data = YamlConfiguration.loadConfiguration((File)this.dataFile);
        this.data.options().header("Do not edit ANYTHING here.");
        this.data.options().copyHeader(true);
    }

    private void checkLastVersion() throws LoadingException {
        if (this.data.contains("version")) {
            this.lastVersion = this.data.getString("version");
            if (!this.lastVersion.equals(this.getDescription().getVersion())) {
                this.logger.info("You are using a new version for the first time. (last version: " + this.lastVersion + ")");
                Matcher matcher = Pattern.compile("^(\\d+)\\.(\\d+)\\.(\\d+)").matcher(this.lastVersion);
                if (matcher.find()) {
                    int major = Integer.parseInt(matcher.group(1));
                    int minor = Integer.parseInt(matcher.group(2));
                    if (major == 0 && minor < 20) {
                        this.dontUpdateLastVersion = true;
                        throw new LoadingException("Data migration between %s and %s cannot happen. Please start from a fresh BeautyQuests install.".formatted(this.lastVersion, this.getDescription().getVersion()));
                    }
                } else {
                    this.logger.warning("Cannot parse last version to ensure data migration is possible.");
                }
                try {
                    this.performBackup();
                    this.doneBackup = true;
                }
                catch (IOException ex) {
                    this.logger.warning("Failed to create a backup", ex);
                }
            }
        } else {
            this.lastVersion = this.getDescription().getVersion();
        }
    }

    private void finishLoad() {
        try {
            String pluginVersion;
            long lastMillis = System.currentTimeMillis();
            this.loadAllDatas();
            this.getLogger().info(this.quests.getQuestsAmount() + " quests loaded (" + ((double)System.currentTimeMillis() - (double)lastMillis) / 1000.0 + "s)!");
            this.getServer().getPluginManager().registerEvents((Listener)new QuestsListener(), (Plugin)this);
            if (!this.unitTesting) {
                this.launchSaveCycle();
            }
            if (!this.lastVersion.equals(pluginVersion = this.getDescription().getVersion())) {
                this.logger.debug("Migrating from " + this.lastVersion + " to " + pluginVersion);
                int updated = this.quests.updateAll();
                if (updated > 0) {
                    this.logger.info("Updated " + updated + " quests during migration.");
                }
                this.pools.updateAll();
                this.saveAllConfig(false);
            }
        }
        catch (Throwable e) {
            this.logger.severe("An error occurred while loading plugin datas.", e);
        }
    }

    private void loadAllDatas() throws Throwable {
        block10: {
            if (this.disable) {
                return;
            }
            this.integrations.lockDependencies();
            if (this.scoreboards == null && this.config.getQuestsConfig().scoreboards()) {
                File scFile = new File(this.getDataFolder(), "scoreboard.yml");
                if (!scFile.exists()) {
                    this.saveResource("scoreboard.yml", false);
                }
                ConfigUpdater.update((Plugin)this, "scoreboard.yml", scFile, new String[0]);
                this.scoreboards = new ScoreboardManager(this, scFile);
                this.getAPI().registerQuestsHandler(this.scoreboards);
            }
            this.pools = new QuestPoolsManagerImplementation(this, new File(this.getDataFolder(), "questPools.yml"));
            this.quests = new QuestsManagerImplementation(this, this.data.getInt("lastID"), this.saveFolder);
            try {
                this.questerManager.load();
            }
            catch (Exception ex) {
                this.logger.severe("Error while loading player datas.", ex);
                if (this.doneBackup) break block10;
                try {
                    this.performBackup();
                    this.doneBackup = true;
                }
                catch (IOException exBackup) {
                    this.logger.warning("Failed to create a backup.", exBackup);
                }
            }
        }
        Iterator<QuestsHandler> iterator = this.getAPI().getQuestsHandlers().iterator();
        while (iterator.hasNext()) {
            QuestsHandler handler = iterator.next();
            try {
                handler.load();
            }
            catch (Exception ex) {
                this.logger.severe("Cannot load quest handler " + handler.getClass().getName(), ex);
                iterator.remove();
            }
        }
        Bukkit.getScheduler().runTaskLater((Plugin)BeautyQuests.getInstance(), () -> {
            this.players.loadOnlinePlayers();
            this.loaded = true;
            Bukkit.getPluginManager().callEvent((Event)new BeautyQuestsLoadedEvent());
        }, 1L);
    }

    public void saveAllConfig(boolean unload) throws Exception {
        if (unload) {
            if (this.quests != null) {
                this.quests.unloadQuests();
            }
            this.getAPI().getQuestsHandlers().forEach(handler -> {
                try {
                    handler.unload();
                }
                catch (Exception ex) {
                    this.logger.severe("Cannot unload quest handler " + handler.getClass().getName(), ex);
                }
            });
        }
        if (this.loaded) {
            long time = System.currentTimeMillis();
            this.data.set("lastID", (Object)this.quests.getLastID());
            if (!this.dontUpdateLastVersion) {
                this.data.set("version", (Object)this.getDescription().getVersion());
            }
            try {
                this.questerManager.saveAll();
            }
            catch (Exception ex) {
                this.logger.severe("Error when saving player datas.", ex);
            }
            this.data.save(this.dataFile);
            this.logger.debug("Saved datas (" + ((double)System.currentTimeMillis() - (double)time) / 1000.0 + "s)!");
        }
        if (unload) {
            this.npcManager.unload();
            this.resetDatas();
        }
    }

    private void resetDatas() {
        this.quests = null;
        this.pools = null;
        try {
            if (this.db != null) {
                this.db.close();
            }
        }
        catch (Exception ex) {
            this.logger.severe("An error occurred while closing database connection.", ex);
        }
        this.players = null;
        this.loaded = false;
    }

    public boolean createQuestBackup(Path file, String msg) {
        if (!this.config.backups) {
            return false;
        }
        this.logger.info("Creating single quest backup...");
        try {
            Path target = Paths.get(file.toString() + "-backup" + this.format.format(new Date()) + ".yml", new String[0]);
            if (Files.exists(target, new LinkOption[0])) {
                this.logger.warning("File " + target.toString() + " already exist. This should not happen.");
            } else {
                this.logger.info("Quest backup created at " + String.valueOf(Files.copy(file, target, new CopyOption[0]).getFileName()));
            }
            return true;
        }
        catch (Exception e) {
            this.logger.severe("An error occured while creating the backup.", e);
            return false;
        }
    }

    public void performBackup() throws IOException {
        Path dataDir = this.getDataFolder().toPath();
        Path backupDir = dataDir.resolve("backup-" + this.format.format(new Date()));
        Files.createDirectory(backupDir, new FileAttribute[0]);
        List<Path> files = Files.list(dataDir).filter(path -> !path.getFileName().toString().startsWith("backup-")).filter(path -> !path.getFileName().toString().equals("locales")).filter(path -> !path.getFileName().toString().endsWith(".log")).toList();
        for (Path file : files) {
            Files.walk(file, new FileVisitOption[0]).forEach(source -> {
                Path destination = backupDir.resolve(dataDir.relativize((Path)source));
                try {
                    Files.copy(source, destination, new CopyOption[0]);
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(ex);
                }
            });
        }
        this.logger.info("Performed backup at {0}.", backupDir);
    }

    public void performReload(CommandSender sender) {
        sender.sendMessage("\u00a7cReloading is currently disabled because it caused too many bugs. Please restart your server instead.");
    }

    @Override
    public void notifyLoadingFailure() {
        this.loadingFailure = true;
    }

    public void resetLoadingFailure() {
        this.loadingFailure = false;
    }

    public boolean hasLoadingFailed() {
        return this.loadingFailure;
    }

    @NotNull
    private <T> T ensureLoaded(@Nullable T object) {
        if (object == null) {
            throw new IllegalStateException("BeautyQuests is not yet initialized");
        }
        return object;
    }

    @Override
    @NotNull
    public LoggerExpanded getLoggerExpanded() {
        return this.ensureLoaded(this.logger);
    }

    @Nullable
    public BqLoggerHandler getLoggerHandler() {
        return this.loggerHandler;
    }

    @NotNull
    public String getPrefix() {
        return this.config.getPrefix();
    }

    @Override
    @NotNull
    public CommandsManagerImplementation getCommand() {
        return this.ensureLoaded(this.command);
    }

    @Override
    @NotNull
    public QuestsConfigurationImplementation getConfiguration() {
        return this.config;
    }

    @NotNull
    public FileConfiguration getDataFile() {
        return this.data;
    }

    @Nullable
    public Database getBQDatabase() {
        return this.db;
    }

    @Nullable
    public ScoreboardManager getScoreboardManager() {
        return this.scoreboards;
    }

    @NotNull
    public QuestsManagerImplementation getQuestsManager() {
        return this.ensureLoaded(this.quests);
    }

    @NotNull
    public QuestPoolsManagerImplementation getPoolsManager() {
        return this.ensureLoaded(this.pools);
    }

    @Override
    @NotNull
    public GuiManager getGuiManager() {
        return this.ensureLoaded(this.guiManager);
    }

    @Override
    @NotNull
    public EditorManager getEditorManager() {
        return this.ensureLoaded(this.editorManager);
    }

    @Override
    @NotNull
    public BqNpcManagerImplementation getNpcManager() {
        return this.npcManager;
    }

    @Override
    @NotNull
    public IntegrationManager getIntegrationManager() {
        return this.integrations;
    }

    @Override
    @NotNull
    public QuestsAPIImplementation getAPI() {
        return this.api;
    }

    @Override
    @NotNull
    public PlayerManagerImplementation getPlayersManager() {
        return this.ensureLoaded(this.players);
    }

    @NotNull
    public QuesterManagerImplementation getQuesterManager() {
        return this.ensureLoaded(this.questerManager);
    }

    @Override
    @NotNull
    public BukkitAudiences getAudiences() {
        return this.ensureLoaded(this.audiences);
    }

    @Override
    public boolean isRunningPaper() {
        return this.paperCompat != null;
    }

    public Optional<Paper> getPaperCompatibility() {
        return Optional.ofNullable(this.paperCompat);
    }

    public boolean isCompletelyLoaded() {
        return this.loaded;
    }

    public boolean isUnitTesting() {
        return this.unitTesting;
    }

    @NotNull
    public static BeautyQuests getInstance() {
        return instance;
    }

    public static class LoadingException
    extends Exception {
        private static final long serialVersionUID = -2811265488885752109L;
        private String loggerMessage;

        public LoadingException(String loggerMessage) {
            this.loggerMessage = loggerMessage;
        }

        public LoadingException(String loggerMessage, Throwable cause) {
            super(cause);
            this.loggerMessage = loggerMessage;
        }

        public String getLoggerMessage() {
            return this.loggerMessage;
        }
    }
}

