/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests;

import io.papermc.paper.plugin.loader.PluginClasspathBuilder;
import io.papermc.paper.plugin.loader.PluginLoader;
import io.papermc.paper.plugin.loader.library.ClassPathLibrary;
import io.papermc.paper.plugin.loader.library.impl.MavenLibraryResolver;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.jar.JarFile;
import org.bukkit.configuration.file.YamlConfiguration;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.repository.RemoteRepository;

public class BeautyQuestsLoader
implements PluginLoader {
    private static final String MAVEN_CENTRAL = "https://repo1.maven.org/maven2/";

    public void classloader(PluginClasspathBuilder classpathBuilder) {
        String repository;
        List librariesList;
        try (JarFile pluginJar = new JarFile(classpathBuilder.getContext().getPluginSource().toFile());
             InputStreamReader pluginYamlReader = new InputStreamReader(pluginJar.getInputStream(pluginJar.getEntry("plugin.yml")));){
            YamlConfiguration config = YamlConfiguration.loadConfiguration((Reader)pluginYamlReader);
            librariesList = config.getStringList("libraries");
        }
        catch (IOException ex) {
            throw new IllegalStateException("Failed to load libraries list", ex);
        }
        MavenLibraryResolver resolver = new MavenLibraryResolver();
        try {
            repository = MavenLibraryResolver.MAVEN_CENTRAL_DEFAULT_MIRROR;
            if (repository.equals("https://maven-central.storage-download.googleapis.com/maven2")) {
                classpathBuilder.getContext().getLogger().info("Paper is using the Google mirror for Maven central repository, which lacks some artifacts.\nBeautyQuests will use the default Maven central CDN until a better mirror has been found.\n");
                repository = MAVEN_CENTRAL;
            }
        }
        catch (NoSuchFieldError ex) {
            repository = MAVEN_CENTRAL;
        }
        resolver.addRepository(new RemoteRepository.Builder("central", "default", repository).build());
        classpathBuilder.getContext().getLogger().info("Loading {} libraries using Paper plugin loader...", (Object)librariesList.size());
        for (String library : librariesList) {
            Dependency dependency = new Dependency((Artifact)new DefaultArtifact(library), null);
            resolver.addDependency(dependency);
        }
        classpathBuilder.addLibrary((ClassPathLibrary)resolver);
    }
}

