/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests;

import com.cryptomorin.xseries.XMaterial;
import fr.skytasul.quests.BeautyQuests;
import fr.skytasul.quests.QuestsConfigurationImplementation;
import fr.skytasul.quests.api.QuestsAPI;
import fr.skytasul.quests.api.QuestsConfiguration;
import fr.skytasul.quests.api.QuestsPlugin;
import fr.skytasul.quests.api.comparison.ItemComparison;
import fr.skytasul.quests.api.gui.ItemUtils;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.objects.QuestObjectLocation;
import fr.skytasul.quests.api.options.QuestOptionCreator;
import fr.skytasul.quests.api.quests.quester.QuestQuesterStrategy;
import fr.skytasul.quests.api.quests.quester.QuestQuesterStrategyCreator;
import fr.skytasul.quests.api.requirements.AbstractRequirement;
import fr.skytasul.quests.api.requirements.RequirementCreator;
import fr.skytasul.quests.api.requirements.RequirementList;
import fr.skytasul.quests.api.rewards.AbstractReward;
import fr.skytasul.quests.api.rewards.RewardCreator;
import fr.skytasul.quests.api.rewards.RewardList;
import fr.skytasul.quests.api.stages.AbstractStage;
import fr.skytasul.quests.api.stages.StageType;
import fr.skytasul.quests.api.stages.StageTypeRegistry;
import fr.skytasul.quests.api.stages.options.StageOptionAutoRegister;
import fr.skytasul.quests.api.stages.options.StageOptionCreator;
import fr.skytasul.quests.api.utils.QuestVisibilityLocation;
import fr.skytasul.quests.api.utils.messaging.MessageProcessor;
import fr.skytasul.quests.api.utils.messaging.MessageType;
import fr.skytasul.quests.api.utils.messaging.PlaceholderRegistry;
import fr.skytasul.quests.api.utils.messaging.PlaceholdersContext;
import fr.skytasul.quests.api.utils.progress.HasProgress;
import fr.skytasul.quests.mobs.BukkitEntityFactory;
import fr.skytasul.quests.options.OptionAutoQuest;
import fr.skytasul.quests.options.OptionBypassLimit;
import fr.skytasul.quests.options.OptionCancelRewards;
import fr.skytasul.quests.options.OptionCancellable;
import fr.skytasul.quests.options.OptionConfirmMessage;
import fr.skytasul.quests.options.OptionCustomOrder;
import fr.skytasul.quests.options.OptionDescription;
import fr.skytasul.quests.options.OptionEndMessage;
import fr.skytasul.quests.options.OptionEndRewards;
import fr.skytasul.quests.options.OptionEndSound;
import fr.skytasul.quests.options.OptionFailOnDeath;
import fr.skytasul.quests.options.OptionFirework;
import fr.skytasul.quests.options.OptionHideNoRequirements;
import fr.skytasul.quests.options.OptionHologramLaunch;
import fr.skytasul.quests.options.OptionHologramLaunchNo;
import fr.skytasul.quests.options.OptionHologramText;
import fr.skytasul.quests.options.OptionName;
import fr.skytasul.quests.options.OptionQuestItem;
import fr.skytasul.quests.options.OptionQuestPool;
import fr.skytasul.quests.options.OptionQuesterStrategy;
import fr.skytasul.quests.options.OptionRepeatable;
import fr.skytasul.quests.options.OptionRequirements;
import fr.skytasul.quests.options.OptionScoreboardEnabled;
import fr.skytasul.quests.options.OptionStartDialog;
import fr.skytasul.quests.options.OptionStartMessage;
import fr.skytasul.quests.options.OptionStartRewards;
import fr.skytasul.quests.options.OptionStartable;
import fr.skytasul.quests.options.OptionStarterNPC;
import fr.skytasul.quests.options.OptionTimer;
import fr.skytasul.quests.options.OptionVisibility;
import fr.skytasul.quests.quests.questers.PlayerQuesterStrategy;
import fr.skytasul.quests.requirements.EquipmentRequirement;
import fr.skytasul.quests.requirements.LevelRequirement;
import fr.skytasul.quests.requirements.PermissionsRequirement;
import fr.skytasul.quests.requirements.QuestRequirement;
import fr.skytasul.quests.requirements.ScoreboardRequirement;
import fr.skytasul.quests.requirements.logical.LogicalOrRequirement;
import fr.skytasul.quests.rewards.CheckpointReward;
import fr.skytasul.quests.rewards.CommandReward;
import fr.skytasul.quests.rewards.ItemReward;
import fr.skytasul.quests.rewards.MessageReward;
import fr.skytasul.quests.rewards.QuestStopReward;
import fr.skytasul.quests.rewards.RandomReward;
import fr.skytasul.quests.rewards.RemoveItemsReward;
import fr.skytasul.quests.rewards.RequirementDependentReward;
import fr.skytasul.quests.rewards.TeleportationReward;
import fr.skytasul.quests.rewards.TitleReward;
import fr.skytasul.quests.rewards.WaitReward;
import fr.skytasul.quests.rewards.XPReward;
import fr.skytasul.quests.stages.StageBreed;
import fr.skytasul.quests.stages.StageBringBack;
import fr.skytasul.quests.stages.StageBucket;
import fr.skytasul.quests.stages.StageChat;
import fr.skytasul.quests.stages.StageCraft;
import fr.skytasul.quests.stages.StageDealDamage;
import fr.skytasul.quests.stages.StageDeath;
import fr.skytasul.quests.stages.StageEatDrink;
import fr.skytasul.quests.stages.StageEnchant;
import fr.skytasul.quests.stages.StageFish;
import fr.skytasul.quests.stages.StageInteractBlock;
import fr.skytasul.quests.stages.StageInteractLocation;
import fr.skytasul.quests.stages.StageLocation;
import fr.skytasul.quests.stages.StageMelt;
import fr.skytasul.quests.stages.StageMine;
import fr.skytasul.quests.stages.StageMobs;
import fr.skytasul.quests.stages.StageNPC;
import fr.skytasul.quests.stages.StagePlaceBlocks;
import fr.skytasul.quests.stages.StagePlayTime;
import fr.skytasul.quests.stages.StageTame;
import fr.skytasul.quests.stages.options.StageOptionProgressBar;
import fr.skytasul.quests.utils.QuestUtils;
import java.lang.invoke.CallSite;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import net.kyori.adventure.identity.Identity;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.Repairable;
import org.jetbrains.annotations.NotNull;

public final class DefaultQuestFeatures {
    private static boolean npcFeaturesRegistered = false;

    private DefaultQuestFeatures() {
    }

    public static void registerStages() {
        StageTypeRegistry stages = QuestsAPI.getAPI().getStages();
        stages.register(new StageType<StageMobs>("MOBS", StageMobs.class, Lang.Mobs.name(), StageMobs::deserialize, ItemUtils.item(XMaterial.WOODEN_SWORD, Lang.stageMobs.toString(), new String[0]), StageMobs.Creator::new));
        stages.register(new StageType<StageMine>("MINE", StageMine.class, Lang.Mine.name(), StageMine::deserialize, ItemUtils.item(XMaterial.WOODEN_PICKAXE, Lang.stageMine.toString(), new String[0]), StageMine.Creator::new));
        stages.register(new StageType<StagePlaceBlocks>("PLACE_BLOCKS", StagePlaceBlocks.class, Lang.Place.name(), StagePlaceBlocks::deserialize, ItemUtils.item(XMaterial.OAK_STAIRS, Lang.stagePlace.toString(), new String[0]), StagePlaceBlocks.Creator::new));
        stages.register(new StageType<StageChat>("CHAT", StageChat.class, Lang.Chat.name(), StageChat::deserialize, ItemUtils.item(XMaterial.PLAYER_HEAD, Lang.stageChat.toString(), new String[0]), StageChat.Creator::new));
        stages.register(new StageType<StageInteractBlock>("INTERACT_BLOCK", StageInteractBlock.class, Lang.InteractBlock.name(), StageInteractBlock::deserialize, ItemUtils.item(XMaterial.STICK, Lang.stageInteractBlock.toString(), new String[0]), StageInteractBlock.Creator::new));
        stages.register(new StageType<StageInteractLocation>("INTERACT_LOCATION", StageInteractLocation.class, Lang.InteractLocation.name(), StageInteractLocation::deserialize, ItemUtils.item(XMaterial.BEACON, Lang.stageInteractLocation.toString(), new String[0]), StageInteractLocation.Creator::new));
        stages.register(new StageType<StageFish>("FISH", StageFish.class, Lang.Fish.name(), StageFish::deserialize, ItemUtils.item(XMaterial.COD, Lang.stageFish.toString(), new String[0]), StageFish.Creator::new));
        stages.register(new StageType<StageMelt>("MELT", StageMelt.class, Lang.Melt.name(), StageMelt::deserialize, ItemUtils.item(XMaterial.FURNACE, Lang.stageMelt.toString(), new String[0]), StageMelt.Creator::new));
        stages.register(new StageType<StageEnchant>("ENCHANT", StageEnchant.class, Lang.Enchant.name(), StageEnchant::deserialize, ItemUtils.item(XMaterial.ENCHANTING_TABLE, Lang.stageEnchant.toString(), new String[0]), StageEnchant.Creator::new));
        stages.register(new StageType<StageCraft>("CRAFT", StageCraft.class, Lang.Craft.name(), StageCraft::deserialize, ItemUtils.item(XMaterial.CRAFTING_TABLE, Lang.stageCraft.toString(), new String[0]), StageCraft.Creator::new));
        stages.register(new StageType<StageBucket>("BUCKET", StageBucket.class, Lang.Bucket.name(), StageBucket::deserialize, ItemUtils.item(XMaterial.BUCKET, Lang.stageBucket.toString(), new String[0]), StageBucket.Creator::new));
        stages.register(new StageType<StageLocation>("LOCATION", StageLocation.class, Lang.StageLocation.name(), StageLocation::deserialize, ItemUtils.item(XMaterial.MINECART, Lang.stageLocation.toString(), new String[0]), StageLocation.Creator::new));
        stages.register(new StageType<StagePlayTime>("PLAY_TIME", StagePlayTime.class, Lang.PlayTime.name(), StagePlayTime::deserialize, ItemUtils.item(XMaterial.CLOCK, Lang.stagePlayTime.toString(), new String[0]), StagePlayTime.Creator::new));
        stages.register(new StageType<StageBreed>("BREED", StageBreed.class, Lang.Breed.name(), StageBreed::deserialize, ItemUtils.item(XMaterial.WHEAT, Lang.stageBreedAnimals.toString(), new String[0]), StageBreed.Creator::new));
        stages.register(new StageType<StageTame>("TAME", StageTame.class, Lang.Tame.name(), StageTame::deserialize, ItemUtils.item(XMaterial.CARROT, Lang.stageTameAnimals.toString(), new String[0]), StageTame.Creator::new));
        stages.register(new StageType<StageDeath>("DEATH", StageDeath.class, Lang.Death.name(), StageDeath::deserialize, ItemUtils.item(XMaterial.SKELETON_SKULL, Lang.stageDeath.toString(), new String[0]), StageDeath.Creator::new));
        stages.register(new StageType<StageDealDamage>("DEAL_DAMAGE", StageDealDamage.class, Lang.DealDamage.name(), StageDealDamage::deserialize, ItemUtils.item(XMaterial.REDSTONE, Lang.stageDealDamage.toString(), new String[0]), StageDealDamage.Creator::new));
        stages.register(new StageType<StageEatDrink>("EAT_DRINK", StageEatDrink.class, Lang.EatDrink.name(), StageEatDrink::new, ItemUtils.item(XMaterial.COOKED_PORKCHOP, Lang.stageEatDrink.toString(), new String[0]), StageEatDrink.Creator::new));
    }

    public static void registerStageOptions() {
        QuestsAPI.getAPI().getStages().autoRegisterOption(new StageOptionAutoRegister(){

            @Override
            public boolean appliesTo(@NotNull StageType<?> type) {
                return HasProgress.class.isAssignableFrom(type.getStageClass());
            }

            @Override
            public <T extends AbstractStage> StageOptionCreator<T> createOptionCreator(@NotNull StageType<T> type) {
                return this.createOptionCreatorInternal(type);
            }

            private <T extends AbstractStage> StageOptionCreator<T> createOptionCreatorInternal(@NotNull StageType<T> type) {
                return StageOptionCreator.create("progressbar", StageOptionProgressBar.class, () -> new StageOptionProgressBar(type.getStageClass()));
            }
        });
    }

    public static void registerQuestOptions() {
        QuestsAPI.getAPI().registerQuestOption(new QuestOptionCreator<OptionalInt, OptionCustomOrder>("customOrder", 8, OptionCustomOrder.class, OptionCustomOrder::new, OptionalInt.empty(), new String[0]));
        QuestsAPI.getAPI().registerQuestOption(new QuestOptionCreator<Object, OptionQuestPool>("pool", 9, OptionQuestPool.class, OptionQuestPool::new, null, new String[0]));
        QuestsAPI.getAPI().registerQuestOption(new QuestOptionCreator<Object, OptionName>("name", 10, OptionName.class, OptionName::new, null, new String[0]));
        QuestsAPI.getAPI().registerQuestOption(new QuestOptionCreator<Object, OptionDescription>("description", 12, OptionDescription.class, OptionDescription::new, null, new String[0]));
        QuestsAPI.getAPI().registerQuestOption(new QuestOptionCreator<ItemStack, OptionQuestItem>("customItem", 13, OptionQuestItem.class, OptionQuestItem::new, QuestsConfiguration.getConfig().getQuestsConfig().getDefaultQuestItem(), "customMaterial"));
        QuestsAPI.getAPI().registerQuestOption(new QuestOptionCreator<Object, OptionConfirmMessage>("confirmMessage", 15, OptionConfirmMessage.class, OptionConfirmMessage::new, null, new String[0]));
        QuestsAPI.getAPI().registerQuestOption(new QuestOptionCreator<Boolean, OptionBypassLimit>("bypassLimit", 18, OptionBypassLimit.class, OptionBypassLimit::new, false, new String[0]));
        QuestsAPI.getAPI().registerQuestOption(new QuestOptionCreator<Boolean, OptionStartable>("startableFromGUI", 19, OptionStartable.class, OptionStartable::new, false, new String[0]));
        QuestsAPI.getAPI().registerQuestOption(new QuestOptionCreator<Boolean, OptionFailOnDeath>("failOnDeath", 20, OptionFailOnDeath.class, OptionFailOnDeath::new, false, new String[0]));
        QuestsAPI.getAPI().registerQuestOption(new QuestOptionCreator<Boolean, OptionCancellable>("cancellable", 21, OptionCancellable.class, OptionCancellable::new, true, new String[0]));
        QuestsAPI.getAPI().registerQuestOption(new QuestOptionCreator<RewardList, OptionCancelRewards>("cancelActions", 22, OptionCancelRewards.class, OptionCancelRewards::new, new RewardList(), new String[0]));
        QuestsAPI.getAPI().registerQuestOption(new QuestOptionCreator<Boolean, OptionScoreboardEnabled>("scoreboard", 27, OptionScoreboardEnabled.class, OptionScoreboardEnabled::new, true, new String[0]));
        QuestsAPI.getAPI().registerQuestOption(new QuestOptionCreator<Boolean, OptionHideNoRequirements>("hideNoRequirements", 28, OptionHideNoRequirements.class, OptionHideNoRequirements::new, false, new String[0]));
        QuestsAPI.getAPI().registerQuestOption(new QuestOptionCreator<Boolean, OptionAutoQuest>("auto", 29, OptionAutoQuest.class, OptionAutoQuest::new, false, new String[0]));
        QuestsAPI.getAPI().registerQuestOption(new QuestOptionCreator<Boolean, OptionRepeatable>("repeatable", 30, OptionRepeatable.class, OptionRepeatable::new, false, "multiple"));
        QuestsAPI.getAPI().registerQuestOption(new QuestOptionCreator<Integer, OptionTimer>("timer", 31, OptionTimer.class, OptionTimer::new, QuestsConfiguration.getConfig().getQuestsConfig().getDefaultTimer(), new String[0]));
        QuestsAPI.getAPI().registerQuestOption(new QuestOptionCreator<List<QuestVisibilityLocation>, OptionVisibility>("visibility", 32, OptionVisibility.class, OptionVisibility::new, Arrays.asList(QuestVisibilityLocation.values()), "hid", "hide"));
        QuestsAPI.getAPI().registerQuestOption(new QuestOptionCreator<String, OptionEndSound>("endSound", 34, OptionEndSound.class, OptionEndSound::new, QuestsConfiguration.getConfig().getQuestsConfig().finishSound(), new String[0]));
        QuestsAPI.getAPI().registerQuestOption(new QuestOptionCreator<FireworkMeta, OptionFirework>("firework", 35, OptionFirework.class, OptionFirework::new, QuestsConfigurationImplementation.getConfiguration().getDefaultFirework(), new String[0]));
        QuestsAPI.getAPI().registerQuestOption(new QuestOptionCreator<RequirementList, OptionRequirements>("requirements", 36, OptionRequirements.class, OptionRequirements::new, new RequirementList(), new String[0]));
        QuestsAPI.getAPI().registerQuestOption(new QuestOptionCreator<RewardList, OptionStartRewards>("startRewards", 38, OptionStartRewards.class, OptionStartRewards::new, new RewardList(), "startRewardsList"));
        QuestsAPI.getAPI().registerQuestOption(new QuestOptionCreator<CallSite, OptionStartMessage>("startMessage", 39, OptionStartMessage.class, OptionStartMessage::new, (CallSite)((Object)(QuestsConfigurationImplementation.getConfiguration().getPrefix() + Lang.STARTED_QUEST.toString())), new String[0]));
        QuestsAPI.getAPI().registerQuestOption(new QuestOptionCreator<RewardList, OptionEndRewards>("endRewards", 43, OptionEndRewards.class, OptionEndRewards::new, new RewardList(), "rewardsList"));
        QuestsAPI.getAPI().registerQuestOption(new QuestOptionCreator<CallSite, OptionEndMessage>("endMsg", 44, OptionEndMessage.class, OptionEndMessage::new, (CallSite)((Object)(QuestsConfigurationImplementation.getConfiguration().getPrefix() + Lang.FINISHED_BASE.toString())), new String[0]));
    }

    public static void registerRewards() {
        QuestsAPI.getAPI().getRewards().register(new RewardCreator("commandReward", (Class<? extends AbstractReward>)CommandReward.class, ItemUtils.item(XMaterial.COMMAND_BLOCK, Lang.command.toString(), new String[0]), CommandReward::new));
        QuestsAPI.getAPI().getRewards().register(new RewardCreator("itemReward", (Class<? extends AbstractReward>)ItemReward.class, ItemUtils.item(XMaterial.STONE_SWORD, Lang.rewardItems.toString(), new String[0]), ItemReward::new));
        QuestsAPI.getAPI().getRewards().register(new RewardCreator("removeItemsReward", (Class<? extends AbstractReward>)RemoveItemsReward.class, ItemUtils.item(XMaterial.CHEST, Lang.rewardRemoveItems.toString(), new String[0]), RemoveItemsReward::new));
        QuestsAPI.getAPI().getRewards().register(new RewardCreator("textReward", (Class<? extends AbstractReward>)MessageReward.class, ItemUtils.item(XMaterial.WRITABLE_BOOK, Lang.endMessage.toString(), new String[0]), MessageReward::new));
        QuestsAPI.getAPI().getRewards().register(new RewardCreator("tpReward", (Class<? extends AbstractReward>)TeleportationReward.class, ItemUtils.item(XMaterial.ENDER_PEARL, Lang.location.toString(), new String[0]), TeleportationReward::new, false, new QuestObjectLocation[0]));
        QuestsAPI.getAPI().getRewards().register(new RewardCreator("expReward", (Class<? extends AbstractReward>)XPReward.class, ItemUtils.item(XMaterial.EXPERIENCE_BOTTLE, Lang.rewardXP.toString(), new String[0]), XPReward::new));
        QuestsAPI.getAPI().getRewards().register(new RewardCreator("checkpointReward", (Class<? extends AbstractReward>)CheckpointReward.class, ItemUtils.item(XMaterial.NETHER_STAR, Lang.rewardCheckpoint.toString(), new String[0]), CheckpointReward::new, false, new QuestObjectLocation[]{QuestObjectLocation.STAGE}));
        QuestsAPI.getAPI().getRewards().register(new RewardCreator("questStopReward", (Class<? extends AbstractReward>)QuestStopReward.class, ItemUtils.item(XMaterial.BARRIER, Lang.rewardStopQuest.toString(), new String[0]), QuestStopReward::new, false, new QuestObjectLocation[]{QuestObjectLocation.STAGE}));
        QuestsAPI.getAPI().getRewards().register(new RewardCreator("requirementDependentReward", (Class<? extends AbstractReward>)RequirementDependentReward.class, ItemUtils.item(XMaterial.REDSTONE, Lang.rewardWithRequirements.toString(), new String[0]), RequirementDependentReward::new, true, new QuestObjectLocation[0]).setCanBeAsync(true));
        QuestsAPI.getAPI().getRewards().register(new RewardCreator("randomReward", (Class<? extends AbstractReward>)RandomReward.class, ItemUtils.item(XMaterial.EMERALD, Lang.rewardRandom.toString(), new String[0]), RandomReward::new, true, new QuestObjectLocation[0]).setCanBeAsync(true));
        QuestsAPI.getAPI().getRewards().register(new RewardCreator("wait", (Class<? extends AbstractReward>)WaitReward.class, ItemUtils.item(XMaterial.CLOCK, Lang.rewardWait.toString(), new String[0]), WaitReward::new, true, new QuestObjectLocation[0]).setCanBeAsync(true));
        QuestsAPI.getAPI().getRewards().register(new RewardCreator("titleReward", (Class<? extends AbstractReward>)TitleReward.class, ItemUtils.item(XMaterial.NAME_TAG, Lang.rewardTitle.toString(), new String[0]), TitleReward::new, false, new QuestObjectLocation[0]));
    }

    public static void registerRequirements() {
        QuestsAPI.getAPI().getRequirements().register(new RequirementCreator("logicalOr", (Class<? extends AbstractRequirement>)LogicalOrRequirement.class, ItemUtils.item(XMaterial.REDSTONE_TORCH, Lang.RLOR.toString(), new String[0]), LogicalOrRequirement::new));
        QuestsAPI.getAPI().getRequirements().register(new RequirementCreator("questRequired", (Class<? extends AbstractRequirement>)QuestRequirement.class, ItemUtils.item(XMaterial.ARMOR_STAND, Lang.RQuest.toString(), new String[0]), QuestRequirement::new));
        QuestsAPI.getAPI().getRequirements().register(new RequirementCreator("levelRequired", (Class<? extends AbstractRequirement>)LevelRequirement.class, ItemUtils.item(XMaterial.EXPERIENCE_BOTTLE, Lang.RLevel.toString(), new String[0]), LevelRequirement::new));
        QuestsAPI.getAPI().getRequirements().register(new RequirementCreator("permissionRequired", (Class<? extends AbstractRequirement>)PermissionsRequirement.class, ItemUtils.item(XMaterial.PAPER, Lang.RPermissions.toString(), new String[0]), PermissionsRequirement::new));
        QuestsAPI.getAPI().getRequirements().register(new RequirementCreator("scoreboardRequired", (Class<? extends AbstractRequirement>)ScoreboardRequirement.class, ItemUtils.item(XMaterial.COMMAND_BLOCK, Lang.RScoreboard.toString(), new String[0]), ScoreboardRequirement::new));
        QuestsAPI.getAPI().getRequirements().register(new RequirementCreator("equipmentRequired", (Class<? extends AbstractRequirement>)EquipmentRequirement.class, ItemUtils.item(XMaterial.CHAINMAIL_HELMET, Lang.REquipment.toString(), new String[0]), EquipmentRequirement::new));
    }

    public static void registerItemComparisons() {
        QuestsAPI.getAPI().registerItemComparison(new ItemComparison("bukkit", Lang.comparisonBukkit.toString(), Lang.comparisonBukkitLore.toString(), ItemStack::isSimilar).setEnabledByDefault());
        QuestsAPI.getAPI().registerItemComparison(new ItemComparison("customBukkit", Lang.comparisonCustomBukkit.toString(), Lang.comparisonCustomBukkitLore.toString(), QuestUtils::isSimilar));
        QuestsAPI.getAPI().registerItemComparison(new ItemComparison("material", Lang.comparisonMaterial.toString(), Lang.comparisonMaterialLore.toString(), (item1, item2) -> item2.getType().equals((Object)item1.getType())));
        QuestsAPI.getAPI().registerItemComparison(new ItemComparison("name", Lang.comparisonName.toString(), Lang.comparisonNameLore.toString(), (item1, item2) -> {
            ItemMeta meta1 = item1.getItemMeta();
            ItemMeta meta2 = item2.getItemMeta();
            return meta1.hasDisplayName() == meta2.hasDisplayName() && Objects.equals(meta1.getDisplayName(), meta2.getDisplayName());
        }).setMetaNeeded());
        QuestsAPI.getAPI().registerItemComparison(new ItemComparison("lore", Lang.comparisonLore.toString(), Lang.comparisonLoreLore.toString(), (item1, item2) -> {
            ItemMeta meta1 = item1.getItemMeta();
            ItemMeta meta2 = item2.getItemMeta();
            return meta1.hasLore() == meta2.hasLore() && Objects.equals(meta1.getLore(), meta2.getLore());
        }).setMetaNeeded());
        QuestsAPI.getAPI().registerItemComparison(new ItemComparison("enchants", Lang.comparisonEnchants.toString(), Lang.comparisonEnchantsLore.toString(), (item1, item2) -> {
            ItemMeta meta1 = item1.getItemMeta();
            ItemMeta meta2 = item2.getItemMeta();
            return meta1.hasEnchants() == meta2.hasEnchants() && Objects.equals(meta1.getEnchants(), meta2.getEnchants());
        }).setMetaNeeded());
        QuestsAPI.getAPI().registerItemComparison(new ItemComparison("repair", Lang.comparisonRepairCost.toString(), Lang.comparisonRepairCostLore.toString(), (item1, item2) -> {
            ItemMeta meta1 = item1.getItemMeta();
            if (!(meta1 instanceof Repairable)) {
                return true;
            }
            ItemMeta meta2 = item2.getItemMeta();
            if (!(meta2 instanceof Repairable)) {
                return true;
            }
            return ((Repairable)meta1).getRepairCost() == ((Repairable)meta2).getRepairCost();
        }).setMetaNeeded());
    }

    public static void registerMisc() {
        QuestsAPI.getAPI().registerMobFactory(new BukkitEntityFactory());
        QuestQuesterStrategyCreator playerStrategyCreator = new QuestQuesterStrategyCreator("player", PlayerQuesterStrategy.class, () -> new PlayerQuesterStrategy(QuestsPlugin.getPlugin().getPlayersManager()), Lang.PlayerQuesterName.toString(), Lang.PlayerQuesterDescription.toString());
        QuestsAPI.getAPI().getQuestQuesterStrategyRegistry().register(playerStrategyCreator);
        QuestsAPI.getAPI().registerQuestOption(new QuestOptionCreator<QuestQuesterStrategy, OptionQuesterStrategy>("questerStrategy", 37, OptionQuesterStrategy.class, OptionQuesterStrategy::new, (QuestQuesterStrategy)playerStrategyCreator.newObject(), new String[0]));
    }

    public static void registerMessageProcessors() {
        final PlaceholderRegistry defaultPlaceholders = new PlaceholderRegistry().registerContextual("player", PlaceholdersContext.class, context -> context.getAudience().get(Identity.NAME).orElse(null)).registerContextual("PLAYER", PlaceholdersContext.class, context -> context.getAudience().get(Identity.NAME).orElse(null)).register("prefix", () -> BeautyQuests.getInstance().getPrefix()).register("nl", "\n");
        QuestsAPI.getAPI().registerMessageProcessor("default_message_type", 1, new MessageProcessor(){

            @Override
            public String processString(String string, PlaceholdersContext context) {
                if (context.getMessageType() == MessageType.DefaultMessageType.PREFIXED) {
                    return BeautyQuests.getInstance().getPrefix() + string;
                }
                if (context.getMessageType() == MessageType.DefaultMessageType.UNPREFIXED) {
                    return "\u00a76" + string;
                }
                if (context.getMessageType() == MessageType.DefaultMessageType.OFF) {
                    return Lang.OffText.quickFormat("message", string);
                }
                return string;
            }
        });
        QuestsAPI.getAPI().registerMessageProcessor("default_placeholders", 2, new MessageProcessor(){

            @Override
            public PlaceholderRegistry processPlaceholders(PlaceholderRegistry placeholders, PlaceholdersContext context) {
                if (context.replacePluginPlaceholders()) {
                    return placeholders == null ? defaultPlaceholders : placeholders.with(defaultPlaceholders);
                }
                return placeholders;
            }
        });
        QuestsAPI.getAPI().registerMessageProcessor("legacy_colors", 10, new MessageProcessor(){

            @Override
            public String processString(String string, PlaceholdersContext context) {
                return ChatColor.translateAlternateColorCodes((char)'&', (String)string);
            }
        });
    }

    public static void registerNpcFeatures() {
        if (npcFeaturesRegistered) {
            return;
        }
        npcFeaturesRegistered = true;
        StageTypeRegistry stages = QuestsAPI.getAPI().getStages();
        stages.register(new StageType<StageNPC>("NPC", StageNPC.class, Lang.Talk.name(), StageNPC::deserialize, ItemUtils.item(XMaterial.OAK_SIGN, Lang.stageNPC.toString(), new String[0]), StageNPC.Creator::new));
        stages.register(new StageType<StageBringBack>("ITEMS", StageBringBack.class, Lang.Items.name(), StageBringBack::deserialize, ItemUtils.item(XMaterial.CHEST, Lang.stageBring.toString(), new String[0]), StageBringBack.Creator::new));
        QuestsAPI.getAPI().registerQuestOption(new QuestOptionCreator<Object, OptionStarterNPC>("starterNPC", 40, OptionStarterNPC.class, OptionStarterNPC::new, null, "starterID"));
        QuestsAPI.getAPI().registerQuestOption(new QuestOptionCreator<Object, OptionStartDialog>("startDialog", 41, OptionStartDialog.class, OptionStartDialog::new, null, new String[0]));
        QuestsAPI.getAPI().registerQuestOption(new QuestOptionCreator<String, OptionHologramText>("hologramText", 17, OptionHologramText.class, OptionHologramText::new, Lang.HologramText.toString(), new String[0]));
        QuestsAPI.getAPI().registerQuestOption(new QuestOptionCreator<ItemStack, OptionHologramLaunch>("hologramLaunch", 25, OptionHologramLaunch.class, OptionHologramLaunch::new, QuestsConfigurationImplementation.getConfiguration().getHoloLaunchItem(), new String[0]));
        QuestsAPI.getAPI().registerQuestOption(new QuestOptionCreator<ItemStack, OptionHologramLaunchNo>("hologramLaunchNo", 26, OptionHologramLaunchNo.class, OptionHologramLaunchNo::new, QuestsConfigurationImplementation.getConfiguration().getHoloLaunchNoItem(), new String[0]));
    }
}

