/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests;

import fr.skytasul.quests.BeautyQuests;
import fr.skytasul.quests.api.AbstractHolograms;
import fr.skytasul.quests.api.QuestsAPI;
import fr.skytasul.quests.api.QuestsConfiguration;
import fr.skytasul.quests.api.QuestsHandler;
import fr.skytasul.quests.api.QuestsPlugin;
import fr.skytasul.quests.api.comparison.ItemComparison;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.mobs.MobFactory;
import fr.skytasul.quests.api.mobs.MobStacker;
import fr.skytasul.quests.api.npcs.BqInternalNpcFactory;
import fr.skytasul.quests.api.npcs.dialogs.MessageSender;
import fr.skytasul.quests.api.objects.QuestObjectsRegistry;
import fr.skytasul.quests.api.options.QuestOption;
import fr.skytasul.quests.api.options.QuestOptionCreator;
import fr.skytasul.quests.api.pools.QuestPoolsManager;
import fr.skytasul.quests.api.questers.QuesterManager;
import fr.skytasul.quests.api.quests.QuestsManager;
import fr.skytasul.quests.api.quests.quester.QuestQuesterStrategy;
import fr.skytasul.quests.api.quests.quester.QuestQuesterStrategyCreator;
import fr.skytasul.quests.api.requirements.AbstractRequirement;
import fr.skytasul.quests.api.requirements.RequirementCreator;
import fr.skytasul.quests.api.rewards.AbstractReward;
import fr.skytasul.quests.api.rewards.RewardCreator;
import fr.skytasul.quests.api.serializable.SerializableRegistry;
import fr.skytasul.quests.api.stages.StageTypeRegistry;
import fr.skytasul.quests.api.utils.logger.LoggerExpanded;
import fr.skytasul.quests.api.utils.messaging.MessageProcessor;
import fr.skytasul.quests.blocks.BQBlocksManagerImplementation;
import fr.skytasul.quests.npcs.dialogs.ActionBarMessageSender;
import fr.skytasul.quests.npcs.dialogs.ChatMessageSender;
import fr.skytasul.quests.utils.QuestUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang.Validate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QuestsAPIImplementation
implements QuestsAPI {
    private static final LoggerExpanded LOGGER = LoggerExpanded.get("BeautyQuests.API");
    private final StageTypeRegistry stages = new StageTypeRegistry();
    private final List<ItemComparison> itemComparisons = new LinkedList<ItemComparison>();
    private final List<MobStacker> mobStackers = new ArrayList<MobStacker>();
    public Map<Class<? extends QuestOption<?>>, QuestOptionCreator<?, ?>> questOptions = new HashMap();
    private QuestObjectsRegistry<AbstractRequirement, RequirementCreator> requirements;
    private QuestObjectsRegistry<AbstractReward, RewardCreator> rewards;
    private SerializableRegistry<QuestQuesterStrategy, QuestQuesterStrategyCreator> questerStrategies;
    private AbstractHolograms<?> hologramsManager = null;
    private BQBlocksManagerImplementation blocksManager = new BQBlocksManagerImplementation();
    private MessageSender messageSender;
    private final Set<QuestsHandler> handlers = new HashSet<QuestsHandler>();
    private final Set<MessageProcessorInfo> processors = new TreeSet<MessageProcessorInfo>();
    private final BeautyQuests plugin;

    protected QuestsAPIImplementation(BeautyQuests plugin) {
        this.plugin = plugin;
    }

    void setup() {
        this.requirements = new QuestObjectsRegistry("requirements", Lang.INVENTORY_REQUIREMENTS.toString());
        this.rewards = new QuestObjectsRegistry("rewards", Lang.INVENTORY_REWARDS.toString());
        this.questerStrategies = new SerializableRegistry("quester-strategies");
        this.setMessageSender(QuestsConfiguration.getConfig().getDialogsConfig().sendInActionBar() ? new ActionBarMessageSender() : new ChatMessageSender());
    }

    @Override
    @NotNull
    public StageTypeRegistry getStages() {
        return this.stages;
    }

    @Override
    public void registerMobFactory(@NotNull MobFactory<?> factory) {
        MobFactory.factories.add(factory);
        QuestUtils.autoRegister(factory);
        LOGGER.debug("Mob factory registered (id: " + factory.getID() + ")");
    }

    @Override
    public void registerQuestOption(@NotNull QuestOptionCreator<?, ?> creator) {
        Validate.notNull(creator);
        Validate.isTrue((!this.questOptions.containsKey(creator.optionClass) ? 1 : 0) != 0, (String)"This quest option was already registered");
        this.questOptions.put(creator.optionClass, creator);
        LOGGER.debug("Quest option registered (id: " + creator.id + ")");
    }

    @Override
    public <D, T extends QuestOption<D>> Optional<QuestOptionCreator<D, T>> getQuestOption(Class<T> optionClass) {
        return Optional.ofNullable(this.questOptions.get(optionClass));
    }

    @Override
    @NotNull
    public Collection<QuestOptionCreator<?, ?>> getQuestOptions() {
        return this.questOptions.values();
    }

    @Override
    @NotNull
    public @NotNull List<@NotNull ItemComparison> getItemComparisons() {
        return this.itemComparisons;
    }

    @Override
    public void registerItemComparison(@NotNull ItemComparison comparison) {
        Validate.isTrue((boolean)this.itemComparisons.stream().noneMatch(x -> x.getID().equals(comparison.getID())), (String)"This item comparison was already registered");
        this.itemComparisons.add(comparison);
        LOGGER.debug("Item comparison registered (id: " + comparison.getID() + ")");
    }

    @Override
    public void unregisterItemComparison(@NotNull ItemComparison comparison) {
        Validate.isTrue((boolean)this.itemComparisons.remove(comparison), (String)"This item comparison was not registered");
        LOGGER.debug("Item comparison unregistered (id: " + comparison.getID() + ")");
    }

    @Override
    @NotNull
    public @NotNull List<@NotNull MobStacker> getMobStackers() {
        return this.mobStackers;
    }

    @Override
    public void registerMobStacker(@NotNull MobStacker stacker) {
        this.mobStackers.add(stacker);
        LOGGER.debug("Added " + stacker.toString() + " mob stacker");
    }

    @Override
    @NotNull
    public QuestObjectsRegistry<AbstractRequirement, RequirementCreator> getRequirements() {
        return this.requirements;
    }

    @Override
    @NotNull
    public QuestObjectsRegistry<AbstractReward, RewardCreator> getRewards() {
        return this.rewards;
    }

    @Override
    @NotNull
    public SerializableRegistry<QuestQuesterStrategy, QuestQuesterStrategyCreator> getQuestQuesterStrategyRegistry() {
        return this.questerStrategies;
    }

    @Override
    public void addNpcFactory(@NotNull String key, @NotNull BqInternalNpcFactory factory) {
        this.plugin.getNpcManager().addInternalFactory(key, factory);
    }

    @Override
    @Nullable
    public AbstractHolograms<?> getHologramsManager() {
        return this.hologramsManager;
    }

    @Override
    public void setHologramsManager(@NotNull AbstractHolograms<?> newHologramsManager) {
        Validate.notNull(newHologramsManager);
        if (this.hologramsManager != null) {
            LOGGER.warning(newHologramsManager.getClass().getSimpleName() + " will replace " + this.hologramsManager.getClass().getSimpleName() + " as the new holograms manager.");
        }
        this.hologramsManager = newHologramsManager;
        LOGGER.debug("Holograms manager has been registered: " + newHologramsManager.getClass().getName());
    }

    @Override
    @NotNull
    public BQBlocksManagerImplementation getBlocksManager() {
        return this.blocksManager;
    }

    @Override
    public void registerQuestsHandler(@NotNull QuestsHandler handler) {
        Validate.notNull((Object)handler);
        if (this.handlers.add(handler) && this.plugin.loaded) {
            handler.load();
        }
    }

    @Override
    public void unregisterQuestsHandler(@NotNull QuestsHandler handler) {
        if (this.handlers.remove(handler)) {
            handler.unload();
        }
    }

    @Override
    @NotNull
    public @NotNull Collection<@NotNull QuestsHandler> getQuestsHandlers() {
        return this.handlers;
    }

    @Override
    public void propagateQuestsHandlers(@NotNull @NotNull Consumer<@NotNull QuestsHandler> consumer) {
        this.handlers.forEach(handler -> {
            try {
                consumer.accept((QuestsHandler)handler);
            }
            catch (Exception ex) {
                LOGGER.severe("An error occurred while updating quests handler.", ex);
            }
        });
    }

    @Override
    @NotNull
    public Collection<MessageProcessor> getMessageProcessors() {
        return this.processors.stream().map(x -> x.processor).collect(Collectors.toList());
    }

    @Override
    public void registerMessageProcessor(@NotNull String key, int priotity, @NotNull MessageProcessor processor) {
        Optional<MessageProcessorInfo> existing = this.processors.stream().filter(x -> x.key.equals(key) && x.priority == priotity).findAny();
        if (existing.isPresent()) {
            this.processors.remove(existing.get());
            this.plugin.getLogger().warning("Replacing message processor " + key);
        }
        this.processors.add(new MessageProcessorInfo(key, priotity, processor));
    }

    @Override
    @NotNull
    public MessageSender getMessageSender() {
        return this.messageSender;
    }

    @Override
    public void setMessageSender(@NotNull MessageSender sender) {
        this.messageSender = sender;
        LOGGER.debug("Message sender has been registered: " + sender.getClass().getName());
    }

    @Override
    @NotNull
    public QuestsManager getQuestsManager() {
        return this.plugin.getQuestsManager();
    }

    @Override
    @NotNull
    public QuestPoolsManager getPoolsManager() {
        return this.plugin.getPoolsManager();
    }

    @Override
    @NotNull
    public QuesterManager getQuesterManager() {
        return this.plugin.getQuesterManager();
    }

    @Override
    @NotNull
    public QuestsPlugin getPlugin() {
        return this.plugin;
    }

    private class MessageProcessorInfo
    implements Comparable<MessageProcessorInfo> {
        private String key;
        private int priority;
        private MessageProcessor processor;

        public MessageProcessorInfo(String key, int priority, MessageProcessor processor) {
            this.key = key;
            this.priority = priority;
            this.processor = processor;
        }

        @Override
        public int compareTo(MessageProcessorInfo o) {
            return Integer.compare(this.priority, o.priority);
        }
    }
}

