/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests;

import com.cryptomorin.xseries.XMaterial;
import com.cryptomorin.xseries.XSound;
import fr.skytasul.quests.BeautyQuests;
import fr.skytasul.quests.api.QuestsConfiguration;
import fr.skytasul.quests.api.QuestsPlugin;
import fr.skytasul.quests.api.gui.ItemUtils;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.npcs.NpcClickType;
import fr.skytasul.quests.api.options.description.DescriptionSource;
import fr.skytasul.quests.api.options.description.QuestDescription;
import fr.skytasul.quests.api.utils.MinecraftNames;
import fr.skytasul.quests.api.utils.PlayerListCategory;
import fr.skytasul.quests.api.utils.Utils;
import fr.skytasul.quests.utils.ParticleEffect;
import fr.skytasul.quests.utils.compatibility.InternalIntegrations;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.FireworkEffect;
import org.bukkit.Particle;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.FireworkMeta;
import org.jetbrains.annotations.NotNull;

public class QuestsConfigurationImplementation
implements QuestsConfiguration {
    private String minecraftTranslationsFile = null;
    private boolean enablePrefix = true;
    private double hologramsHeight = 0.0;
    private boolean disableTextHologram = false;
    private boolean showCustomHologramName = true;
    private boolean hookAcounts = false;
    private boolean usePlayerBlockTracker = false;
    private ParticleEffect particleStart;
    private ParticleEffect particleTalk;
    private ParticleEffect particleNext;
    private ItemStack holoLaunchItem = null;
    private ItemStack holoLaunchNoItem = null;
    private ItemStack holoTalkItem = null;
    private FireworkMeta defaultFirework = null;
    boolean backups = true;
    boolean saveCycleMessage = true;
    int saveCycle = 15;
    private final FileConfiguration config;
    private QuestsConfig quests;
    private DatabaseConfig database;
    private GuiConfig gui;
    private DialogsConfig dialogs;
    private QuestsSelectionConfig selection;
    private QuestsMenuConfig menu;
    private StageDescriptionConfig stageDescription;
    private QuestDescriptionConfig questDescription;

    public static QuestsConfigurationImplementation getConfiguration() {
        return BeautyQuests.getInstance().getConfiguration();
    }

    QuestsConfigurationImplementation(FileConfiguration config) {
        this.config = config;
        this.quests = new QuestsConfig();
        this.database = new DatabaseConfig(config.getConfigurationSection("database"));
        this.gui = new GuiConfig(config.getConfigurationSection("gui"));
        this.dialogs = new DialogsConfig(config.getConfigurationSection("dialogs"));
        this.selection = new QuestsSelectionConfig(config.getConfigurationSection("questsSelection"));
        this.menu = new QuestsMenuConfig(config.getConfigurationSection("questsMenu"));
        this.stageDescription = new StageDescriptionConfig(config.getConfigurationSection("stage description"));
        this.questDescription = new QuestDescriptionConfig(config.getConfigurationSection("questDescription"));
    }

    boolean update() {
        boolean result = false;
        result |= this.database.update();
        result |= this.gui.update();
        result |= this.dialogs.update();
        result |= this.selection.update();
        result |= this.menu.update();
        return result |= this.stageDescription.update();
    }

    void init() {
        this.backups = this.config.getBoolean("backups", true);
        if (!this.backups) {
            QuestsPlugin.getPlugin().getLoggerExpanded().warning("Backups are disabled due to the presence of \"backups: false\" in config.yml.");
        }
        this.minecraftTranslationsFile = this.config.getString("minecraftTranslationsFile");
        if (this.isMinecraftTranslationsEnabled()) {
            this.initializeTranslations();
        }
        this.quests.init();
        this.database.init();
        this.gui.init();
        this.dialogs.init();
        this.selection.init();
        this.menu.init();
        this.stageDescription.init();
        this.questDescription.init();
        this.saveCycle = this.config.getInt("saveCycle");
        this.saveCycleMessage = this.config.getBoolean("saveCycleMessage");
        this.enablePrefix = this.config.getBoolean("enablePrefix");
        this.disableTextHologram = this.config.getBoolean("disableTextHologram");
        this.showCustomHologramName = this.config.getBoolean("showCustomHologramName");
        this.hologramsHeight = 0.28 + this.config.getDouble("hologramsHeight");
        this.hookAcounts = this.config.getBoolean("accountsHook");
        this.usePlayerBlockTracker = this.config.getBoolean("usePlayerBlockTracker");
        this.particleStart = this.loadParticles("start", new ParticleEffect(Utils.valueOfEnum(Particle.class, "REDSTONE", "DUST"), ParticleEffect.ParticleShape.POINT, Color.YELLOW));
        this.particleTalk = this.loadParticles("talk", new ParticleEffect(Utils.valueOfEnum(Particle.class, "VILLAGER_HAPPY", "HAPPY_VILLAGER"), ParticleEffect.ParticleShape.BAR, null));
        this.particleNext = this.loadParticles("next", new ParticleEffect(Utils.valueOfEnum(Particle.class, "SMOKE_NORMAL", "SMOKE"), ParticleEffect.ParticleShape.SPOT, null));
        this.holoLaunchItem = this.loadHologram("launchItem");
        this.holoLaunchNoItem = this.loadHologram("nolaunchItem");
        this.holoTalkItem = this.loadHologram("talkItem");
        if (BeautyQuests.getInstance().getDataFile().contains("firework")) {
            this.defaultFirework = (FireworkMeta)BeautyQuests.getInstance().getDataFile().getSerializable("firework", FireworkMeta.class);
        } else {
            FireworkMeta fm = (FireworkMeta)Bukkit.getItemFactory().getItemMeta(XMaterial.FIREWORK_ROCKET.parseMaterial());
            fm.addEffect(FireworkEffect.builder().with(FireworkEffect.Type.BURST).withTrail().withFlicker().withColor(new Color[]{Color.YELLOW, Color.ORANGE}).withFade(Color.SILVER).build());
            fm.setPower(0);
            this.defaultFirework = fm;
        }
    }

    private void initializeTranslations() {
        Object fileName = this.minecraftTranslationsFile;
        Optional<String> extension = Utils.getFilenameExtension(this.minecraftTranslationsFile);
        if (extension.isPresent()) {
            if (extension.get().equalsIgnoreCase("json")) {
                QuestsPlugin.getPlugin().getLoggerExpanded().warning("File " + (String)fileName + " is not a JSON file.");
                return;
            }
        } else {
            fileName = (String)fileName + ".json";
        }
        if (!MinecraftNames.intialize(QuestsPlugin.getPlugin().getDataFolder().toPath().resolve((String)fileName))) {
            QuestsPlugin.getPlugin().getLoggerExpanded().warning("Cannot enable the \"minecraftTranslationsFile\" option : problem when initializing");
            this.minecraftTranslationsFile = null;
        }
    }

    private ParticleEffect loadParticles(String name, ParticleEffect defaultParticle) {
        ParticleEffect particle = null;
        if (this.config.getBoolean(name + ".enabled")) {
            try {
                particle = ParticleEffect.deserialize(this.config.getConfigurationSection(name));
            }
            catch (Exception ex) {
                QuestsPlugin.getPlugin().getLoggerExpanded().warning("Loading of " + name + " particles failed: Invalid particle, color or shape.", ex);
            }
            if (particle == null) {
                particle = defaultParticle;
            }
            QuestsPlugin.getPlugin().getLoggerExpanded().debug("Loaded " + name + " particles: " + particle.toString());
        }
        return particle;
    }

    private ItemStack loadHologram(String name) {
        if (BeautyQuests.getInstance().getDataFile().contains(name)) {
            return ItemStack.deserialize((Map)BeautyQuests.getInstance().getDataFile().getConfigurationSection(name).getValues(false));
        }
        return null;
    }

    private static ItemStack loadItem(ConfigurationSection config, String key, ItemStack def) {
        if (config.isItemStack(key)) {
            return config.getItemStack(key);
        }
        if (config.isString(key)) {
            return XMaterial.matchXMaterial((String)config.getString(key)).map(XMaterial::parseItem).orElse(def);
        }
        QuestsPlugin.getPlugin().getLogger().warning("Cannot load item " + key + " from config");
        return def;
    }

    private String loadSound(String key) {
        String sound = this.config.getString(key);
        if (XSound.of((String)sound).isEmpty()) {
            QuestsPlugin.getPlugin().getLoggerExpanded().warning("Sound " + sound + " is not a valid Bukkit sound.");
        }
        return sound;
    }

    private static boolean migrateEntry(ConfigurationSection oldConfig, String oldKey, ConfigurationSection newConfig, String newKey) {
        if (oldConfig.contains(oldKey)) {
            newConfig.set(newKey, oldConfig.get(oldKey));
            oldConfig.set(oldKey, null);
            return true;
        }
        return false;
    }

    public FileConfiguration getConfig() {
        return this.config;
    }

    @Override
    @NotNull
    public QuestsConfiguration.Quests getQuestsConfig() {
        return this.quests;
    }

    @NotNull
    public DatabaseConfig getDatabaseConfig() {
        return this.database;
    }

    @Override
    @NotNull
    public QuestsConfiguration.Gui getGuiConfig() {
        return this.gui;
    }

    @Override
    @NotNull
    public DialogsConfig getDialogsConfig() {
        return this.dialogs;
    }

    @Override
    @NotNull
    public QuestsSelectionConfig getQuestsSelectionConfig() {
        return this.selection;
    }

    @Override
    @NotNull
    public QuestsMenuConfig getQuestsMenuConfig() {
        return this.menu;
    }

    @Override
    @NotNull
    public StageDescriptionConfig getStageDescriptionConfig() {
        return this.stageDescription;
    }

    @Override
    @NotNull
    public QuestDescriptionConfig getQuestDescriptionConfig() {
        return this.questDescription;
    }

    public String getPrefix() {
        return this.enablePrefix ? Lang.Prefix.toString() : "\u00a76";
    }

    public boolean isTextHologramDisabled() {
        return this.disableTextHologram;
    }

    public boolean showStartParticles() {
        return this.particleStart != null;
    }

    public ParticleEffect getParticleStart() {
        return this.particleStart;
    }

    public boolean showTalkParticles() {
        return this.particleTalk != null;
    }

    public ParticleEffect getParticleTalk() {
        return this.particleTalk;
    }

    public boolean showNextParticles() {
        return this.particleNext != null;
    }

    public ParticleEffect getParticleNext() {
        return this.particleNext;
    }

    public double getHologramsHeight() {
        return this.hologramsHeight;
    }

    public boolean isCustomHologramNameShown() {
        return this.showCustomHologramName;
    }

    public ItemStack getHoloLaunchItem() {
        return this.holoLaunchItem;
    }

    public ItemStack getHoloLaunchNoItem() {
        return this.holoLaunchNoItem;
    }

    public ItemStack getHoloTalkItem() {
        return this.holoTalkItem;
    }

    public FireworkMeta getDefaultFirework() {
        return this.defaultFirework;
    }

    public boolean hookAccounts() {
        return this.hookAcounts && InternalIntegrations.AccountsHook.isEnabled();
    }

    public boolean usePlayerBlockTracker() {
        return this.usePlayerBlockTracker && InternalIntegrations.PlayerBlockTracker.isEnabled();
    }

    public boolean isMinecraftTranslationsEnabled() {
        return this.minecraftTranslationsFile != null && !this.minecraftTranslationsFile.isEmpty();
    }

    public QuestDescription getQuestDescription() {
        return this.questDescription;
    }

    public class QuestsConfig
    implements QuestsConfiguration.Quests {
        private int defaultTimer = 5;
        private int maxLaunchedQuests = 0;
        private boolean scoreboards = true;
        private boolean sounds = true;
        private boolean fireworks = true;
        private String finishSound = "ENTITY_PLAYER_LEVELUP";
        private String nextStageSound = "ITEM_FIRECHARGE_USE";
        private ItemStack defaultQuestItem = XMaterial.BOOK.parseItem();
        private int startParticleDistance;
        private int requirementUpdateTime;
        private boolean sendUpdate = true;
        private boolean stageStart = true;
        private boolean questConfirmGUI = false;
        private Collection<NpcClickType> npcClicks = Arrays.asList(NpcClickType.RIGHT, NpcClickType.SHIFT_RIGHT);
        private boolean dontCancelNpcClick = false;
        private boolean requirementReasonOnMultipleQuests = true;
        private boolean stageEndRewardsMessage = true;

        private void init() {
            this.defaultTimer = QuestsConfigurationImplementation.this.config.getInt("redoMinuts");
            this.maxLaunchedQuests = QuestsConfigurationImplementation.this.config.getInt("maxLaunchedQuests");
            this.scoreboards = QuestsConfigurationImplementation.this.config.getBoolean("scoreboards");
            this.sendUpdate = QuestsConfigurationImplementation.this.config.getBoolean("playerQuestUpdateMessage");
            this.stageStart = QuestsConfigurationImplementation.this.config.getBoolean("playerStageStartMessage");
            this.questConfirmGUI = QuestsConfigurationImplementation.this.config.getBoolean("questConfirmGUI");
            this.sounds = QuestsConfigurationImplementation.this.config.getBoolean("sounds");
            this.fireworks = QuestsConfigurationImplementation.this.config.getBoolean("fireworks");
            this.defaultQuestItem = QuestsConfigurationImplementation.loadItem((ConfigurationSection)QuestsConfigurationImplementation.this.config, "item", XMaterial.BOOK.parseItem());
            this.defaultQuestItem = ItemUtils.clearVisibleAttributes(this.defaultQuestItem);
            this.startParticleDistance = QuestsConfigurationImplementation.this.config.getInt("startParticleDistance");
            this.requirementUpdateTime = QuestsConfigurationImplementation.this.config.getInt("requirementUpdateTime");
            this.finishSound = QuestsConfigurationImplementation.this.loadSound("finishSound");
            this.nextStageSound = QuestsConfigurationImplementation.this.loadSound("nextStageSound");
            try {
                if (QuestsConfigurationImplementation.this.config.isString("npcClick")) {
                    NpcClickType[] npcClickTypeArray;
                    String click = QuestsConfigurationImplementation.this.config.getString("npcClick");
                    if (click.equals("ANY")) {
                        npcClickTypeArray = NpcClickType.values();
                    } else {
                        NpcClickType[] npcClickTypeArray2 = new NpcClickType[1];
                        npcClickTypeArray = npcClickTypeArray2;
                        npcClickTypeArray2[0] = NpcClickType.valueOf(click.toUpperCase());
                    }
                    this.npcClicks = Arrays.asList(npcClickTypeArray);
                } else {
                    this.npcClicks = QuestsConfigurationImplementation.this.config.getStringList("npcClick").stream().map(String::toUpperCase).map(NpcClickType::valueOf).collect(Collectors.toList());
                }
            }
            catch (IllegalArgumentException ex) {
                QuestsPlugin.getPlugin().getLoggerExpanded().warning("Unknown click type " + String.valueOf(QuestsConfigurationImplementation.this.config.get("npcClick")) + " for config entry \"npcClick\"");
            }
            this.dontCancelNpcClick = QuestsConfigurationImplementation.this.config.getBoolean("dont cancel npc click");
            this.requirementReasonOnMultipleQuests = QuestsConfigurationImplementation.this.config.getBoolean("requirementReasonOnMultipleQuests");
            this.stageEndRewardsMessage = QuestsConfigurationImplementation.this.config.getBoolean("stageEndRewardsMessage");
        }

        @Override
        public int getDefaultTimer() {
            return this.defaultTimer;
        }

        @Override
        public int maxLaunchedQuests() {
            return this.maxLaunchedQuests;
        }

        @Override
        public boolean scoreboards() {
            return this.scoreboards;
        }

        @Override
        public boolean playerQuestUpdateMessage() {
            return this.sendUpdate;
        }

        @Override
        public boolean playerStageStartMessage() {
            return this.stageStart;
        }

        @Override
        public boolean questConfirmGUI() {
            return this.questConfirmGUI;
        }

        @Override
        public boolean sounds() {
            return this.sounds;
        }

        @Override
        public String finishSound() {
            return this.finishSound;
        }

        @Override
        public String nextStageSound() {
            return this.nextStageSound;
        }

        @Override
        public boolean fireworks() {
            return this.fireworks;
        }

        @Override
        public Collection<NpcClickType> getNpcClicks() {
            return this.npcClicks;
        }

        @Override
        public boolean dontCancelNpcClick() {
            return this.dontCancelNpcClick;
        }

        @Override
        public ItemStack getDefaultQuestItem() {
            return this.defaultQuestItem;
        }

        @Override
        public double startParticleDistance() {
            return this.startParticleDistance;
        }

        @Override
        public int requirementUpdateTime() {
            return this.requirementUpdateTime;
        }

        @Override
        public boolean requirementReasonOnMultipleQuests() {
            return this.requirementReasonOnMultipleQuests;
        }

        @Override
        public boolean stageEndRewardsMessage() {
            return this.stageEndRewardsMessage;
        }
    }

    public class DatabaseConfig
    implements QuestsConfiguration.Database {
        private ConfigurationSection config;
        private boolean enabled;
        private String host;
        private int port;
        private String database;
        private String username;
        private String password;
        private boolean ssl;
        private String connectionString;
        private Map<String, String> tables;

        private DatabaseConfig(ConfigurationSection config) {
            this.config = config;
        }

        private boolean update() {
            boolean result = false;
            result |= QuestsConfigurationImplementation.migrateEntry(this.config, "tables.playerAccounts", this.config, "tables.questers");
            result |= QuestsConfigurationImplementation.migrateEntry(this.config, "tables.playerQuests", this.config, "tables.questers quests");
            return result |= QuestsConfigurationImplementation.migrateEntry(this.config, "tables.playerPools", this.config, "tables.questers pools");
        }

        private void init() {
            this.enabled = this.config.getBoolean("enabled");
            this.host = this.config.getString("host");
            this.port = this.config.getInt("port");
            this.database = this.config.getString("database");
            this.username = this.config.getString("username");
            this.password = this.config.getString("password");
            this.ssl = this.config.getBoolean("ssl");
            this.connectionString = this.config.getString("connectionString");
            this.tables = this.config.getConfigurationSection("tables").getValues(false);
        }

        @Override
        public boolean enabled() {
            return this.enabled;
        }

        @Override
        public String host() {
            return this.host;
        }

        @Override
        public int port() {
            return this.port;
        }

        @Override
        public String databaseName() {
            return this.database;
        }

        @Override
        public String username() {
            return this.username;
        }

        @Override
        public String password() {
            return this.password;
        }

        @Override
        public boolean sslEnabled() {
            return this.ssl;
        }

        @Override
        public String connectionString() {
            return this.connectionString;
        }

        @Override
        public Map<String, String> tables() {
            return this.tables;
        }
    }

    public class GuiConfig
    implements QuestsConfiguration.Gui {
        private ItemStack previousPageItem;
        private ItemStack nextPageItem;
        private boolean verticalSeparator;
        private final ConfigurationSection config;

        private GuiConfig(ConfigurationSection config) {
            this.config = config;
        }

        private boolean update() {
            boolean result = false;
            if (this.config.getParent() != null) {
                result |= QuestsConfigurationImplementation.migrateEntry(this.config.getParent(), "pageItem", this.config, "previous page item");
                if (this.config.get("next page item", null) == null) {
                    this.config.set("next page item", this.config.get("previous page item"));
                }
            }
            return result;
        }

        private void init() {
            this.previousPageItem = QuestsConfigurationImplementation.loadItem(this.config, "previous page item", XMaterial.ARROW.parseItem());
            this.nextPageItem = QuestsConfigurationImplementation.loadItem(this.config, "next page item", XMaterial.ARROW.parseItem());
            this.verticalSeparator = this.config.getBoolean("vertical separator");
        }

        @Override
        public ItemStack getPreviousPageItem() {
            return this.previousPageItem;
        }

        @Override
        public ItemStack getNextPageItem() {
            return this.nextPageItem;
        }

        @Override
        public boolean showVerticalSeparator() {
            return this.verticalSeparator;
        }
    }

    public class DialogsConfig
    implements QuestsConfiguration.Dialogs {
        private boolean inActionBar = false;
        private int defaultTime = 100;
        private boolean defaultSkippable = true;
        private boolean disableClick = false;
        private boolean history = true;
        private int maxMessagesPerHistoryPage = -1;
        private int maxDistance = 15;
        private int maxDistanceSquared = 225;
        private String defaultPlayerSound = null;
        private String defaultNPCSound = null;
        private ConfigurationSection config;

        private DialogsConfig(ConfigurationSection config) {
            this.config = config;
        }

        private boolean update() {
            boolean result = false;
            if (this.config.getParent() != null) {
                result |= QuestsConfigurationImplementation.migrateEntry(this.config.getParent(), "dialogsInActionBar", this.config, "inActionBar");
                result |= QuestsConfigurationImplementation.migrateEntry(this.config.getParent(), "dialogsDefaultTime", this.config, "defaultTime");
                result |= QuestsConfigurationImplementation.migrateEntry(this.config.getParent(), "disableDialogClick", this.config, "disableClick");
                result |= QuestsConfigurationImplementation.migrateEntry(this.config.getParent(), "dialogHistory", this.config, "history");
            }
            return result;
        }

        private void init() {
            this.inActionBar = this.config.getBoolean("inActionBar");
            this.defaultTime = this.config.getInt("defaultTime");
            this.defaultSkippable = this.config.getBoolean("defaultSkippable");
            this.disableClick = this.config.getBoolean("disableClick");
            this.history = this.config.getBoolean("history");
            this.maxMessagesPerHistoryPage = this.config.getInt("max messages per history page");
            this.maxDistance = this.config.getInt("maxDistance");
            this.maxDistanceSquared = this.maxDistance <= 0 ? 0 : this.maxDistance * this.maxDistance;
            this.defaultPlayerSound = this.config.getString("defaultPlayerSound");
            this.defaultNPCSound = this.config.getString("defaultNPCSound");
        }

        @Override
        public boolean sendInActionBar() {
            return this.inActionBar;
        }

        @Override
        public int getDefaultTime() {
            return this.defaultTime;
        }

        @Override
        public boolean isSkippableByDefault() {
            return this.defaultSkippable;
        }

        @Override
        public boolean isClickDisabled() {
            return this.disableClick;
        }

        @Override
        public boolean isHistoryEnabled() {
            return this.history;
        }

        @Override
        public int getMaxMessagesPerHistoryPage() {
            return this.maxMessagesPerHistoryPage;
        }

        @Override
        public int getMaxDistance() {
            return this.maxDistance;
        }

        @Override
        public int getMaxDistanceSquared() {
            return this.maxDistanceSquared;
        }

        @Override
        public String getDefaultPlayerSound() {
            return this.defaultPlayerSound;
        }

        @Override
        public String getDefaultNPCSound() {
            return this.defaultNPCSound;
        }
    }

    public class QuestsSelectionConfig
    implements QuestsConfiguration.QuestsSelection {
        private boolean skipGuiIfOnlyOneQuest = true;
        private boolean hideNoRequirements = true;
        private final ConfigurationSection config;

        private QuestsSelectionConfig(ConfigurationSection config) {
            this.config = config;
        }

        private boolean update() {
            boolean result = false;
            if (this.config.getParent() != null) {
                result |= QuestsConfigurationImplementation.migrateEntry(this.config.getParent(), "skip npc gui if only one quest", this.config, "skip gui if only one quest");
            }
            return result;
        }

        private void init() {
            this.skipGuiIfOnlyOneQuest = this.config.getBoolean("skip gui if only one quest");
            this.hideNoRequirements = this.config.getBoolean("hide quests without requirement");
        }

        @Override
        public boolean skipGuiIfOnlyOneQuest() {
            return this.skipGuiIfOnlyOneQuest;
        }

        @Override
        public boolean hideNoRequirements() {
            return this.hideNoRequirements;
        }
    }

    public class QuestsMenuConfig
    implements QuestsConfiguration.QuestsMenu {
        private Set<PlayerListCategory> tabs;
        private boolean openNotStartedTabWhenEmpty = true;
        private boolean allowPlayerCancelQuest = true;
        private boolean keepMenuOpen = false;
        private ConfigurationSection config;

        private QuestsMenuConfig(ConfigurationSection config) {
            this.config = config;
        }

        private boolean update() {
            boolean result = false;
            if (this.config.getParent() != null) {
                result |= QuestsConfigurationImplementation.migrateEntry(this.config.getParent(), "menuOpenNotStartedTabWhenEmpty", this.config, "openNotStartedTabWhenEmpty");
                result |= QuestsConfigurationImplementation.migrateEntry(this.config.getParent(), "allowPlayerCancelQuest", this.config, "allowPlayerCancelQuest");
            }
            if (this.config.contains("enabledTabs")) {
                Set tabs = this.config.getStringList("enabledTabs").stream().map(PlayerListCategory::fromString).collect(Collectors.toSet());
                for (PlayerListCategory cat : PlayerListCategory.values()) {
                    this.config.set("tabs." + cat.name().toLowerCase().replace('_', ' ') + ".enabled", (Object)tabs.contains((Object)cat));
                }
                result = true;
            }
            return result;
        }

        private void init() {
            this.tabs = EnumSet.noneOf(PlayerListCategory.class);
            for (PlayerListCategory cat : PlayerListCategory.values()) {
                ConfigurationSection catConfig = this.config.getConfigurationSection("tabs." + cat.name().toLowerCase().replace('_', ' '));
                cat.setIcon(QuestsConfigurationImplementation.loadItem(catConfig, "icon", XMaterial.BARRIER.parseItem()));
                cat.setColor(DyeColor.valueOf((String)catConfig.getString("color").toUpperCase()));
                if (!catConfig.getBoolean("enabled")) continue;
                this.tabs.add(cat);
            }
            if (this.tabs.isEmpty()) {
                QuestsPlugin.getPlugin().getLoggerExpanded().warning("Quests Menu must have at least one enabled tab.");
                this.tabs = EnumSet.allOf(PlayerListCategory.class);
            }
            this.openNotStartedTabWhenEmpty = this.config.getBoolean("openNotStartedTabWhenEmpty");
            this.allowPlayerCancelQuest = this.config.getBoolean("allowPlayerCancelQuest");
            this.keepMenuOpen = this.config.getBoolean("keep menu open");
        }

        @Override
        public boolean isNotStartedTabOpenedWhenEmpty() {
            return this.openNotStartedTabWhenEmpty;
        }

        @Override
        public boolean allowPlayerCancelQuest() {
            return this.allowPlayerCancelQuest;
        }

        @Override
        public Set<PlayerListCategory> getEnabledTabs() {
            return this.tabs;
        }

        @Override
        public boolean keepMenuOpen() {
            return this.keepMenuOpen;
        }
    }

    public class StageDescriptionConfig
    implements QuestsConfiguration.StageDescription {
        private String itemSingleFormat;
        private String itemMultipleFormat;
        private String stageDescriptionFormat;
        private String descPrefix = "{nl}\u00a7e- \u00a76";
        private boolean inlineAlone = true;
        private Set<DescriptionSource> descSources = EnumSet.noneOf(DescriptionSource.class);
        private boolean bossBars = true;
        private String bossBarFormat;
        private int bossBarTimeout = 15;
        private final ConfigurationSection config;

        public StageDescriptionConfig(ConfigurationSection config) {
            this.config = config;
        }

        private void init() {
            this.itemSingleFormat = this.config.getString("item formats.single");
            this.itemMultipleFormat = this.config.getString("item formats.multiple");
            this.stageDescriptionFormat = this.config.getString("description format");
            this.descPrefix = "{nl}" + this.config.getString("line prefix");
            this.inlineAlone = this.config.getBoolean("inline alone");
            for (String s : this.config.getStringList("split sources")) {
                try {
                    this.descSources.add(DescriptionSource.valueOf(s));
                }
                catch (IllegalArgumentException ex) {
                    QuestsPlugin.getPlugin().getLoggerExpanded().warning("Loading of description splitted sources failed : source " + s + " does not exist");
                }
            }
            this.bossBars = this.config.getBoolean("boss bars");
            this.bossBarFormat = this.config.getString("boss bar format");
            this.bossBarTimeout = this.config.getInt("boss bar timeout");
        }

        private boolean update() {
            boolean result = false;
            ConfigurationSection oldConfig = this.config.getParent().getConfigurationSection("stageDescriptionItemsSplit");
            result |= QuestsConfigurationImplementation.migrateEntry(this.config.getParent(), "stageDescriptionFormat", this.config, "description format");
            if (oldConfig != null) {
                QuestsConfigurationImplementation.migrateEntry(oldConfig, "prefix", this.config, "line prefix");
                QuestsConfigurationImplementation.migrateEntry(oldConfig, "sources", this.config, "split sources");
                QuestsConfigurationImplementation.migrateEntry(oldConfig, "inlineAlone", this.config, "inline alone");
                String amountFormat = oldConfig.getString("amountFormat");
                boolean showXOne = oldConfig.getBoolean("showXOne");
                String itemNameColor = this.config.getParent().getString("itemNameColor");
                String itemAmountColor = this.config.getParent().getString("itemAmountColor");
                String multipleFormat = itemNameColor + "{name}" + itemAmountColor + " " + amountFormat;
                String singleFormat = showXOne ? multipleFormat : itemNameColor + "{name}";
                this.config.set("item formats.multiple", (Object)multipleFormat);
                this.config.set("item formats.single", (Object)singleFormat);
                this.config.getParent().set("itemNameColor", null);
                this.config.getParent().set("itemAmountColor", null);
                this.config.getParent().set("stageDescriptionItemsSplit", null);
                result = true;
            }
            result |= QuestsConfigurationImplementation.migrateEntry(this.config.getParent(), "mobsProgressBar", this.config, "boss bars");
            return result |= QuestsConfigurationImplementation.migrateEntry(this.config.getParent(), "progressBarTimeoutSeconds", this.config, "boss bar timeout");
        }

        @Override
        public String getStageDescriptionFormat() {
            return this.stageDescriptionFormat;
        }

        @Override
        @NotNull
        public String getSingleItemFormat() {
            return this.itemSingleFormat;
        }

        @Override
        @NotNull
        public String getMultipleItemsFormat() {
            return this.itemMultipleFormat;
        }

        @Override
        public String getSplitPrefix() {
            return this.descPrefix;
        }

        @Override
        public boolean isAloneSplitInlined() {
            return this.inlineAlone;
        }

        @Override
        public Set<DescriptionSource> getSplitSources() {
            return this.descSources;
        }

        @Override
        public boolean areBossBarsEnabled() {
            return this.bossBars;
        }

        @Override
        public String getBossBarFormat() {
            return this.bossBarFormat;
        }

        @Override
        public int getBossBarTimeout() {
            return this.bossBarTimeout;
        }
    }

    public class QuestDescriptionConfig
    implements QuestDescription {
        private boolean requirements;
        private String requirementsValid;
        private String requirementsInvalid;
        private boolean rewards;
        private String rewardsFormat;
        private final ConfigurationSection config;

        public QuestDescriptionConfig(ConfigurationSection config) {
            this.config = config;
        }

        private void init() {
            this.requirements = this.config.getBoolean("requirements.display");
            this.requirementsValid = this.config.getString("requirements.valid");
            this.requirementsInvalid = this.config.getString("requirements.invalid");
            this.rewards = this.config.getBoolean("rewards.display");
            this.rewardsFormat = this.config.getString("rewards.format");
        }

        @Override
        public boolean showRewards() {
            return this.rewards;
        }

        @Override
        public String getRewardsFormat() {
            return this.rewardsFormat;
        }

        @Override
        public boolean showRequirements() {
            return this.requirements;
        }

        @Override
        public String getRequirementsValid() {
            return this.requirementsValid;
        }

        @Override
        public String getRequirementsInvalid() {
            return this.requirementsInvalid;
        }
    }
}

