/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests;

import com.cryptomorin.xseries.XMaterial;
import fr.skytasul.quests.BeautyQuests;
import fr.skytasul.quests.api.QuestsAPI;
import fr.skytasul.quests.api.QuestsConfiguration;
import fr.skytasul.quests.api.QuestsPlugin;
import fr.skytasul.quests.api.events.internal.BQBlockBreakEvent;
import fr.skytasul.quests.api.events.internal.BQCraftEvent;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.npcs.BqNpc;
import fr.skytasul.quests.api.players.PlayerQuester;
import fr.skytasul.quests.api.pools.QuestPool;
import fr.skytasul.quests.api.questers.events.QuesterJoinEvent;
import fr.skytasul.quests.api.questers.events.QuesterLeaveEvent;
import fr.skytasul.quests.api.quests.Quest;
import fr.skytasul.quests.api.utils.Utils;
import fr.skytasul.quests.api.utils.messaging.MessageType;
import fr.skytasul.quests.api.utils.messaging.MessageUtils;
import fr.skytasul.quests.npcs.BQNPCClickEvent;
import fr.skytasul.quests.options.OptionAutoQuest;
import fr.skytasul.quests.structure.QuestImplementation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.SmithItemEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.inventory.ComplexRecipe;
import org.bukkit.inventory.ItemStack;

public class QuestsListener
implements Listener {
    private List<QuestPool> lockedPools = Collections.synchronizedList(new ArrayList());

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onNPCClick(BQNPCClickEvent e) {
        if (e.isCancelled()) {
            return;
        }
        if (!QuestsConfiguration.getConfig().getQuestsConfig().getNpcClicks().contains((Object)e.getClick())) {
            return;
        }
        Player p = e.getPlayer();
        BqNpc npc = e.getNPC();
        if (QuestsPlugin.getPlugin().getGuiManager().hasGuiOpened(p) || QuestsPlugin.getPlugin().getEditorManager().isInEditor(p)) {
            return;
        }
        PlayerQuester quester = BeautyQuests.getInstance().getPlayersManager().getQuester(p);
        if (quester == null) {
            return;
        }
        Set<Quest> quests = npc.getQuests();
        if ((quests = quests.stream().filter(qu -> !qu.hasStarted(quester) && (qu.isRepeatable() || !qu.hasFinished(quester))).collect(Collectors.toSet())).isEmpty() && npc.getPools().isEmpty()) {
            return;
        }
        ArrayList<QuestImplementation> launcheable = new ArrayList<QuestImplementation>();
        ArrayList<QuestImplementation> requirements = new ArrayList<QuestImplementation>();
        ArrayList<QuestImplementation> timer = new ArrayList<QuestImplementation>();
        for (Quest quest : quests) {
            QuestImplementation quest2 = (QuestImplementation)quest;
            try {
                if (!quest2.testRequirements(p, quester, false)) {
                    requirements.add(quest2);
                    continue;
                }
                if (!quest2.testTimer(quester, false)) {
                    timer.add(quest2);
                    continue;
                }
                launcheable.add(quest2);
            }
            catch (Exception ex2) {
                QuestsPlugin.getPlugin().getLoggerExpanded().severe("An exception occured when checking requirements on the quest " + quest2.getId() + " for player " + p.getName(), ex2);
            }
        }
        Set startablePools = npc.getPools().stream().filter(pool -> {
            try {
                if (this.lockedPools.contains(pool)) {
                    QuestsPlugin.getPlugin().getLoggerExpanded().warning("{} tried to start the pool {} too fast", quester.getDetailedName(), pool.getId());
                    return false;
                }
                return pool.canGive(p).result();
            }
            catch (Exception ex) {
                QuestsPlugin.getPlugin().getLoggerExpanded().severe("An exception occured when checking requirements on the pool " + pool.getId() + " for player " + p.getName(), ex);
                return false;
            }
        }).collect(Collectors.toSet());
        e.setCancelled(true);
        if (!launcheable.isEmpty()) {
            Collection<Object> collection;
            for (QuestImplementation quest2 : launcheable) {
                if (!quest2.isInDialog(p)) continue;
                quest2.doNpcClick(p);
                return;
            }
            Collection<Object> collection2 = collection = QuestsConfiguration.getConfig().getQuestsSelectionConfig().hideNoRequirements() ? launcheable : quests;
            if (collection.size() == 1 && QuestsConfiguration.getConfig().getQuestsSelectionConfig().skipGuiIfOnlyOneQuest()) {
                ((Quest)collection.iterator().next()).doNpcClick(p);
            } else if (!collection.isEmpty()) {
                QuestsPlugin.getPlugin().getGuiManager().getFactory().createPlayerQuestSelection(p, collection).open(p);
            }
        } else if (!startablePools.isEmpty()) {
            QuestPool questPool = (QuestPool)startablePools.iterator().next();
            this.lockedPools.add(questPool);
            questPool.give(p).whenComplete((result, ex) -> {
                this.lockedPools.remove(pool2);
                if (ex != null) {
                    QuestsPlugin.getPlugin().getLoggerExpanded().severe("Failed to give pool {} to {}", (Throwable)ex, (Object)quester.getDetailedName());
                } else if (result != null) {
                    QuestsPlugin.getPlugin().getLoggerExpanded().debug("NPC {}: {} pools, result: {}", npc.getId(), startablePools.size(), result);
                }
            });
        } else {
            if (!timer.isEmpty()) {
                ((QuestImplementation)timer.get(0)).testTimer(quester, true);
            } else if (!requirements.isEmpty()) {
                ((QuestImplementation)requirements.get(0)).testRequirements(p, quester, true);
            } else {
                for (QuestPool pool3 : npc.getPools()) {
                    String reason = pool3.canGive(p).reason();
                    if (reason == null) continue;
                    MessageUtils.sendMessage((CommandSender)p, reason, (MessageType)MessageType.DefaultMessageType.PREFIXED);
                    break;
                }
            }
            e.setCancelled(false);
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onAccountJoin(QuesterJoinEvent e) {
        if (e.isFirstJoin()) {
            QuestsAPI.getAPI().getQuestsManager().getQuests().stream().filter(qu -> (Boolean)qu.getOptionValueOrDef(OptionAutoQuest.class)).forEach(qu -> qu.start(e.getQuester(), false));
        }
    }

    @EventHandler
    public void onAccountLeave(QuesterLeaveEvent e) {
        BeautyQuests.getInstance().getQuestsManager().getQuests().forEach(x -> x.leave(e.getPlayer()));
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onDrop(PlayerDropItemEvent e) {
        if (Utils.isQuestItem(e.getItemDrop().getItemStack())) {
            e.setCancelled(true);
            Lang.QUEST_ITEM_DROP.send((CommandSender)e.getPlayer());
        }
    }

    @EventHandler
    public void onEntityDamage(EntityDamageByEntityEvent e) {
        if (e.getDamager().hasMetadata("questFinish")) {
            e.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onCraft(CraftItemEvent e) {
        for (ItemStack item : e.getInventory().getMatrix()) {
            if (!Utils.isQuestItem(item)) continue;
            e.setCancelled(true);
            Lang.QUEST_ITEM_CRAFT.send((CommandSender)e.getWhoClicked());
            break;
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onEat(PlayerItemConsumeEvent e) {
        if (Utils.isQuestItem(e.getItem())) {
            e.setCancelled(true);
            Lang.QUEST_ITEM_EAT.send((CommandSender)e.getPlayer());
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onDeath(PlayerDeathEvent e) {
        BeautyQuests.getInstance().getPaperCompatibility().ifPresent(paper -> paper.keepDeathItems(e, Utils::isQuestItem));
    }

    @EventHandler
    public void onPlace(BlockPlaceEvent e) {
        if (Utils.isQuestItem(e.getItemInHand())) {
            e.setCancelled(true);
            Lang.QUEST_ITEM_PLACE.send((CommandSender)e.getPlayer());
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onBreak(BlockBreakEvent e) {
        if (e.isCancelled()) {
            return;
        }
        if (e.getPlayer() == null) {
            return;
        }
        Bukkit.getPluginManager().callEvent((Event)new BQBlockBreakEvent(e.getPlayer(), Arrays.asList(e.getBlock())));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onCraftMonitor(CraftItemEvent e) {
        String key;
        if (e.getInventory().getResult() == null) {
            return;
        }
        int resultCount = e.getInventory().getResult().getAmount();
        int materialCount = Integer.MAX_VALUE;
        for (ItemStack is : e.getInventory().getMatrix()) {
            if (is == null || is.getAmount() >= materialCount) continue;
            materialCount = is.getAmount();
        }
        int maxCraftAmount = resultCount * materialCount;
        ItemStack item = e.getRecipe().getResult();
        if (item.getType() == Material.AIR && e.getRecipe() instanceof ComplexRecipe && (key = ((ComplexRecipe)e.getRecipe()).getKey().toString()).equals("minecraft:suspicious_stew")) {
            item = XMaterial.SUSPICIOUS_STEW.parseItem();
        }
        Bukkit.getPluginManager().callEvent((Event)new BQCraftEvent((InventoryClickEvent)e, item, maxCraftAmount));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onSmith(SmithItemEvent event) {
        Bukkit.getPluginManager().callEvent((Event)new BQCraftEvent((InventoryClickEvent)event, event.getCurrentItem(), event.getCurrentItem().getAmount()));
    }
}

