/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.api;

import fr.skytasul.quests.api.QuestsAPI;
import fr.skytasul.quests.api.QuestsHandler;
import fr.skytasul.quests.api.QuestsPlugin;
import fr.skytasul.quests.api.npcs.BqNpc;
import fr.skytasul.quests.api.quests.Quest;
import fr.skytasul.quests.api.utils.QuestVisibilityLocation;
import org.bukkit.Location;

public abstract class AbstractMapIntegration
implements QuestsHandler {
    @Override
    public final void load() {
        if (this.isEnabled()) {
            this.initializeMarkers(this::initializeQuests);
        }
    }

    private void initializeQuests() {
        QuestsAPI.getAPI().getQuestsManager().getQuests().forEach(this::questLoaded);
    }

    @Override
    public void questLoaded(Quest quest) {
        if (!this.isEnabled()) {
            return;
        }
        BqNpc starter = quest.getStarterNpc();
        if (starter == null) {
            return;
        }
        if (quest.isHidden(QuestVisibilityLocation.MAPS)) {
            QuestsPlugin.getPlugin().getLoggerExpanded().debug("No marker created for quest " + quest.getId() + ": quest is hidden");
            return;
        }
        Location lc = starter.getLocation();
        if (lc == null) {
            QuestsPlugin.getPlugin().getLoggerExpanded().warning("Cannot create map marker for quest #" + quest.getId() + " (" + quest.getName() + ")");
        } else {
            this.addMarker(quest, lc);
        }
    }

    @Override
    public void questUnload(Quest quest) {
        if (!quest.isHidden(QuestVisibilityLocation.MAPS) && quest.getStarterNpc() != null) {
            this.removeMarker(quest);
        }
    }

    public abstract boolean isEnabled();

    protected abstract void initializeMarkers(Runnable var1);

    protected abstract void addMarker(Quest var1, Location var2);

    protected abstract void removeMarker(Quest var1);
}

