/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.api;

import fr.skytasul.quests.QuestsAPIProvider;
import fr.skytasul.quests.api.AbstractHolograms;
import fr.skytasul.quests.api.QuestsHandler;
import fr.skytasul.quests.api.QuestsPlugin;
import fr.skytasul.quests.api.blocks.BQBlocksManager;
import fr.skytasul.quests.api.comparison.ItemComparison;
import fr.skytasul.quests.api.mobs.MobFactory;
import fr.skytasul.quests.api.mobs.MobStacker;
import fr.skytasul.quests.api.npcs.BqInternalNpcFactory;
import fr.skytasul.quests.api.npcs.dialogs.MessageSender;
import fr.skytasul.quests.api.objects.QuestObjectsRegistry;
import fr.skytasul.quests.api.options.QuestOption;
import fr.skytasul.quests.api.options.QuestOptionCreator;
import fr.skytasul.quests.api.pools.QuestPoolsManager;
import fr.skytasul.quests.api.questers.QuesterManager;
import fr.skytasul.quests.api.quests.QuestsManager;
import fr.skytasul.quests.api.quests.quester.QuestQuesterStrategy;
import fr.skytasul.quests.api.quests.quester.QuestQuesterStrategyCreator;
import fr.skytasul.quests.api.requirements.AbstractRequirement;
import fr.skytasul.quests.api.requirements.RequirementCreator;
import fr.skytasul.quests.api.rewards.AbstractReward;
import fr.skytasul.quests.api.rewards.RewardCreator;
import fr.skytasul.quests.api.serializable.SerializableRegistry;
import fr.skytasul.quests.api.stages.StageTypeRegistry;
import fr.skytasul.quests.api.utils.messaging.MessageProcessor;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface QuestsAPI {
    @NotNull
    public QuestsPlugin getPlugin();

    @NotNull
    public QuestsManager getQuestsManager();

    @NotNull
    public QuestPoolsManager getPoolsManager();

    @NotNull
    public QuesterManager getQuesterManager();

    @NotNull
    public SerializableRegistry<QuestQuesterStrategy, QuestQuesterStrategyCreator> getQuestQuesterStrategyRegistry();

    public void registerMobFactory(@NotNull MobFactory<?> var1);

    @NotNull
    public Collection<QuestOptionCreator<?, ?>> getQuestOptions();

    public <D, T extends QuestOption<D>> Optional<QuestOptionCreator<D, T>> getQuestOption(Class<T> var1);

    public void registerQuestOption(@NotNull QuestOptionCreator<?, ?> var1);

    @NotNull
    public @NotNull List<@NotNull ItemComparison> getItemComparisons();

    public void registerItemComparison(@NotNull ItemComparison var1);

    public void unregisterItemComparison(@NotNull ItemComparison var1);

    @NotNull
    public @NotNull List<@NotNull MobStacker> getMobStackers();

    public void registerMobStacker(@NotNull MobStacker var1);

    @NotNull
    public StageTypeRegistry getStages();

    @NotNull
    public QuestObjectsRegistry<AbstractRequirement, RequirementCreator> getRequirements();

    @NotNull
    public QuestObjectsRegistry<AbstractReward, RewardCreator> getRewards();

    public void addNpcFactory(@NotNull String var1, @NotNull BqInternalNpcFactory var2);

    default public boolean hasHologramsManager() {
        return this.getHologramsManager() != null;
    }

    @Nullable
    public AbstractHolograms<?> getHologramsManager();

    public void setHologramsManager(@NotNull AbstractHolograms<?> var1);

    @NotNull
    public BQBlocksManager getBlocksManager();

    public void registerQuestsHandler(@NotNull QuestsHandler var1);

    public void unregisterQuestsHandler(@NotNull QuestsHandler var1);

    @NotNull
    public @NotNull Collection<@NotNull QuestsHandler> getQuestsHandlers();

    public void propagateQuestsHandlers(@NotNull @NotNull Consumer<@NotNull QuestsHandler> var1);

    @NotNull
    public Collection<MessageProcessor> getMessageProcessors();

    public void registerMessageProcessor(@NotNull String var1, int var2, @NotNull MessageProcessor var3);

    @NotNull
    public MessageSender getMessageSender();

    public void setMessageSender(@NotNull MessageSender var1);

    @NotNull
    public static QuestsAPI getAPI() {
        return QuestsAPIProvider.getAPI();
    }
}

