/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.api;

import fr.skytasul.quests.api.QuestsPlugin;
import fr.skytasul.quests.api.npcs.NpcClickType;
import fr.skytasul.quests.api.options.description.QuestDescription;
import fr.skytasul.quests.api.utils.PlayerListCategory;
import fr.skytasul.quests.api.utils.progress.ProgressBarConfig;
import fr.skytasul.quests.api.utils.progress.itemdescription.ItemsDescriptionConfiguration;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface QuestsConfiguration {
    @NotNull
    public static QuestsConfiguration getConfig() {
        return QuestsPlugin.getPlugin().getConfiguration();
    }

    @NotNull
    public Quests getQuestsConfig();

    @NotNull
    public Gui getGuiConfig();

    @NotNull
    public Dialogs getDialogsConfig();

    @NotNull
    public QuestsSelection getQuestsSelectionConfig();

    @NotNull
    public QuestsMenu getQuestsMenuConfig();

    @NotNull
    public StageDescription getStageDescriptionConfig();

    @NotNull
    public QuestDescription getQuestDescriptionConfig();

    public static interface Database {
        public boolean enabled();

        @Nullable
        public String host();

        public int port();

        @NotNull
        public String databaseName();

        @Nullable
        public String username();

        @Nullable
        public String password();

        public boolean sslEnabled();

        @Nullable
        public String connectionString();

        @NotNull
        public Map<String, String> tables();
    }

    public static interface StageDescription
    extends ItemsDescriptionConfiguration,
    ProgressBarConfig {
        public String getStageDescriptionFormat();
    }

    public static interface QuestsMenu {
        public boolean isNotStartedTabOpenedWhenEmpty();

        public boolean allowPlayerCancelQuest();

        public Set<PlayerListCategory> getEnabledTabs();

        public boolean keepMenuOpen();
    }

    public static interface QuestsSelection {
        public boolean skipGuiIfOnlyOneQuest();

        public boolean hideNoRequirements();
    }

    public static interface Dialogs {
        public boolean sendInActionBar();

        public int getDefaultTime();

        public boolean isSkippableByDefault();

        public boolean isClickDisabled();

        public boolean isHistoryEnabled();

        public int getMaxMessagesPerHistoryPage();

        public int getMaxDistance();

        public int getMaxDistanceSquared();

        public String getDefaultPlayerSound();

        public String getDefaultNPCSound();
    }

    public static interface Gui {
        public ItemStack getPreviousPageItem();

        public ItemStack getNextPageItem();

        public boolean showVerticalSeparator();
    }

    public static interface Quests {
        public int getDefaultTimer();

        public int maxLaunchedQuests();

        public boolean scoreboards();

        public boolean playerQuestUpdateMessage();

        public boolean playerStageStartMessage();

        public boolean questConfirmGUI();

        public boolean sounds();

        public String finishSound();

        public String nextStageSound();

        public boolean fireworks();

        public Collection<NpcClickType> getNpcClicks();

        public boolean dontCancelNpcClick();

        public ItemStack getDefaultQuestItem();

        public double startParticleDistance();

        public int requirementUpdateTime();

        public boolean requirementReasonOnMultipleQuests();

        public boolean stageEndRewardsMessage();
    }
}

