/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.api.blocks;

import com.cryptomorin.xseries.XMaterial;
import fr.skytasul.quests.api.QuestsAPI;
import fr.skytasul.quests.api.blocks.BQBlockOptions;
import fr.skytasul.quests.api.blocks.BQBlockType;
import fr.skytasul.quests.api.utils.MinecraftNames;
import fr.skytasul.quests.api.utils.messaging.HasPlaceholders;
import fr.skytasul.quests.api.utils.messaging.PlaceholderRegistry;
import org.bukkit.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BQBlock
implements HasPlaceholders {
    @NotNull
    private final BQBlockType type;
    @Nullable
    private final String customName;
    @Nullable
    private XMaterial cachedMaterial;
    @Nullable
    private String cachedName;
    @Nullable
    private PlaceholderRegistry placeholders;

    protected BQBlock(@NotNull BQBlockOptions options) {
        this.type = options.getType();
        this.customName = options.getCustomName();
    }

    @NotNull
    protected abstract String getDataString();

    public abstract boolean applies(@NotNull Block var1);

    @NotNull
    public abstract XMaterial retrieveMaterial();

    @NotNull
    public final XMaterial getMaterial() {
        if (this.cachedMaterial == null) {
            this.cachedMaterial = this.retrieveMaterial();
        }
        return this.cachedMaterial;
    }

    @NotNull
    public String getDefaultName() {
        return MinecraftNames.getMaterialName(this.getMaterial());
    }

    @NotNull
    public final String getName() {
        if (this.cachedName == null) {
            this.cachedName = this.customName == null ? this.getDefaultName() : this.customName;
        }
        return this.cachedName;
    }

    @NotNull
    public final String getAsString() {
        return this.getHeader() + this.getDataString() + this.getFooter();
    }

    @NotNull
    private String getHeader() {
        String header = QuestsAPI.getAPI().getBlocksManager().getHeader(this.type);
        return header == null ? "" : header + ":";
    }

    @NotNull
    private String getFooter() {
        return this.customName == null ? "" : "|customname:" + this.customName;
    }

    public String toString() {
        return "BQBlock{" + this.getAsString() + "}";
    }

    @Override
    @NotNull
    public PlaceholderRegistry getPlaceholdersRegistry() {
        if (this.placeholders == null) {
            this.placeholders = new PlaceholderRegistry().registerIndexed("block_type", this.getAsString()).register("block_material", this.getMaterial().name()).register("block", this.getName());
        }
        return this.placeholders;
    }
}

