/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.api.comparison;

import java.util.function.BiPredicate;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ItemComparison {
    @NotNull
    private final String id;
    @NotNull
    private final String itemName;
    @NotNull
    private final String itemDescription;
    @NotNull
    private final @NotNull BiPredicate<@NotNull ItemStack, @NotNull ItemStack> comparator;
    private boolean enabledByDefault;
    private boolean needsMeta;
    private boolean hasPriority;

    public ItemComparison(@NotNull String id, @NotNull String itemName, @NotNull String itemDescription, @NotNull @NotNull BiPredicate<@NotNull ItemStack, @NotNull ItemStack> comparator) {
        this.id = id;
        this.itemName = itemName;
        this.itemDescription = itemDescription;
        this.comparator = comparator;
    }

    public String getID() {
        return this.id;
    }

    public String getItemName() {
        return this.itemName;
    }

    public String getItemDescription() {
        return this.itemDescription;
    }

    public ItemComparison setEnabledByDefault() {
        this.enabledByDefault = true;
        return this;
    }

    public boolean isEnabledByDefault() {
        return this.enabledByDefault;
    }

    public ItemComparison setMetaNeeded() {
        this.needsMeta = true;
        return this;
    }

    public boolean isMetaNeeded() {
        return this.needsMeta;
    }

    public ItemComparison setHasPriority() {
        this.hasPriority = true;
        return this;
    }

    public boolean hasPriority() {
        return this.hasPriority;
    }

    public boolean isSimilar(@NotNull ItemStack item1, @NotNull ItemStack item2) {
        return this.comparator.test(item1, item2);
    }
}

