/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.api.comparison;

import fr.skytasul.quests.api.QuestsAPI;
import fr.skytasul.quests.api.comparison.ItemComparison;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ItemComparisonMap
implements Cloneable {
    private Map<String, Boolean> notDefault;
    private List<ItemComparison> effective;

    public ItemComparisonMap() {
        this(new HashMap<String, Boolean>());
    }

    public ItemComparisonMap(@NotNull ConfigurationSection notDefault) {
        this.setNotDefaultComparisons(notDefault);
    }

    public ItemComparisonMap(@NotNull Map<String, Boolean> notDefault) {
        this.setNotDefaultComparisons(notDefault);
    }

    public void setNotDefaultComparisons(@NotNull ConfigurationSection section) {
        this.notDefault = section.getValues(false);
        this.effective = new ArrayList<ItemComparison>(3);
        for (ItemComparison comp : QuestsAPI.getAPI().getItemComparisons()) {
            if (!section.getBoolean(comp.getID(), comp.isEnabledByDefault())) continue;
            this.effective.add(comp);
        }
        this.updated();
    }

    public void setNotDefaultComparisons(@NotNull Map<String, Boolean> comparisons) {
        this.notDefault = comparisons;
        this.effective = new ArrayList<ItemComparison>(3);
        for (ItemComparison comp : QuestsAPI.getAPI().getItemComparisons()) {
            Boolean bool = this.notDefault.get(comp.getID());
            if (Boolean.FALSE.equals(bool) || !comp.isEnabledByDefault() && !Boolean.TRUE.equals(bool)) continue;
            this.effective.add(comp);
        }
        this.updated();
    }

    @NotNull
    public Map<String, Boolean> getNotDefault() {
        return this.notDefault;
    }

    public boolean isDefault() {
        return this.notDefault.isEmpty();
    }

    @NotNull
    public @NotNull List<@NotNull ItemComparison> getEffective() {
        return this.effective;
    }

    public boolean isEnabled(@NotNull ItemComparison comparison) {
        return this.effective.contains(comparison);
    }

    public boolean toggle(@NotNull ItemComparison comparison) {
        Boolean bool = this.notDefault.get(comparison.getID());
        if (bool == null) {
            bool = !comparison.isEnabledByDefault();
            this.notDefault.put(comparison.getID(), bool);
        } else if ((bool = Boolean.valueOf(bool == false)).equals(comparison.isEnabledByDefault())) {
            this.notDefault.remove(comparison.getID());
        } else {
            this.notDefault.put(comparison.getID(), bool);
        }
        if (bool.booleanValue()) {
            this.effective.add(comparison);
            this.updated();
            return true;
        }
        this.effective.remove(comparison);
        return false;
    }

    private void updated() {
        Collections.sort(this.effective, Comparator.comparing(ItemComparison::hasPriority));
    }

    public boolean isSimilar(@NotNull ItemStack item1, @NotNull ItemStack item2) {
        boolean meta1 = item1.hasItemMeta();
        boolean meta2 = item2.hasItemMeta();
        boolean lastResult = true;
        for (ItemComparison comparison : this.effective) {
            if (!comparison.hasPriority() && !lastResult) {
                return false;
            }
            Boolean result = null;
            if (comparison.isMetaNeeded()) {
                if (meta1 != meta2) {
                    result = false;
                } else if (!meta1) {
                    result = true;
                }
            }
            if (result == null) {
                result = comparison.isSimilar(item1, item2);
            }
            if (result.booleanValue() && comparison.hasPriority()) {
                return true;
            }
            lastResult = result;
        }
        return lastResult;
    }

    public boolean containsItems(@NotNull Inventory inv, @NotNull ItemStack i, int amount) {
        for (ItemStack item : inv.getContents()) {
            if (item == null || !this.isSimilar(item, i)) continue;
            if (item.getAmount() == amount) {
                return true;
            }
            if (item.getAmount() > amount) {
                return true;
            }
            if (item.getAmount() >= amount) continue;
            amount -= item.getAmount();
        }
        return false;
    }

    public void removeItems(@NotNull Inventory inv, @NotNull ItemStack i) {
        int amount = i.getAmount();
        if (amount <= 0) {
            return;
        }
        ItemStack[] items = inv.getContents();
        for (int slot = 0; slot < items.length; ++slot) {
            ItemStack item = items[slot];
            if (item == null || !this.isSimilar(item, i)) continue;
            if (item.getAmount() == amount) {
                inv.setItem(slot, new ItemStack(Material.AIR));
                return;
            }
            if (item.getAmount() > amount) {
                item.setAmount(item.getAmount() - amount);
                return;
            }
            if (item.getAmount() >= amount) continue;
            amount -= item.getAmount();
            inv.setItem(slot, new ItemStack(Material.AIR));
        }
    }

    @NotNull
    public ItemComparisonMap clone() {
        return new ItemComparisonMap(new HashMap<String, Boolean>(this.notDefault));
    }
}

