/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.api.data;

import com.google.common.collect.ImmutableMap;
import fr.skytasul.quests.api.data.SavableData;
import fr.skytasul.quests.api.utils.CustomizedObjectTypeAdapter;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class SQLDataSaver<T> {
    private static final SQLType<Date> TYPE_DATE = new SQLType<Date>(93, "TIMESTAMP", (resultSet, column) -> new Date(resultSet.getTimestamp(column).getTime())){

        @Override
        public Object convert(Date obj) {
            return new Timestamp(obj.getTime());
        }
    };
    private static final SQLType<Character> TYPE_CHAR = new SQLType<Character>(1, "CHAR(1)", (resultSet, column) -> Character.valueOf(resultSet.getString(column).charAt(0))){

        @Override
        public Object convert(Character obj) {
            return obj.toString();
        }
    }.omitLength();
    private static final SQLType<String> TYPE_STRING = new SQLType<String>(12, "VARCHAR", ResultSet::getString).requiresLength();
    private static final SQLType<Boolean> TYPE_BOOLEAN = new SQLType<Boolean>(16, "BOOLEAN", ResultSet::getBoolean);
    private static final SQLType<Float> TYPE_FLOAT = new SQLType<Float>(6, "FLOAT", ResultSet::getFloat);
    private static final SQLType<Double> TYPE_DOUBLE = new SQLType<Double>(8, "DOUBLE", ResultSet::getDouble);
    private static final SQLType<Long> TYPE_BIGINT = new SQLType<Long>(-5, "BIGINT", ResultSet::getLong);
    private static final SQLType<Integer> TYPE_INT = new SQLType<Integer>(4, "INTEGER", ResultSet::getInt);
    private static final SQLType<Short> TYPE_SMALLINT = new SQLType<Short>(5, "SMALLINT", ResultSet::getShort);
    private static final SQLType<Byte> TYPE_TINYINT = new SQLType<Byte>(-6, "TINYINT", ResultSet::getByte);
    private static final Map<Class<?>, SQLType<?>> SQL_TYPES = new HashMap((Map<Class<?>, SQLType<?>>)ImmutableMap.builder().put(Byte.TYPE, TYPE_TINYINT).put(Byte.class, TYPE_TINYINT).put(Short.TYPE, TYPE_SMALLINT).put(Short.class, TYPE_SMALLINT).put(Integer.TYPE, TYPE_INT).put(Integer.class, TYPE_INT).put(Long.TYPE, TYPE_BIGINT).put(Long.class, TYPE_BIGINT).put(Double.TYPE, TYPE_DOUBLE).put(Double.class, TYPE_DOUBLE).put(Float.TYPE, TYPE_FLOAT).put(Float.class, TYPE_FLOAT).put(Boolean.TYPE, TYPE_BOOLEAN).put(Boolean.class, TYPE_BOOLEAN).put(Character.TYPE, TYPE_CHAR).put(Character.class, TYPE_CHAR).put(String.class, TYPE_STRING).put(Date.class, TYPE_DATE).build());

    private SQLDataSaver() {
    }

    @NotNull
    private static <T> SQLType<T> getSqlType(@NotNull SavableData<T> data) {
        return SQL_TYPES.computeIfAbsent(data.getDataType(), JsonSQLType::new);
    }

    @NotNull
    private static String getLength(@NotNull SavableData<?> data) {
        SQLType<?> sqlType = SQLDataSaver.getSqlType(data);
        if (sqlType.omitLength) {
            return "";
        }
        if (data.getMaxLength().isPresent()) {
            return "(%d)".formatted(data.getMaxLength().getAsInt());
        }
        if (sqlType.requiresLength) {
            throw new IllegalArgumentException("Column " + data.getColumnName() + " requires a max length.");
        }
        return "";
    }

    @NotNull
    public static String getColumnDefinition(@NotNull SavableData<?> data) {
        return "`%s` %s%s DEFAULT %s".formatted(data.getColumnName(), SQLDataSaver.getSqlType(data).sqlTypeName, SQLDataSaver.getLength(data), Objects.toString(data.getDefaultValue()));
    }

    public static <T> void setInStatement(@NotNull SavableData<T> data, @NotNull PreparedStatement statement, int index, T value) throws SQLException {
        SQLType<T> sqlType = SQLDataSaver.getSqlType(data);
        statement.setObject(index, sqlType.convert(value), sqlType.jdbcTypeCode);
    }

    public static <T> T getFromResultSet(@NotNull SavableData<T> data, @NotNull ResultSet resultSet) throws SQLException {
        return SQLDataSaver.getSqlType(data).getter.get(resultSet, data.getColumnName());
    }

    private static class SQLType<T> {
        private final int jdbcTypeCode;
        private final String sqlTypeName;
        private final ResultSetProcessor<T> getter;
        private boolean requiresLength = false;
        private boolean omitLength = false;

        private SQLType(int jdbcTypeCode, String sqlTypeName, ResultSetProcessor<T> getter) {
            this.jdbcTypeCode = jdbcTypeCode;
            this.sqlTypeName = sqlTypeName;
            this.getter = getter;
        }

        public SQLType<T> requiresLength() {
            this.requiresLength = true;
            return this;
        }

        public SQLType<T> omitLength() {
            this.omitLength = true;
            return this;
        }

        public Object convert(T obj) {
            return obj;
        }
    }

    @FunctionalInterface
    public static interface ResultSetProcessor<T> {
        public T get(ResultSet var1, String var2) throws SQLException;
    }

    private static class JsonSQLType<T>
    extends SQLType<T> {
        private JsonSQLType(Class<T> type) {
            super(12, "JSON", (resultSet, column) -> {
                String json = resultSet.getString(column);
                return CustomizedObjectTypeAdapter.GSON.fromJson(json, type);
            });
        }

        @Override
        public Object convert(T obj) {
            return CustomizedObjectTypeAdapter.GSON.toJson(obj);
        }
    }
}

