/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.api.data;

import java.util.Objects;
import java.util.OptionalInt;

public final class SavableData<T> {
    private final String id;
    private final Class<T> dataType;
    private final T defaultValue;
    private final OptionalInt maxLength;
    private String columnName;

    public SavableData(String id, Class<T> dataType, T defaultValue) {
        this(id, dataType, defaultValue, OptionalInt.empty());
    }

    public SavableData(String id, Class<T> dataType, T defaultValue, OptionalInt maxLength) {
        if (id == null || id.isEmpty()) {
            throw new IllegalArgumentException("Data id cannot be null or empty");
        }
        if (dataType == null) {
            throw new IllegalArgumentException("Data type cannot be null");
        }
        if (maxLength == null) {
            throw new IllegalArgumentException("Data max length cannot be a null optional");
        }
        this.id = id;
        this.dataType = dataType;
        this.defaultValue = defaultValue;
        this.maxLength = maxLength;
    }

    public String getId() {
        return this.id;
    }

    public Class<T> getDataType() {
        return this.dataType;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public OptionalInt getMaxLength() {
        return this.maxLength;
    }

    public String getColumnName() {
        return this.columnName == null ? this.id : this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public int hashCode() {
        int hash = 7;
        hash = hash * 23 + this.id.hashCode();
        hash = hash * 23 + this.dataType.hashCode();
        hash = hash * 23 + this.maxLength.hashCode();
        hash = hash * 23 + Objects.hashCode(this.defaultValue);
        return hash;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SavableData)) {
            return false;
        }
        SavableData oth = (SavableData)obj;
        return oth.id.equals(this.id) && oth.dataType.equals(this.dataType) && Objects.equals(oth.defaultValue, this.defaultValue) && oth.maxLength.equals(this.maxLength);
    }
}

