/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.api.editors;

import fr.skytasul.quests.api.editors.Editor;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.npcs.dialogs.Dialog;
import fr.skytasul.quests.api.npcs.dialogs.Message;
import fr.skytasul.quests.api.utils.messaging.DefaultErrors;
import fr.skytasul.quests.api.utils.messaging.HasPlaceholders;
import fr.skytasul.quests.api.utils.messaging.MessageUtils;
import fr.skytasul.quests.api.utils.messaging.PlaceholderRegistry;
import fr.skytasul.quests.api.utils.messaging.PlaceholdersContext;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class DialogEditor
extends Editor {
    private Runnable end;
    public Dialog d;

    public DialogEditor(Player p, Runnable end, Dialog dialog) {
        super(p, null);
        this.end = end;
        this.d = dialog;
    }

    @Override
    public boolean chat(String coloredMessage, String strippedMessage) {
        Command cmd;
        String[] args = strippedMessage.split(" ");
        String[] argsColored = coloredMessage.split(" ");
        String msg = "";
        boolean hasMsg = false;
        try {
            cmd = Command.valueOf(args[0].toUpperCase());
        }
        catch (IllegalArgumentException ex) {
            Lang.COMMAND_DOESNT_EXIST_NOSLASH.send((CommandSender)this.player);
            return false;
        }
        if (args.length > 1) {
            msg = Arrays.stream(argsColored).skip(1L).collect(Collectors.joining(" "));
            hasMsg = true;
        }
        switch (cmd.ordinal()) {
            case 0: 
            case 1: 
            case 2: {
                if (!hasMsg) {
                    Lang.DIALOG_MESSAGE_SYNTAX.send((CommandSender)this.player, PlaceholderRegistry.of("command", (Object)cmd));
                    break;
                }
                this.d.add(msg, Message.Sender.valueOf(cmd.name()));
                Lang.valueOf("DIALOG_MSG_ADDED_" + cmd.name()).send((CommandSender)this.player, PlaceholderRegistry.of("msg", msg));
                break;
            }
            case 3: {
                if (!hasMsg) {
                    Lang.DIALOG_REMOVE_SYNTAX.send((CommandSender)this.player);
                    break;
                }
                try {
                    int index = Integer.parseInt(args[1]);
                    Message removed = this.d.getMessages().remove(index);
                    if (removed != null) {
                        Lang.DIALOG_MSG_REMOVED.send((CommandSender)this.player, PlaceholderRegistry.of("msg", removed.text));
                        break;
                    }
                    DefaultErrors.sendOutOfBounds(this.getPlayerAudience(), index, 0, this.d.getMessages().size());
                }
                catch (IllegalArgumentException ex) {
                    DefaultErrors.sendInvalidNumber(this.getPlayerAudience(), args[1]);
                }
                break;
            }
            case 4: {
                for (int i = 0; i < this.d.getMessages().size(); ++i) {
                    Message dmsg = this.d.getMessages().get(i);
                    MessageUtils.sendRawMessage((CommandSender)this.player, "\u00a76{index}: \u00a77\"{msg}\u00a77\"\u00a7e by \u00a7l{sender}", PlaceholderRegistry.of("index", i, "msg", dmsg.text, "sender", dmsg.sender.name().toLowerCase()), PlaceholdersContext.DEFAULT_CONTEXT);
                }
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                if (args.length < 3) {
                    Lang.DIALOG_MESSAGE_SYNTAX.send((CommandSender)this.player, PlaceholderRegistry.of("command", String.valueOf((Object)cmd) + " <id>"));
                    break;
                }
                try {
                    msg = Arrays.stream(argsColored).skip(2L).collect(Collectors.joining(" "));
                    Message.Sender sender = Message.Sender.valueOf(cmd.name().replace("INSERT", ""));
                    this.d.insert(msg, sender, Integer.parseInt(args[1]));
                    Lang.valueOf("DIALOG_MSG_ADDED_" + cmd.name()).send((CommandSender)this.player, PlaceholderRegistry.of("msg", msg));
                }
                catch (NumberFormatException ex) {
                    DefaultErrors.sendInvalidNumber(this.getPlayerAudience(), args[1]);
                }
                break;
            }
            case 10: {
                if (args.length < 3) {
                    Lang.DIALOG_MESSAGE_SYNTAX.send((CommandSender)this.player, PlaceholderRegistry.of("command", String.valueOf((Object)cmd) + " <id>"));
                    break;
                }
                try {
                    Message message = this.d.getMessages().get(Integer.parseInt(args[1]));
                    message.text = msg = Arrays.stream(argsColored).skip(2L).collect(Collectors.joining(" "));
                    Lang.DIALOG_MSG_EDITED.send((CommandSender)this.player, PlaceholderRegistry.of("msg", msg));
                }
                catch (IllegalArgumentException ex) {
                    DefaultErrors.sendInvalidNumber(this.getPlayerAudience(), args[1]);
                }
                catch (IndexOutOfBoundsException ex) {
                    DefaultErrors.sendOutOfBounds(this.getPlayerAudience(), Integer.parseInt(args[1]), 0, this.d.getMessages().size());
                }
                break;
            }
            case 11: {
                if (args.length < 3) {
                    Lang.TEXTLIST_SYNTAX.send((CommandSender)this.player, PlaceholderRegistry.of("command", "addSound <id> <sound>"));
                    break;
                }
                try {
                    Message imsg = this.d.getMessages().get(Integer.parseInt(args[1]));
                    HasPlaceholders[] hasPlaceholdersArray = new HasPlaceholders[1];
                    imsg.sound = args[2];
                    hasPlaceholdersArray[0] = PlaceholderRegistry.of("sound", imsg.sound, "msg", args[1]);
                    Lang.DIALOG_SOUND_ADDED.send((CommandSender)this.player, hasPlaceholdersArray);
                }
                catch (IllegalArgumentException ex) {
                    DefaultErrors.sendInvalidNumber(this.getPlayerAudience(), args[1]);
                }
                catch (IndexOutOfBoundsException ex) {
                    DefaultErrors.sendOutOfBounds(this.getPlayerAudience(), Integer.parseInt(args[1]), 0, this.d.getMessages().size());
                }
                break;
            }
            case 12: {
                if (args.length < 3) {
                    Lang.TEXTLIST_SYNTAX.send((CommandSender)this.player, PlaceholderRegistry.of("command", "setTime <id> <time in ticks>"));
                    break;
                }
                try {
                    Message imsg = this.d.getMessages().get(Integer.parseInt(args[1]));
                    int time = Integer.parseInt(args[2]);
                    if (time < 0) {
                        imsg.wait = -1;
                        Lang.DIALOG_TIME_REMOVED.send((CommandSender)this.player, PlaceholderRegistry.of("msg", args[1]));
                        break;
                    }
                    imsg.wait = time;
                    HasPlaceholders[] hasPlaceholdersArray = new HasPlaceholders[1];
                    imsg.wait = time;
                    hasPlaceholdersArray[0] = PlaceholderRegistry.of("msg", args[1], "time", imsg.wait);
                    Lang.DIALOG_TIME_SET.send((CommandSender)this.player, hasPlaceholdersArray);
                }
                catch (IllegalArgumentException ex) {
                    DefaultErrors.sendInvalidNumber(this.getPlayerAudience(), args[1]);
                }
                catch (IndexOutOfBoundsException ex) {
                    DefaultErrors.sendOutOfBounds(this.getPlayerAudience(), Integer.parseInt(args[1]), 0, this.d.getMessages().size());
                }
                break;
            }
            case 13: {
                if (args.length < 2) {
                    Lang.DIALOG_NPCNAME_UNSET.send((CommandSender)this.player, PlaceholderRegistry.of("old_name", this.d.getNpcName()));
                    this.d.setNpcName(null);
                    break;
                }
                String oldName = this.d.getNpcName();
                this.d.setNpcName(msg);
                Lang.DIALOG_NPCNAME_SET.send((CommandSender)this.player, PlaceholderRegistry.of("old_name", oldName, "new_name", msg));
                break;
            }
            case 14: {
                String prev = this.d.getSkippableStatus();
                if (args.length < 2) {
                    this.d.setSkippable(null);
                    Lang.DIALOG_SKIPPABLE_UNSET.send((CommandSender)this.player, PlaceholderRegistry.of("old_state", prev));
                    break;
                }
                this.d.setSkippable(Boolean.parseBoolean(args[1]));
                Lang.DIALOG_SKIPPABLE_SET.send((CommandSender)this.player, PlaceholderRegistry.of("old_state", prev, "new_state", this.d.getSkippableStatus()));
                break;
            }
            case 15: {
                Lang.DIALOG_CLEARED.send((CommandSender)this.player, PlaceholderRegistry.of("amount", this.d.getMessages().size()));
                this.d.getMessages().clear();
                break;
            }
            case 5: {
                for (Lang l : Lang.values()) {
                    if (!l.getPath().startsWith("msg.editor.dialog.help.")) continue;
                    l.send((CommandSender)this.player);
                }
                break;
            }
            case 6: {
                this.stop();
                this.end.run();
            }
        }
        return true;
    }

    private static enum Command {
        NPC,
        PLAYER,
        NOSENDER,
        REMOVE,
        LIST,
        HELP,
        CLOSE,
        NPCINSERT,
        PLAYERINSERT,
        NOSENDERINSERT,
        EDIT,
        ADDSOUND,
        SETTIME,
        NPCNAME,
        SKIPPABLE,
        CLEAR;

    }
}

