/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.api.editors;

import fr.skytasul.quests.api.QuestsPlugin;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.utils.AutoRegistered;
import fr.skytasul.quests.api.utils.ChatColorUtils;
import net.kyori.adventure.audience.Audience;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@AutoRegistered
public abstract class Editor {
    @NotNull
    protected final Player player;
    @NotNull
    protected final Runnable cancel;
    private boolean started = false;

    protected Editor(@NotNull Player player, @NotNull Runnable cancel) {
        this.player = player;
        this.cancel = cancel;
    }

    @NotNull
    public Player getPlayer() {
        return this.player;
    }

    @NotNull
    protected Audience getPlayerAudience() {
        return QuestsPlugin.getPlugin().getAudiences().player(this.player);
    }

    public void begin() {
        if (this.started) {
            throw new IllegalStateException("Editor already started");
        }
        this.started = true;
    }

    public void end() {
        if (!this.started) {
            throw new IllegalStateException("Editor did not started");
        }
        this.started = false;
    }

    public final void start() {
        QuestsPlugin.getPlugin().getEditorManager().start(this);
    }

    public final void stop() {
        QuestsPlugin.getPlugin().getEditorManager().stop(this);
    }

    public final void cancel() {
        this.cancel.run();
        QuestsPlugin.getPlugin().getEditorManager().stop(this);
    }

    public boolean chat(String coloredMessage, String strippedMessage) {
        return false;
    }

    public final void callChat(String rawText) {
        rawText = rawText.trim().replaceAll("\\uFEFF", "");
        QuestsPlugin.getPlugin().getLoggerExpanded().debug(this.player.getName() + " entered \"" + rawText + "\" (" + rawText.length() + " characters) in an editor. (name: " + this.getClass().getName() + ")");
        String coloredMessage = ChatColorUtils.translateHexColorCodes(ChatColor.translateAlternateColorCodes((char)'&', (String)rawText));
        String strippedMessage = ChatColor.stripColor((String)rawText);
        if (strippedMessage.equalsIgnoreCase(this.cancelWord())) {
            this.cancel();
        } else if (!this.chat(coloredMessage, strippedMessage)) {
            Lang.CHAT_EDITOR.send((CommandSender)this.player);
        }
    }

    protected String cancelWord() {
        return null;
    }
}

