/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.api.editors;

import fr.skytasul.quests.api.editors.Editor;
import fr.skytasul.quests.api.editors.parsers.AbstractParser;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.utils.messaging.DefaultErrors;
import fr.skytasul.quests.api.utils.messaging.PlaceholderRegistry;
import java.util.function.Consumer;
import org.apache.commons.lang.Validate;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TextEditor<T>
extends Editor {
    protected Consumer<T> run;
    protected Runnable nul;
    protected AbstractParser<T> parser;
    protected boolean useStripped = false;
    protected boolean nullIntoConsumer = false;

    public TextEditor(Player p, Runnable cancel, Consumer<T> end) {
        this(p, cancel, end, null, null);
    }

    public TextEditor(Player p, Runnable cancel, Consumer<T> end, Runnable nul) {
        this(p, cancel, end, nul, null);
    }

    public TextEditor(Player p, Runnable cancel, Consumer<T> end, AbstractParser<T> parser) {
        this(p, cancel, end, null, parser);
    }

    public TextEditor(Player p, Runnable cancel, Consumer<T> end, Runnable nul, AbstractParser<T> parser) {
        super(p, cancel);
        this.run = end;
        this.parser = parser;
        this.nul = nul;
    }

    public TextEditor<T> passNullIntoEndConsumer() {
        Validate.isTrue((this.nul == null ? 1 : 0) != 0);
        this.nullIntoConsumer = true;
        return this;
    }

    public TextEditor<T> useStrippedMessage() {
        this.useStripped = true;
        return this;
    }

    @Override
    public boolean chat(String msg, String strippedMessage) {
        boolean invalid;
        String returnment;
        block11: {
            if (strippedMessage.equals("null")) {
                if (this.nul == null && !this.nullIntoConsumer) {
                    Lang.ARG_NOT_SUPPORTED.send((CommandSender)this.player, PlaceholderRegistry.of("arg", "null"));
                    return false;
                }
                this.stop();
                if (this.nullIntoConsumer) {
                    this.run.accept(null);
                } else {
                    this.nul.run();
                }
                return true;
            }
            if (strippedMessage.equals("cancel") && this.cancel != null) {
                this.cancel();
                return true;
            }
            returnment = null;
            invalid = false;
            if (this.parser != null) {
                try {
                    T tmp = this.parser.parse(this.player, strippedMessage);
                    if (tmp == null) {
                        invalid = true;
                        break block11;
                    }
                    returnment = tmp;
                }
                catch (Throwable ex) {
                    DefaultErrors.sendGeneric(this.getPlayerAudience(), strippedMessage + " parsingText");
                    invalid = true;
                    ex.printStackTrace();
                }
            } else {
                String string = returnment = this.useStripped ? strippedMessage : msg;
            }
        }
        if (!invalid) {
            this.stop();
            this.run.accept(returnment);
            return true;
        }
        return false;
    }

    @Override
    public void begin() {
        super.begin();
        if (this.parser != null) {
            this.parser.sendIndication(this.player);
        }
    }
}

