/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.api.editors;

import fr.skytasul.quests.api.editors.Editor;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.utils.messaging.PlaceholderRegistry;
import java.util.Arrays;
import java.util.List;
import java.util.StringJoiner;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang.Validate;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TextListEditor
extends Editor {
    protected Consumer<List<String>> run;
    public Predicate<String> valid;
    private List<String> texts;

    public TextListEditor(Player p, Consumer<List<String>> end, List<String> texts) {
        super(p, null);
        Validate.notNull(texts, (String)"Text list in Editor cannot be null.");
        this.run = end;
        this.texts = texts;
    }

    @Override
    public void begin() {
        super.begin();
        Lang.ENTER_EDITOR_LIST.send((CommandSender)this.player);
    }

    @Override
    public boolean chat(String coloredMessage, String strippedMessage) {
        Command cmd;
        String[] args = strippedMessage.split(" ");
        String msg = "";
        boolean hasMsg = false;
        try {
            cmd = Command.valueOf(args[0].toUpperCase());
        }
        catch (IllegalArgumentException ex) {
            Lang.COMMAND_DOESNT_EXIST_NOSLASH.send((CommandSender)this.player);
            return false;
        }
        if (args.length > 1) {
            msg = Arrays.stream(coloredMessage.split(" ")).skip(1L).collect(Collectors.joining(" "));
            hasMsg = true;
        }
        switch (cmd.ordinal()) {
            case 0: {
                if (!hasMsg) {
                    this.sendSyntax(" add <message>");
                    break;
                }
                if (this.valid != null && !this.valid.test(msg)) break;
                this.texts.add(msg);
                Lang.TEXTLIST_TEXT_ADDED.send((CommandSender)this.player, PlaceholderRegistry.of("msg", msg));
                break;
            }
            case 1: {
                if (!hasMsg) {
                    this.sendSyntax(" remove <id>");
                    break;
                }
                try {
                    String removed = this.texts.remove(Integer.parseInt(args[1]));
                    Lang.TEXTLIST_TEXT_REMOVED.send((CommandSender)this.player, PlaceholderRegistry.of("msg", removed));
                }
                catch (IllegalArgumentException ex) {
                    Lang.NUMBER_INVALID.send((CommandSender)this.player);
                }
                break;
            }
            case 2: {
                StringJoiner joiner = new StringJoiner("\n", "\u00a76\u00a7lList:\n", "");
                for (int i = 0; i < this.texts.size(); ++i) {
                    joiner.add("\u00a76" + i + ": \u00a7r" + this.texts.get(i));
                }
                this.player.sendMessage(joiner.toString());
                break;
            }
            case 3: {
                for (Lang l : Lang.values()) {
                    if (!l.getPath().startsWith("msg.editor.textList.help.")) continue;
                    l.send((CommandSender)this.player);
                }
                break;
            }
            case 4: {
                this.stop();
                this.run.accept(this.texts);
            }
        }
        return true;
    }

    private void sendSyntax(String command) {
        Lang.TEXTLIST_SYNTAX.send((CommandSender)this.player, PlaceholderRegistry.of("command", command));
    }

    private static enum Command {
        ADD,
        REMOVE,
        LIST,
        HELP,
        CLOSE;

    }
}

