/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.api.editors.parsers;

import fr.skytasul.quests.api.editors.parsers.AbstractParser;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.utils.messaging.PlaceholderRegistry;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CollectionParser<T>
implements AbstractParser<T> {
    protected Map<String, T> names;
    protected String namesString;

    public CollectionParser(Collection<T> collection, Function<T, String> namer) {
        this.names = collection.stream().collect(Collectors.toMap(namer, Function.identity()));
        this.namesString = String.join((CharSequence)", ", this.names.keySet());
    }

    @Override
    public T parse(Player p, String msg) throws Throwable {
        T obj = this.names.get(this.processName(msg));
        if (obj == null) {
            Lang.NO_SUCH_ELEMENT.send((CommandSender)p, PlaceholderRegistry.of("available_elements", this.namesString));
        }
        return obj;
    }

    protected String processName(String msg) {
        return msg;
    }

    @Override
    public void sendIndication(Player p) {
        Lang.AVAILABLE_ELEMENTS.send((CommandSender)p, PlaceholderRegistry.of("available_elements", this.namesString));
    }

    public String getNames() {
        return this.namesString;
    }
}

