/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.api.editors.parsers;

import fr.skytasul.quests.api.editors.parsers.AbstractParser;
import fr.skytasul.quests.api.localization.Lang;
import java.awt.Color;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ColorParser
implements AbstractParser<org.bukkit.Color> {
    public static final ColorParser PARSER = new ColorParser();
    private final Pattern hexPattern = Pattern.compile("^#([a-fA-F0-9]{6})$");
    private final Pattern rgbPattern = Pattern.compile("^\\b(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\b,? ?\\b(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\b,? ?\\b(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\b$");

    private ColorParser() {
    }

    @Override
    public org.bukkit.Color parse(Player p, String msg) throws Throwable {
        int blue;
        int green;
        int red;
        Matcher hexMatcher = this.hexPattern.matcher(msg);
        if (hexMatcher.matches()) {
            String hex = hexMatcher.group(1);
            red = Integer.parseInt(hex.substring(0, 2), 16);
            green = Integer.parseInt(hex.substring(2, 4), 16);
            blue = Integer.parseInt(hex.substring(4, 6), 16);
        } else {
            Matcher rgbMatcher = this.rgbPattern.matcher(msg);
            if (rgbMatcher.matches()) {
                red = Integer.parseInt(rgbMatcher.group(1));
                green = Integer.parseInt(rgbMatcher.group(2));
                blue = Integer.parseInt(rgbMatcher.group(3));
            } else {
                try {
                    Color awtColor = ChatColor.valueOf((String)msg.toUpperCase().replace(' ', '_')).asBungee().getColor();
                    red = awtColor.getRed();
                    green = awtColor.getGreen();
                    blue = awtColor.getBlue();
                }
                catch (IllegalArgumentException | NullPointerException ex) {
                    Lang.INVALID_COLOR.send((CommandSender)p);
                    return null;
                }
            }
        }
        return org.bukkit.Color.fromRGB((int)red, (int)green, (int)blue);
    }
}

