/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.api.editors.parsers;

import fr.skytasul.quests.api.editors.parsers.AbstractParser;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.bukkit.entity.Player;

public class DurationParser
implements AbstractParser<Long> {
    private static final Pattern DURATION_PATTERN = Pattern.compile("^(\\d+) *([a-zA-Z]*)|(\\d+) *([a-zA-Z]+)");
    private final MinecraftTimeUnit targetUnit;
    private final MinecraftTimeUnit defaultUnit;

    public DurationParser(MinecraftTimeUnit targetUnit) {
        this(targetUnit, targetUnit);
    }

    public DurationParser(MinecraftTimeUnit targetUnit, MinecraftTimeUnit defaultUnit) {
        this.targetUnit = targetUnit;
        this.defaultUnit = defaultUnit;
    }

    @Override
    public Long parse(Player p, String msg) throws Throwable {
        Matcher matcher = DURATION_PATTERN.matcher(msg);
        long duration = 0L;
        while (matcher.find()) {
            MinecraftTimeUnit munit;
            String unit;
            String num = matcher.group(1);
            if (StringUtils.isEmpty((String)num)) {
                num = matcher.group(3);
            }
            if (StringUtils.isEmpty((String)(unit = matcher.group(2)))) {
                unit = matcher.group(4);
            }
            MinecraftTimeUnit minecraftTimeUnit = munit = StringUtils.isEmpty((String)unit) ? this.defaultUnit : MinecraftTimeUnit.of(unit);
            if (munit == null) {
                p.sendMessage("\u00a7cUnknown unit " + unit);
                return null;
            }
            duration += munit.in(this.targetUnit, Long.parseLong(num));
        }
        return duration;
    }

    public static enum MinecraftTimeUnit {
        TICK(0, "tick", "ticks", "t"),
        SECOND(20, "second", "seconds", "s", "sec"),
        MINUTE(60, "minute", "minutes", "m", "min"),
        HOUR(60, "hour", "hours", "h"),
        DAY(24, "day", "days", "d"),
        WEEK(7, "week", "weeks", "w");

        private static final Map<String, MinecraftTimeUnit> UNITS;
        private int previousDuration;
        private String[] names;
        private DurationParser cachedParser;

        private MinecraftTimeUnit(int previousDuration, String ... names) {
            this.previousDuration = previousDuration;
            this.names = names;
        }

        public DurationParser getParser() {
            if (this.cachedParser == null) {
                this.cachedParser = new DurationParser(this, this);
            }
            return this.cachedParser;
        }

        public long in(MinecraftTimeUnit unit, long duration) {
            if (this.ordinal() < unit.ordinal()) {
                return 0L;
            }
            long finalDuration = duration;
            for (int i = this.ordinal(); i > unit.ordinal(); --i) {
                MinecraftTimeUnit previous = MinecraftTimeUnit.values()[i];
                finalDuration *= (long)previous.previousDuration;
            }
            return finalDuration;
        }

        public static MinecraftTimeUnit of(String name) {
            return UNITS.get(name.toLowerCase());
        }

        static {
            UNITS = new HashMap<String, MinecraftTimeUnit>();
            for (MinecraftTimeUnit unit : MinecraftTimeUnit.values()) {
                for (String name : unit.names) {
                    UNITS.put(name, unit);
                }
            }
        }
    }
}

