/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.api.editors.parsers;

import fr.skytasul.quests.api.QuestsPlugin;
import fr.skytasul.quests.api.editors.parsers.AbstractParser;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.utils.messaging.DefaultErrors;
import java.math.BigDecimal;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class NumberParser<T extends Number>
implements AbstractParser<T> {
    public static final NumberParser<Integer> INTEGER_PARSER = new NumberParser<boolean>((Class<boolean>)Integer.class, false, false);
    public static final NumberParser<Integer> INTEGER_PARSER_POSITIVE = new NumberParser<boolean>((Class<boolean>)Integer.class, true, false);
    public static final NumberParser<Integer> INTEGER_PARSER_STRICT_POSITIVE = new NumberParser<boolean>((Class<boolean>)Integer.class, true, true);
    public static final NumberParser<Double> DOUBLE_PARSER_STRICT_POSITIVE = new NumberParser<boolean>((Class<boolean>)Double.class, true, true);
    private Class<T> numberType;
    private boolean positive;
    private boolean noZero;
    private BigDecimal min;
    private BigDecimal max;

    public NumberParser(Class<T> numberType, boolean positive) {
        this((Class<boolean>)numberType, positive, false);
    }

    public NumberParser(Class<T> numberType, boolean positive, boolean noZero) {
        this.numberType = numberType;
        this.positive = positive;
        this.noZero = noZero;
    }

    public NumberParser(Class<T> numberType, T min, T max) {
        this.numberType = numberType;
        this.min = new BigDecimal(((Number)min).doubleValue());
        this.max = new BigDecimal(((Number)max).doubleValue());
    }

    @Override
    public T parse(Player p, String msg) {
        try {
            String tname = this.numberType != Integer.class ? this.numberType.getSimpleName() : "Int";
            Number number = (Number)this.numberType.getDeclaredMethod("parse" + tname, String.class).invoke(null, msg);
            if (this.positive || this.noZero) {
                int compare = new BigDecimal(msg).compareTo(new BigDecimal(0));
                if (this.positive && compare < 0) {
                    Lang.NUMBER_NEGATIVE.send((CommandSender)p);
                    return null;
                }
                if (this.noZero && compare == 0) {
                    Lang.NUMBER_ZERO.send((CommandSender)p);
                    return null;
                }
            }
            if (this.min != null || this.max != null) {
                BigDecimal bd = new BigDecimal(msg);
                if (this.min != null && bd.compareTo(this.min) < 0 || this.max != null && bd.compareTo(this.max) > 0) {
                    DefaultErrors.sendOutOfBounds(QuestsPlugin.getPlugin().getAudiences().player(p), this.min, this.max);
                    return null;
                }
            }
            return (T)number;
        }
        catch (Exception exception) {
            DefaultErrors.sendInvalidNumber(QuestsPlugin.getPlugin().getAudiences().player(p), msg);
            return null;
        }
    }
}

